/**
 * 
 *   Copyright (c) 2004-2014, Istvan David, Istvan Rath and Daniel Varro
 *   All rights reserved. This program and the accompanying materials
 *   are made available under the terms of the Eclipse Public License v1.0
 *   which accompanies this distribution, and is available at
 *   http://www.eclipse.org/legal/epl-v10.html
 *  
 *   Contributors:
 *   Istvan David - initial API and implementation
 *  
 */
package org.eclipse.viatra.cep.core.engine.runtime;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.apache.log4j.Logger;
import org.eclipse.viatra.cep.core.engine.runtime.TokenInTrapStateMatch;
import org.eclipse.viatra.cep.core.engine.runtime.util.TokenInTrapStateQuerySpecification;
import org.eclipse.viatra.cep.core.metamodels.automaton.Automaton;
import org.eclipse.viatra.cep.core.metamodels.automaton.EventToken;
import org.eclipse.viatra.query.runtime.api.IMatchProcessor;
import org.eclipse.viatra.query.runtime.api.IQuerySpecification;
import org.eclipse.viatra.query.runtime.api.ViatraQueryEngine;
import org.eclipse.viatra.query.runtime.api.impl.BaseMatcher;
import org.eclipse.viatra.query.runtime.exception.ViatraQueryException;
import org.eclipse.viatra.query.runtime.matchers.tuple.Tuple;
import org.eclipse.viatra.query.runtime.util.ViatraQueryLoggingUtil;

/**
 * Generated pattern matcher API of the org.eclipse.viatra.cep.core.engine.runtime.tokenInTrapState pattern,
 * providing pattern-specific query methods.
 * 
 * <p>Use the pattern matcher on a given model via {@link #on(ViatraQueryEngine)},
 * e.g. in conjunction with {@link ViatraQueryEngine#on(Notifier)}.
 * 
 * <p>Matches of the pattern will be represented as {@link TokenInTrapStateMatch}.
 * 
 * <p>Original source:
 * <code><pre>
 * pattern tokenInTrapState(automaton : Automaton, eventToken : EventToken) {
 * 	Automaton.trapState(automaton, trapState);
 * 	TrapState.eventTokens(trapState, eventToken);
 * }
 * </pre></code>
 * 
 * @see TokenInTrapStateMatch
 * @see TokenInTrapStateProcessor
 * @see TokenInTrapStateQuerySpecification
 * 
 */
@SuppressWarnings("all")
public class TokenInTrapStateMatcher extends BaseMatcher<TokenInTrapStateMatch> {
  /**
   * Initializes the pattern matcher within an existing VIATRA Query engine.
   * If the pattern matcher is already constructed in the engine, only a light-weight reference is returned.
   * The match set will be incrementally refreshed upon updates.
   * @param engine the existing VIATRA Query engine in which this matcher will be created.
   * @throws ViatraQueryException if an error occurs during pattern matcher creation
   * 
   */
  public static TokenInTrapStateMatcher on(final ViatraQueryEngine engine) throws ViatraQueryException {
    // check if matcher already exists
    TokenInTrapStateMatcher matcher = engine.getExistingMatcher(querySpecification());
    if (matcher == null) {
    	matcher = (TokenInTrapStateMatcher)engine.getMatcher(querySpecification());
    }
    return matcher;
  }
  
  /**
   * Initializes the pattern matcher within an existing VIATRA Query engine.
   * If the pattern matcher is already constructed in the engine, only a light-weight reference is returned.
   * The match set will be incrementally refreshed upon updates.
   * @param engine the existing VIATRA Query engine in which this matcher will be created.
   * @throws ViatraQueryException if an error occurs during pattern matcher creation
   * 
   */
  public static TokenInTrapStateMatcher create() throws ViatraQueryException {
    return new TokenInTrapStateMatcher();
  }
  
  private final static int POSITION_AUTOMATON = 0;
  
  private final static int POSITION_EVENTTOKEN = 1;
  
  private final static Logger LOGGER = ViatraQueryLoggingUtil.getLogger(TokenInTrapStateMatcher.class);
  
  /**
   * Initializes the pattern matcher within an existing VIATRA Query engine.
   * If the pattern matcher is already constructed in the engine, only a light-weight reference is returned.
   * The match set will be incrementally refreshed upon updates.
   * @param engine the existing VIATRA Query engine in which this matcher will be created.
   * @throws ViatraQueryException if an error occurs during pattern matcher creation
   * 
   */
  private TokenInTrapStateMatcher() throws ViatraQueryException {
    super(querySpecification());
  }
  
  /**
   * Returns the set of all matches of the pattern that conform to the given fixed values of some parameters.
   * @param pAutomaton the fixed value of pattern parameter automaton, or null if not bound.
   * @param pEventToken the fixed value of pattern parameter eventToken, or null if not bound.
   * @return matches represented as a TokenInTrapStateMatch object.
   * 
   */
  public Collection<TokenInTrapStateMatch> getAllMatches(final Automaton pAutomaton, final EventToken pEventToken) {
    return rawGetAllMatches(new Object[]{pAutomaton, pEventToken});
  }
  
  /**
   * Returns an arbitrarily chosen match of the pattern that conforms to the given fixed values of some parameters.
   * Neither determinism nor randomness of selection is guaranteed.
   * @param pAutomaton the fixed value of pattern parameter automaton, or null if not bound.
   * @param pEventToken the fixed value of pattern parameter eventToken, or null if not bound.
   * @return a match represented as a TokenInTrapStateMatch object, or null if no match is found.
   * 
   */
  public TokenInTrapStateMatch getOneArbitraryMatch(final Automaton pAutomaton, final EventToken pEventToken) {
    return rawGetOneArbitraryMatch(new Object[]{pAutomaton, pEventToken});
  }
  
  /**
   * Indicates whether the given combination of specified pattern parameters constitute a valid pattern match,
   * under any possible substitution of the unspecified parameters (if any).
   * @param pAutomaton the fixed value of pattern parameter automaton, or null if not bound.
   * @param pEventToken the fixed value of pattern parameter eventToken, or null if not bound.
   * @return true if the input is a valid (partial) match of the pattern.
   * 
   */
  public boolean hasMatch(final Automaton pAutomaton, final EventToken pEventToken) {
    return rawHasMatch(new Object[]{pAutomaton, pEventToken});
  }
  
  /**
   * Returns the number of all matches of the pattern that conform to the given fixed values of some parameters.
   * @param pAutomaton the fixed value of pattern parameter automaton, or null if not bound.
   * @param pEventToken the fixed value of pattern parameter eventToken, or null if not bound.
   * @return the number of pattern matches found.
   * 
   */
  public int countMatches(final Automaton pAutomaton, final EventToken pEventToken) {
    return rawCountMatches(new Object[]{pAutomaton, pEventToken});
  }
  
  /**
   * Executes the given processor on each match of the pattern that conforms to the given fixed values of some parameters.
   * @param pAutomaton the fixed value of pattern parameter automaton, or null if not bound.
   * @param pEventToken the fixed value of pattern parameter eventToken, or null if not bound.
   * @param processor the action that will process each pattern match.
   * 
   */
  public void forEachMatch(final Automaton pAutomaton, final EventToken pEventToken, final IMatchProcessor<? super TokenInTrapStateMatch> processor) {
    rawForEachMatch(new Object[]{pAutomaton, pEventToken}, processor);
  }
  
  /**
   * Executes the given processor on an arbitrarily chosen match of the pattern that conforms to the given fixed values of some parameters.
   * Neither determinism nor randomness of selection is guaranteed.
   * @param pAutomaton the fixed value of pattern parameter automaton, or null if not bound.
   * @param pEventToken the fixed value of pattern parameter eventToken, or null if not bound.
   * @param processor the action that will process the selected match.
   * @return true if the pattern has at least one match with the given parameter values, false if the processor was not invoked
   * 
   */
  public boolean forOneArbitraryMatch(final Automaton pAutomaton, final EventToken pEventToken, final IMatchProcessor<? super TokenInTrapStateMatch> processor) {
    return rawForOneArbitraryMatch(new Object[]{pAutomaton, pEventToken}, processor);
  }
  
  /**
   * Returns a new (partial) match.
   * This can be used e.g. to call the matcher with a partial match.
   * <p>The returned match will be immutable. Use {@link #newEmptyMatch()} to obtain a mutable match object.
   * @param pAutomaton the fixed value of pattern parameter automaton, or null if not bound.
   * @param pEventToken the fixed value of pattern parameter eventToken, or null if not bound.
   * @return the (partial) match object.
   * 
   */
  public TokenInTrapStateMatch newMatch(final Automaton pAutomaton, final EventToken pEventToken) {
    return TokenInTrapStateMatch.newMatch(pAutomaton, pEventToken);
  }
  
  /**
   * Retrieve the set of values that occur in matches for automaton.
   * @return the Set of all values, null if no parameter with the given name exists, empty set if there are no matches
   * 
   */
  protected Set<Automaton> rawAccumulateAllValuesOfautomaton(final Object[] parameters) {
    Set<Automaton> results = new HashSet<Automaton>();
    rawAccumulateAllValues(POSITION_AUTOMATON, parameters, results);
    return results;
  }
  
  /**
   * Retrieve the set of values that occur in matches for automaton.
   * @return the Set of all values, null if no parameter with the given name exists, empty set if there are no matches
   * 
   */
  public Set<Automaton> getAllValuesOfautomaton() {
    return rawAccumulateAllValuesOfautomaton(emptyArray());
  }
  
  /**
   * Retrieve the set of values that occur in matches for automaton.
   * @return the Set of all values, null if no parameter with the given name exists, empty set if there are no matches
   * 
   */
  public Set<Automaton> getAllValuesOfautomaton(final TokenInTrapStateMatch partialMatch) {
    return rawAccumulateAllValuesOfautomaton(partialMatch.toArray());
  }
  
  /**
   * Retrieve the set of values that occur in matches for automaton.
   * @return the Set of all values, null if no parameter with the given name exists, empty set if there are no matches
   * 
   */
  public Set<Automaton> getAllValuesOfautomaton(final EventToken pEventToken) {
    return rawAccumulateAllValuesOfautomaton(new Object[]{
    null, 
    pEventToken
    });
  }
  
  /**
   * Retrieve the set of values that occur in matches for eventToken.
   * @return the Set of all values, null if no parameter with the given name exists, empty set if there are no matches
   * 
   */
  protected Set<EventToken> rawAccumulateAllValuesOfeventToken(final Object[] parameters) {
    Set<EventToken> results = new HashSet<EventToken>();
    rawAccumulateAllValues(POSITION_EVENTTOKEN, parameters, results);
    return results;
  }
  
  /**
   * Retrieve the set of values that occur in matches for eventToken.
   * @return the Set of all values, null if no parameter with the given name exists, empty set if there are no matches
   * 
   */
  public Set<EventToken> getAllValuesOfeventToken() {
    return rawAccumulateAllValuesOfeventToken(emptyArray());
  }
  
  /**
   * Retrieve the set of values that occur in matches for eventToken.
   * @return the Set of all values, null if no parameter with the given name exists, empty set if there are no matches
   * 
   */
  public Set<EventToken> getAllValuesOfeventToken(final TokenInTrapStateMatch partialMatch) {
    return rawAccumulateAllValuesOfeventToken(partialMatch.toArray());
  }
  
  /**
   * Retrieve the set of values that occur in matches for eventToken.
   * @return the Set of all values, null if no parameter with the given name exists, empty set if there are no matches
   * 
   */
  public Set<EventToken> getAllValuesOfeventToken(final Automaton pAutomaton) {
    return rawAccumulateAllValuesOfeventToken(new Object[]{
    pAutomaton, 
    null
    });
  }
  
  @Override
  protected TokenInTrapStateMatch tupleToMatch(final Tuple t) {
    try {
    	return TokenInTrapStateMatch.newMatch((Automaton) t.get(POSITION_AUTOMATON), (EventToken) t.get(POSITION_EVENTTOKEN));
    } catch(ClassCastException e) {
    	LOGGER.error("Element(s) in tuple not properly typed!",e);
    	return null;
    }
  }
  
  @Override
  protected TokenInTrapStateMatch arrayToMatch(final Object[] match) {
    try {
    	return TokenInTrapStateMatch.newMatch((Automaton) match[POSITION_AUTOMATON], (EventToken) match[POSITION_EVENTTOKEN]);
    } catch(ClassCastException e) {
    	LOGGER.error("Element(s) in array not properly typed!",e);
    	return null;
    }
  }
  
  @Override
  protected TokenInTrapStateMatch arrayToMatchMutable(final Object[] match) {
    try {
    	return TokenInTrapStateMatch.newMutableMatch((Automaton) match[POSITION_AUTOMATON], (EventToken) match[POSITION_EVENTTOKEN]);
    } catch(ClassCastException e) {
    	LOGGER.error("Element(s) in array not properly typed!",e);
    	return null;
    }
  }
  
  /**
   * @return the singleton instance of the query specification of this pattern
   * @throws ViatraQueryException if the pattern definition could not be loaded
   * 
   */
  public static IQuerySpecification<TokenInTrapStateMatcher> querySpecification() throws ViatraQueryException {
    return TokenInTrapStateQuerySpecification.instance();
  }
}
