/**
 * 
 *   Copyright (c) 2004-2014, Istvan David, Istvan Rath and Daniel Varro
 *   All rights reserved. This program and the accompanying materials
 *   are made available under the terms of the Eclipse Public License v1.0
 *   which accompanies this distribution, and is available at
 *   http://www.eclipse.org/legal/epl-v10.html
 *  
 *   Contributors:
 *   Istvan David - initial API and implementation
 *  
 */
package org.eclipse.viatra.cep.core.engine.runtime;

import java.util.Arrays;
import java.util.List;
import org.eclipse.viatra.cep.core.engine.runtime.util.TransitionWithEventTypeQuerySpecification;
import org.eclipse.viatra.cep.core.metamodels.automaton.Transition;
import org.eclipse.viatra.query.runtime.api.IPatternMatch;
import org.eclipse.viatra.query.runtime.api.impl.BasePatternMatch;
import org.eclipse.viatra.query.runtime.exception.ViatraQueryException;

/**
 * Pattern-specific match representation of the org.eclipse.viatra.cep.core.engine.runtime.transitionWithEventType pattern,
 * to be used in conjunction with {@link TransitionWithEventTypeMatcher}.
 * 
 * <p>Class fields correspond to parameters of the pattern. Fields with value null are considered unassigned.
 * Each instance is a (possibly partial) substitution of pattern parameters,
 * usable to represent a match of the pattern in the result of a query,
 * or to specify the bound (fixed) input parameters when issuing a query.
 * 
 * @see TransitionWithEventTypeMatcher
 * @see TransitionWithEventTypeProcessor
 * 
 */
@SuppressWarnings("all")
public abstract class TransitionWithEventTypeMatch extends BasePatternMatch {
  private Transition fTransition;
  
  private String fEventType;
  
  private static List<String> parameterNames = makeImmutableList("transition", "eventType");
  
  private TransitionWithEventTypeMatch(final Transition pTransition, final String pEventType) {
    this.fTransition = pTransition;
    this.fEventType = pEventType;
  }
  
  @Override
  public Object get(final String parameterName) {
    if ("transition".equals(parameterName)) return this.fTransition;
    if ("eventType".equals(parameterName)) return this.fEventType;
    return null;
  }
  
  public Transition getTransition() {
    return this.fTransition;
  }
  
  public String getEventType() {
    return this.fEventType;
  }
  
  @Override
  public boolean set(final String parameterName, final Object newValue) {
    if (!isMutable()) throw new java.lang.UnsupportedOperationException();
    if ("transition".equals(parameterName) ) {
    	this.fTransition = (Transition) newValue;
    	return true;
    }
    if ("eventType".equals(parameterName) ) {
    	this.fEventType = (String) newValue;
    	return true;
    }
    return false;
  }
  
  public void setTransition(final Transition pTransition) {
    if (!isMutable()) throw new java.lang.UnsupportedOperationException();
    this.fTransition = pTransition;
  }
  
  public void setEventType(final String pEventType) {
    if (!isMutable()) throw new java.lang.UnsupportedOperationException();
    this.fEventType = pEventType;
  }
  
  @Override
  public String patternName() {
    return "org.eclipse.viatra.cep.core.engine.runtime.transitionWithEventType";
  }
  
  @Override
  public List<String> parameterNames() {
    return TransitionWithEventTypeMatch.parameterNames;
  }
  
  @Override
  public Object[] toArray() {
    return new Object[]{fTransition, fEventType};
  }
  
  @Override
  public TransitionWithEventTypeMatch toImmutable() {
    return isMutable() ? newMatch(fTransition, fEventType) : this;
  }
  
  @Override
  public String prettyPrint() {
    StringBuilder result = new StringBuilder();
    result.append("\"transition\"=" + prettyPrintValue(fTransition) + ", ");
    
    result.append("\"eventType\"=" + prettyPrintValue(fEventType)
    );
    return result.toString();
  }
  
  @Override
  public int hashCode() {
    final int prime = 31;
    int result = 1;
    result = prime * result + ((fTransition == null) ? 0 : fTransition.hashCode());
    result = prime * result + ((fEventType == null) ? 0 : fEventType.hashCode());
    return result;
  }
  
  @Override
  public boolean equals(final Object obj) {
    if (this == obj)
    	return true;
    if (!(obj instanceof TransitionWithEventTypeMatch)) { // this should be infrequent
    	if (obj == null) {
    		return false;
    	}
    	if (!(obj instanceof IPatternMatch)) {
    		return false;
    	}
    	IPatternMatch otherSig  = (IPatternMatch) obj;
    	if (!specification().equals(otherSig.specification()))
    		return false;
    	return Arrays.deepEquals(toArray(), otherSig.toArray());
    }
    TransitionWithEventTypeMatch other = (TransitionWithEventTypeMatch) obj;
    if (fTransition == null) {if (other.fTransition != null) return false;}
    else if (!fTransition.equals(other.fTransition)) return false;
    if (fEventType == null) {if (other.fEventType != null) return false;}
    else if (!fEventType.equals(other.fEventType)) return false;
    return true;
  }
  
  @Override
  public TransitionWithEventTypeQuerySpecification specification() {
    try {
    	return TransitionWithEventTypeQuerySpecification.instance();
    } catch (ViatraQueryException ex) {
     	// This cannot happen, as the match object can only be instantiated if the query specification exists
     	throw new IllegalStateException (ex);
    }
  }
  
  /**
   * Returns an empty, mutable match.
   * Fields of the mutable match can be filled to create a partial match, usable as matcher input.
   * 
   * @return the empty match.
   * 
   */
  public static TransitionWithEventTypeMatch newEmptyMatch() {
    return new Mutable(null, null);
  }
  
  /**
   * Returns a mutable (partial) match.
   * Fields of the mutable match can be filled to create a partial match, usable as matcher input.
   * 
   * @param pTransition the fixed value of pattern parameter transition, or null if not bound.
   * @param pEventType the fixed value of pattern parameter eventType, or null if not bound.
   * @return the new, mutable (partial) match object.
   * 
   */
  public static TransitionWithEventTypeMatch newMutableMatch(final Transition pTransition, final String pEventType) {
    return new Mutable(pTransition, pEventType);
  }
  
  /**
   * Returns a new (partial) match.
   * This can be used e.g. to call the matcher with a partial match.
   * <p>The returned match will be immutable. Use {@link #newEmptyMatch()} to obtain a mutable match object.
   * @param pTransition the fixed value of pattern parameter transition, or null if not bound.
   * @param pEventType the fixed value of pattern parameter eventType, or null if not bound.
   * @return the (partial) match object.
   * 
   */
  public static TransitionWithEventTypeMatch newMatch(final Transition pTransition, final String pEventType) {
    return new Immutable(pTransition, pEventType);
  }
  
  private static final class Mutable extends TransitionWithEventTypeMatch {
    Mutable(final Transition pTransition, final String pEventType) {
      super(pTransition, pEventType);
    }
    
    @Override
    public boolean isMutable() {
      return true;
    }
  }
  
  private static final class Immutable extends TransitionWithEventTypeMatch {
    Immutable(final Transition pTransition, final String pEventType) {
      super(pTransition, pEventType);
    }
    
    @Override
    public boolean isMutable() {
      return false;
    }
  }
}
