/**
 * 
 *   Copyright (c) 2004-2014, Istvan David, Istvan Rath and Daniel Varro
 *   All rights reserved. This program and the accompanying materials
 *   are made available under the terms of the Eclipse Public License v1.0
 *   which accompanies this distribution, and is available at
 *   http://www.eclipse.org/legal/epl-v10.html
 *  
 *   Contributors:
 *   Istvan David - initial API and implementation
 *  
 */
package org.eclipse.viatra.cep.core.engine.runtime;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.apache.log4j.Logger;
import org.eclipse.viatra.cep.core.engine.runtime.TransitionWithEventTypeMatch;
import org.eclipse.viatra.cep.core.engine.runtime.util.TransitionWithEventTypeQuerySpecification;
import org.eclipse.viatra.cep.core.metamodels.automaton.Transition;
import org.eclipse.viatra.query.runtime.api.IMatchProcessor;
import org.eclipse.viatra.query.runtime.api.IQuerySpecification;
import org.eclipse.viatra.query.runtime.api.ViatraQueryEngine;
import org.eclipse.viatra.query.runtime.api.impl.BaseMatcher;
import org.eclipse.viatra.query.runtime.exception.ViatraQueryException;
import org.eclipse.viatra.query.runtime.matchers.tuple.Tuple;
import org.eclipse.viatra.query.runtime.util.ViatraQueryLoggingUtil;

/**
 * Generated pattern matcher API of the org.eclipse.viatra.cep.core.engine.runtime.transitionWithEventType pattern,
 * providing pattern-specific query methods.
 * 
 * <p>Use the pattern matcher on a given model via {@link #on(ViatraQueryEngine)},
 * e.g. in conjunction with {@link ViatraQueryEngine#on(Notifier)}.
 * 
 * <p>Matches of the pattern will be represented as {@link TransitionWithEventTypeMatch}.
 * 
 * <p>Original source:
 * <code><pre>
 * pattern transitionWithEventType(transition : Transition, eventType : EString){
 * 	NegativeTransition.guards.eventType(transition, eventPatternReference);
 * 	AtomicEventPattern.type(eventPatternReference, eventType);
 * }
 * </pre></code>
 * 
 * @see TransitionWithEventTypeMatch
 * @see TransitionWithEventTypeProcessor
 * @see TransitionWithEventTypeQuerySpecification
 * 
 */
@SuppressWarnings("all")
public class TransitionWithEventTypeMatcher extends BaseMatcher<TransitionWithEventTypeMatch> {
  /**
   * Initializes the pattern matcher within an existing VIATRA Query engine.
   * If the pattern matcher is already constructed in the engine, only a light-weight reference is returned.
   * The match set will be incrementally refreshed upon updates.
   * @param engine the existing VIATRA Query engine in which this matcher will be created.
   * @throws ViatraQueryException if an error occurs during pattern matcher creation
   * 
   */
  public static TransitionWithEventTypeMatcher on(final ViatraQueryEngine engine) throws ViatraQueryException {
    // check if matcher already exists
    TransitionWithEventTypeMatcher matcher = engine.getExistingMatcher(querySpecification());
    if (matcher == null) {
    	matcher = (TransitionWithEventTypeMatcher)engine.getMatcher(querySpecification());
    }
    return matcher;
  }
  
  /**
   * Initializes the pattern matcher within an existing VIATRA Query engine.
   * If the pattern matcher is already constructed in the engine, only a light-weight reference is returned.
   * The match set will be incrementally refreshed upon updates.
   * @param engine the existing VIATRA Query engine in which this matcher will be created.
   * @throws ViatraQueryException if an error occurs during pattern matcher creation
   * 
   */
  public static TransitionWithEventTypeMatcher create() throws ViatraQueryException {
    return new TransitionWithEventTypeMatcher();
  }
  
  private final static int POSITION_TRANSITION = 0;
  
  private final static int POSITION_EVENTTYPE = 1;
  
  private final static Logger LOGGER = ViatraQueryLoggingUtil.getLogger(TransitionWithEventTypeMatcher.class);
  
  /**
   * Initializes the pattern matcher within an existing VIATRA Query engine.
   * If the pattern matcher is already constructed in the engine, only a light-weight reference is returned.
   * The match set will be incrementally refreshed upon updates.
   * @param engine the existing VIATRA Query engine in which this matcher will be created.
   * @throws ViatraQueryException if an error occurs during pattern matcher creation
   * 
   */
  private TransitionWithEventTypeMatcher() throws ViatraQueryException {
    super(querySpecification());
  }
  
  /**
   * Returns the set of all matches of the pattern that conform to the given fixed values of some parameters.
   * @param pTransition the fixed value of pattern parameter transition, or null if not bound.
   * @param pEventType the fixed value of pattern parameter eventType, or null if not bound.
   * @return matches represented as a TransitionWithEventTypeMatch object.
   * 
   */
  public Collection<TransitionWithEventTypeMatch> getAllMatches(final Transition pTransition, final String pEventType) {
    return rawGetAllMatches(new Object[]{pTransition, pEventType});
  }
  
  /**
   * Returns an arbitrarily chosen match of the pattern that conforms to the given fixed values of some parameters.
   * Neither determinism nor randomness of selection is guaranteed.
   * @param pTransition the fixed value of pattern parameter transition, or null if not bound.
   * @param pEventType the fixed value of pattern parameter eventType, or null if not bound.
   * @return a match represented as a TransitionWithEventTypeMatch object, or null if no match is found.
   * 
   */
  public TransitionWithEventTypeMatch getOneArbitraryMatch(final Transition pTransition, final String pEventType) {
    return rawGetOneArbitraryMatch(new Object[]{pTransition, pEventType});
  }
  
  /**
   * Indicates whether the given combination of specified pattern parameters constitute a valid pattern match,
   * under any possible substitution of the unspecified parameters (if any).
   * @param pTransition the fixed value of pattern parameter transition, or null if not bound.
   * @param pEventType the fixed value of pattern parameter eventType, or null if not bound.
   * @return true if the input is a valid (partial) match of the pattern.
   * 
   */
  public boolean hasMatch(final Transition pTransition, final String pEventType) {
    return rawHasMatch(new Object[]{pTransition, pEventType});
  }
  
  /**
   * Returns the number of all matches of the pattern that conform to the given fixed values of some parameters.
   * @param pTransition the fixed value of pattern parameter transition, or null if not bound.
   * @param pEventType the fixed value of pattern parameter eventType, or null if not bound.
   * @return the number of pattern matches found.
   * 
   */
  public int countMatches(final Transition pTransition, final String pEventType) {
    return rawCountMatches(new Object[]{pTransition, pEventType});
  }
  
  /**
   * Executes the given processor on each match of the pattern that conforms to the given fixed values of some parameters.
   * @param pTransition the fixed value of pattern parameter transition, or null if not bound.
   * @param pEventType the fixed value of pattern parameter eventType, or null if not bound.
   * @param processor the action that will process each pattern match.
   * 
   */
  public void forEachMatch(final Transition pTransition, final String pEventType, final IMatchProcessor<? super TransitionWithEventTypeMatch> processor) {
    rawForEachMatch(new Object[]{pTransition, pEventType}, processor);
  }
  
  /**
   * Executes the given processor on an arbitrarily chosen match of the pattern that conforms to the given fixed values of some parameters.
   * Neither determinism nor randomness of selection is guaranteed.
   * @param pTransition the fixed value of pattern parameter transition, or null if not bound.
   * @param pEventType the fixed value of pattern parameter eventType, or null if not bound.
   * @param processor the action that will process the selected match.
   * @return true if the pattern has at least one match with the given parameter values, false if the processor was not invoked
   * 
   */
  public boolean forOneArbitraryMatch(final Transition pTransition, final String pEventType, final IMatchProcessor<? super TransitionWithEventTypeMatch> processor) {
    return rawForOneArbitraryMatch(new Object[]{pTransition, pEventType}, processor);
  }
  
  /**
   * Returns a new (partial) match.
   * This can be used e.g. to call the matcher with a partial match.
   * <p>The returned match will be immutable. Use {@link #newEmptyMatch()} to obtain a mutable match object.
   * @param pTransition the fixed value of pattern parameter transition, or null if not bound.
   * @param pEventType the fixed value of pattern parameter eventType, or null if not bound.
   * @return the (partial) match object.
   * 
   */
  public TransitionWithEventTypeMatch newMatch(final Transition pTransition, final String pEventType) {
    return TransitionWithEventTypeMatch.newMatch(pTransition, pEventType);
  }
  
  /**
   * Retrieve the set of values that occur in matches for transition.
   * @return the Set of all values, null if no parameter with the given name exists, empty set if there are no matches
   * 
   */
  protected Set<Transition> rawAccumulateAllValuesOftransition(final Object[] parameters) {
    Set<Transition> results = new HashSet<Transition>();
    rawAccumulateAllValues(POSITION_TRANSITION, parameters, results);
    return results;
  }
  
  /**
   * Retrieve the set of values that occur in matches for transition.
   * @return the Set of all values, null if no parameter with the given name exists, empty set if there are no matches
   * 
   */
  public Set<Transition> getAllValuesOftransition() {
    return rawAccumulateAllValuesOftransition(emptyArray());
  }
  
  /**
   * Retrieve the set of values that occur in matches for transition.
   * @return the Set of all values, null if no parameter with the given name exists, empty set if there are no matches
   * 
   */
  public Set<Transition> getAllValuesOftransition(final TransitionWithEventTypeMatch partialMatch) {
    return rawAccumulateAllValuesOftransition(partialMatch.toArray());
  }
  
  /**
   * Retrieve the set of values that occur in matches for transition.
   * @return the Set of all values, null if no parameter with the given name exists, empty set if there are no matches
   * 
   */
  public Set<Transition> getAllValuesOftransition(final String pEventType) {
    return rawAccumulateAllValuesOftransition(new Object[]{
    null, 
    pEventType
    });
  }
  
  /**
   * Retrieve the set of values that occur in matches for eventType.
   * @return the Set of all values, null if no parameter with the given name exists, empty set if there are no matches
   * 
   */
  protected Set<String> rawAccumulateAllValuesOfeventType(final Object[] parameters) {
    Set<String> results = new HashSet<String>();
    rawAccumulateAllValues(POSITION_EVENTTYPE, parameters, results);
    return results;
  }
  
  /**
   * Retrieve the set of values that occur in matches for eventType.
   * @return the Set of all values, null if no parameter with the given name exists, empty set if there are no matches
   * 
   */
  public Set<String> getAllValuesOfeventType() {
    return rawAccumulateAllValuesOfeventType(emptyArray());
  }
  
  /**
   * Retrieve the set of values that occur in matches for eventType.
   * @return the Set of all values, null if no parameter with the given name exists, empty set if there are no matches
   * 
   */
  public Set<String> getAllValuesOfeventType(final TransitionWithEventTypeMatch partialMatch) {
    return rawAccumulateAllValuesOfeventType(partialMatch.toArray());
  }
  
  /**
   * Retrieve the set of values that occur in matches for eventType.
   * @return the Set of all values, null if no parameter with the given name exists, empty set if there are no matches
   * 
   */
  public Set<String> getAllValuesOfeventType(final Transition pTransition) {
    return rawAccumulateAllValuesOfeventType(new Object[]{
    pTransition, 
    null
    });
  }
  
  @Override
  protected TransitionWithEventTypeMatch tupleToMatch(final Tuple t) {
    try {
    	return TransitionWithEventTypeMatch.newMatch((Transition) t.get(POSITION_TRANSITION), (String) t.get(POSITION_EVENTTYPE));
    } catch(ClassCastException e) {
    	LOGGER.error("Element(s) in tuple not properly typed!",e);
    	return null;
    }
  }
  
  @Override
  protected TransitionWithEventTypeMatch arrayToMatch(final Object[] match) {
    try {
    	return TransitionWithEventTypeMatch.newMatch((Transition) match[POSITION_TRANSITION], (String) match[POSITION_EVENTTYPE]);
    } catch(ClassCastException e) {
    	LOGGER.error("Element(s) in array not properly typed!",e);
    	return null;
    }
  }
  
  @Override
  protected TransitionWithEventTypeMatch arrayToMatchMutable(final Object[] match) {
    try {
    	return TransitionWithEventTypeMatch.newMutableMatch((Transition) match[POSITION_TRANSITION], (String) match[POSITION_EVENTTYPE]);
    } catch(ClassCastException e) {
    	LOGGER.error("Element(s) in array not properly typed!",e);
    	return null;
    }
  }
  
  /**
   * @return the singleton instance of the query specification of this pattern
   * @throws ViatraQueryException if the pattern definition could not be loaded
   * 
   */
  public static IQuerySpecification<TransitionWithEventTypeMatcher> querySpecification() throws ViatraQueryException {
    return TransitionWithEventTypeQuerySpecification.instance();
  }
}
