/**
 * 
 *   Copyright (c) 2004-2014, Istvan David, Istvan Rath and Daniel Varro
 *   All rights reserved. This program and the accompanying materials
 *   are made available under the terms of the Eclipse Public License v1.0
 *   which accompanies this distribution, and is available at
 *   http://www.eclipse.org/legal/epl-v10.html
 *  
 *   Contributors:
 *   Istvan David - initial API and implementation
 *  
 */
package org.eclipse.viatra.cep.core.engine.runtime.util;

import org.eclipse.viatra.cep.core.engine.runtime.TransitionWithEventTypeMatch;
import org.eclipse.viatra.cep.core.metamodels.automaton.Transition;
import org.eclipse.viatra.query.runtime.api.IMatchProcessor;

/**
 * A match processor tailored for the org.eclipse.viatra.cep.core.engine.runtime.transitionWithEventType pattern.
 * 
 * Clients should derive an (anonymous) class that implements the abstract process().
 * 
 */
@SuppressWarnings("all")
public abstract class TransitionWithEventTypeProcessor implements IMatchProcessor<TransitionWithEventTypeMatch> {
  /**
   * Defines the action that is to be executed on each match.
   * @param pTransition the value of pattern parameter transition in the currently processed match
   * @param pEventType the value of pattern parameter eventType in the currently processed match
   * 
   */
  public abstract void process(final Transition pTransition, final String pEventType);
  
  @Override
  public void process(final TransitionWithEventTypeMatch match) {
    process(match.getTransition(), match.getEventType());
  }
}
