/**
 * Copyright (c) 2004-2015, Istvan David, Istvan Rath and Daniel Varro
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 * Istvan David - initial API and implementation
 */
package org.eclipse.viatra.cep.core.eventprocessingstrategy;

import org.eclipse.emf.common.util.EList;
import org.eclipse.viatra.cep.core.engine.IEventModelManager;
import org.eclipse.viatra.cep.core.eventprocessingstrategy.AbstractImmediateStrategy;
import org.eclipse.viatra.cep.core.metamodels.automaton.Automaton;
import org.eclipse.viatra.cep.core.metamodels.automaton.AutomatonFactory;
import org.eclipse.viatra.cep.core.metamodels.automaton.EventContext;
import org.eclipse.viatra.cep.core.metamodels.automaton.EventToken;
import org.eclipse.viatra.cep.core.metamodels.automaton.InitState;
import org.eclipse.viatra.cep.core.metamodels.automaton.InternalModel;
import org.eclipse.viatra.cep.core.metamodels.automaton.State;
import org.eclipse.viatra.cep.core.utils.AutomatonUtils;
import org.eclipse.xtext.xbase.lib.Functions.Function1;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.Procedures.Procedure1;

/**
 * Strategy implementation for the <i>Strict Immediate</i> {@link EventContext}.
 * 
 * @author Istvan David
 */
@SuppressWarnings("all")
public class StrictImmediateStrategy extends AbstractImmediateStrategy {
  @Override
  public EventContext getContext() {
    return EventContext.STRICT_IMMEDIATE;
  }
  
  public StrictImmediateStrategy(final IEventModelManager eventModelManager) {
    super(eventModelManager);
  }
  
  @Override
  public void handleInitTokenCreation(final InternalModel model, final AutomatonFactory factory) {
    EList<Automaton> _automata = model.getAutomata();
    final Procedure1<Automaton> _function = new Procedure1<Automaton>() {
      @Override
      public void apply(final Automaton automaton) {
        EList<EventToken> _eventTokens = automaton.getEventTokens();
        final Function1<EventToken, Boolean> _function = new Function1<EventToken, Boolean>() {
          @Override
          public Boolean apply(final EventToken eventToken) {
            State _currentState = eventToken.getCurrentState();
            return Boolean.valueOf(AutomatonUtils.enablesStrictInitTokenCreation(_currentState));
          }
        };
        boolean _forall = IterableExtensions.<EventToken>forall(_eventTokens, _function);
        if (_forall) {
          InitState _initialState = automaton.getInitialState();
          AutomatonUtils.newEventToken(automaton, _initialState);
        }
      }
    };
    IterableExtensions.<Automaton>forEach(_automata, _function);
  }
}
