/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.cep.tooling.core.project;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.core.project.IBundleClasspathEntry;
import org.eclipse.pde.core.project.IBundleProjectDescription;
import org.eclipse.pde.core.project.IBundleProjectService;
import org.eclipse.pde.core.project.IPackageExportDescription;
import org.eclipse.pde.core.project.IPackageImportDescription;
import org.eclipse.pde.core.project.IRequiredBundleDescription;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.core.natures.PDE;
import org.eclipse.viatra.cep.tooling.core.internal.Activator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.Version;

public abstract class ProjectGenerationHelper {
    private static final String INVALID_PROJECT_MESSAGE = "Invalid project %s. Only existing, open plug-in projects are supported by the generator.";
    public static final List<String> SOURCEFOLDERS = ImmutableList.of((Object)"src/", (Object)"src-gen/");
    public static final List<String> SINGLESOURCEFOLDER = ImmutableList.of((Object)"src");

    public static void createProject(IProjectDescription description, IProject proj, List<String> additionalDependencies, IProgressMonitor monitor) throws CoreException {
        ArrayList dependencies = Lists.newArrayList((Object[])new String[]{"org.eclipse.emf.ecore", "org.eclipse.viatra.cep.core", "com.google.guava"});
        ArrayList importPackages = Lists.newArrayList((Object[])new String[]{"org.apache.log4j"});
        if (additionalDependencies != null) {
            dependencies.addAll(additionalDependencies);
        }
        BundleContext context = null;
        ServiceReference ref = null;
        try {
            monitor.beginTask("", 2000);
            context = Activator.getContext();
            ref = context.getServiceReference(IBundleProjectService.class);
            IBundleProjectService service = (IBundleProjectService)context.getService(ref);
            IBundleProjectDescription bundleDesc = service.getDescription(proj);
            IPath[] additionalBinIncludes = new IPath[]{new Path("plugin.xml")};
            ProjectGenerationHelper.fillProjectMetadata(proj, dependencies, importPackages, service, bundleDesc, additionalBinIncludes);
            bundleDesc.apply(monitor);
            ProjectGenerationHelper.updateNatures(proj, (Collection<String>)ImmutableList.of((Object)"org.eclipse.xtext.ui.shared.xtextNature", (Object)"org.eclipse.viatra.cep.projectnature"), (Collection<String>)ImmutableList.of(), monitor);
        }
        finally {
            monitor.done();
            if (context != null && ref != null) {
                context.ungetService(ref);
            }
        }
    }

    public static void updateNatures(IProject proj, Collection<String> naturesToAdd, Collection<String> naturesToRemove, IProgressMonitor monitor) throws CoreException {
        IProjectDescription desc = proj.getDescription();
        LinkedHashSet<String> newNatures = new LinkedHashSet<String>();
        newNatures.addAll(Arrays.asList(desc.getNatureIds()));
        newNatures.addAll(naturesToAdd);
        newNatures.removeAll(naturesToRemove);
        desc.setNatureIds(newNatures.toArray(new String[newNatures.size()]));
        proj.setDescription(desc, monitor);
    }

    public static void addFileToProject(IContainer container, Path path, InputStream contentStream, IProgressMonitor monitor) throws CoreException {
        IFile file = container.getFile((IPath)path);
        if (file.exists()) {
            file.setContents(contentStream, true, true, monitor);
        } else {
            file.create(contentStream, true, monitor);
        }
    }

    public static void initializePluginProject(IProject project, List<String> dependencies, IPath[] additionalBinIncludes) throws CoreException {
        ProjectGenerationHelper.initializePluginProject(project, dependencies, additionalBinIncludes, (IProgressMonitor)new NullProgressMonitor());
    }

    public static void initializePluginProject(IProject project, List<String> dependencies, IPath[] additionalBinIncludes, IProgressMonitor monitor) throws CoreException {
        BundleContext context = null;
        ServiceReference ref = null;
        try {
            context = Activator.getContext();
            ref = context.getServiceReference(IBundleProjectService.class);
            IBundleProjectService service = (IBundleProjectService)context.getService(ref);
            IBundleProjectDescription bundleDesc = service.getDescription(project);
            ProjectGenerationHelper.fillProjectMetadata(project, dependencies, Collections.emptyList(), service, bundleDesc, additionalBinIncludes);
            bundleDesc.apply(monitor);
        }
        finally {
            if (context != null && ref != null) {
                context.ungetService(ref);
            }
        }
    }

    public static void fillProjectMetadata(IProject project, List<String> dependencies, List<String> packageImports, IBundleProjectService service, IBundleProjectDescription bundleDesc, IPath[] additionalBinIncludes) {
        bundleDesc.setBundleName(project.getName());
        bundleDesc.setBundleVersion(new Version(0, 0, 1, "qualifier"));
        bundleDesc.setSingleton(true);
        bundleDesc.setTargetVersion("3.6");
        bundleDesc.setSymbolicName(project.getName());
        bundleDesc.setExtensionRegistry(true);
        bundleDesc.setBinIncludes(additionalBinIncludes);
        bundleDesc.setBundleClasspath(ProjectGenerationHelper.getUpdatedBundleClasspathEntries(new IBundleClasspathEntry[0], service));
        bundleDesc.setExecutionEnvironments(new String[]{"JavaSE-1.6"});
        IRequiredBundleDescription[] reqBundles = Lists.transform(dependencies, (Function)new IDToRequireBundleTransformer(service)).toArray(new IRequiredBundleDescription[dependencies.size()]);
        bundleDesc.setRequiredBundles(reqBundles);
        IPackageImportDescription[] importArray = Lists.transform(packageImports, (Function)new IDToPackageImportTransformer(service)).toArray(new IPackageImportDescription[packageImports.size()]);
        bundleDesc.setPackageImports(importArray);
    }

    /*
     * Unable to fully structure code
     */
    public static boolean checkBundleDependency(IProject project, String dependency) throws CoreException {
        Preconditions.checkArgument((boolean)(project.exists() != false && project.isOpen() != false && PDE.hasPluginNature((IProject)project) != false), (Object)String.format("Invalid project %s. Only existing, open plug-in projects are supported by the generator.", new Object[]{project.getName()}));
        context = null;
        ref = null;
        context = Activator.getContext();
        ref = context.getServiceReference(IBundleProjectService.class);
        service = (IBundleProjectService)context.getService(ref);
        bundleDesc = service.getDescription(project);
        var9_6 = bundleDesc.getRequiredBundles();
        var8_7 = var9_6.length;
        var7_8 = 0;
        while (true) {
            require = var9_6[var7_8];
            if (dependency.equals(require.getName())) {
                return true;
            }
            ++var7_8;
            return (boolean)var7_8;
        }
lbl19:
        // 1 sources

        return false;
        finally {
            if (var7_8 < var8_7) ** continue;
            ** continue;
        }
    }

    public static void ensureBundleDependencies(IProject project, List<String> dependencies) throws CoreException {
        ProjectGenerationHelper.ensureBundleDependencies(project, dependencies, Collections.emptyList(), (IProgressMonitor)new NullProgressMonitor());
    }

    public static void ensurePackageImports(IProject project, List<String> packageImports) throws CoreException {
        ProjectGenerationHelper.ensureBundleDependencies(project, Collections.emptyList(), packageImports, (IProgressMonitor)new NullProgressMonitor());
    }

    public static void ensureBundleDependencies(IProject project, List<String> dependencies, List<String> importPackages, IProgressMonitor monitor) throws CoreException {
        Preconditions.checkArgument((project.exists() && project.isOpen() && PDE.hasPluginNature((IProject)project) ? 1 : 0) != 0, (Object)String.format(INVALID_PROJECT_MESSAGE, project.getName()));
        if (dependencies.isEmpty() && importPackages.isEmpty()) {
            return;
        }
        BundleContext context = null;
        ServiceReference ref = null;
        try {
            context = Activator.getContext();
            ref = context.getServiceReference(IBundleProjectService.class);
            IBundleProjectService service = (IBundleProjectService)context.getService(ref);
            IBundleProjectDescription bundleDesc = service.getDescription(project);
            if (!dependencies.isEmpty()) {
                ProjectGenerationHelper.ensureBundleDependencies(service, bundleDesc, dependencies);
            }
            if (!importPackages.isEmpty()) {
                ProjectGenerationHelper.ensurePackageImports(service, bundleDesc, importPackages);
            }
            bundleDesc.apply(monitor);
        }
        finally {
            if (context != null && ref != null) {
                context.ungetService(ref);
            }
        }
    }

    static void ensureBundleDependencies(IBundleProjectService service, IBundleProjectDescription bundleDesc, List<String> dependencies) {
        IRequiredBundleDescription[] requiredBundles = bundleDesc.getRequiredBundles();
        if (requiredBundles == null) {
            return;
        }
        ArrayList<String> updatedDependencies = new ArrayList<String>(dependencies);
        Version pdeVersion = Platform.getBundle((String)"org.eclipse.pde.core").getVersion();
        if (pdeVersion.compareTo(new Version(3, 9, 0)) < 0) {
            ArrayList<String> missingDependencies = new ArrayList<String>(dependencies);
            IRequiredBundleDescription[] iRequiredBundleDescriptionArray = requiredBundles;
            int n = requiredBundles.length;
            int n2 = 0;
            while (n2 < n) {
                IRequiredBundleDescription bundle = iRequiredBundleDescriptionArray[n2];
                if (missingDependencies.contains(bundle.getName())) {
                    missingDependencies.remove(bundle.getName());
                }
                ++n2;
            }
            bundleDesc.setRequiredBundles(Lists.transform(missingDependencies, (Function)new IDToRequireBundleTransformer(service)).toArray(new IRequiredBundleDescription[missingDependencies.size()]));
        } else {
            IRequiredBundleDescription[] iRequiredBundleDescriptionArray = requiredBundles;
            int n = requiredBundles.length;
            int n3 = 0;
            while (n3 < n) {
                IRequiredBundleDescription bundle = iRequiredBundleDescriptionArray[n3];
                if (!updatedDependencies.contains(bundle.getName())) {
                    updatedDependencies.add(bundle.getName());
                }
                ++n3;
            }
            bundleDesc.setRequiredBundles(Lists.transform(updatedDependencies, (Function)new IDToRequireBundleTransformer(service)).toArray(new IRequiredBundleDescription[updatedDependencies.size()]));
        }
    }

    static void ensurePackageImports(IBundleProjectService service, IBundleProjectDescription bundleDesc, List<String> packageImports) {
        IPackageImportDescription[] importArray = bundleDesc.getPackageImports();
        List<Object> importList = importArray == null ? Lists.newArrayList() : Arrays.asList(importArray);
        ArrayList newImports = Lists.newArrayList(packageImports);
        for (IPackageImportDescription iPackageImportDescription : importList) {
            String packageName = iPackageImportDescription.getName();
            if (!packageImports.contains(packageName)) continue;
            newImports.remove(packageName);
        }
        importList.addAll(Lists.transform((List)newImports, (Function)new IDToPackageImportTransformer(service)));
        bundleDesc.setPackageImports(importList.toArray(new IPackageImportDescription[importList.size()]));
    }

    public static void ensurePackageExports(IProject project, Collection<String> exports, Collection<String> cepPackages) throws CoreException {
        ProjectGenerationHelper.removePackageExports(project, Lists.newArrayList(cepPackages));
        ProjectGenerationHelper.ensurePackageExports(project, exports, (IProgressMonitor)new NullProgressMonitor());
    }

    public static void ensurePackageExports(IProject project, Collection<String> exports, IProgressMonitor monitor) throws CoreException {
        Preconditions.checkArgument((project.exists() && project.isOpen() && PDE.hasPluginNature((IProject)project) ? 1 : 0) != 0, (Object)String.format(INVALID_PROJECT_MESSAGE, project.getName()));
        if (exports.isEmpty()) {
            return;
        }
        BundleContext context = null;
        ServiceReference ref = null;
        try {
            context = Activator.getContext();
            ref = context.getServiceReference(IBundleProjectService.class);
            IBundleProjectService service = (IBundleProjectService)context.getService(ref);
            IBundleProjectDescription bundleDesc = service.getDescription(project);
            ProjectGenerationHelper.ensurePackageExports(service, bundleDesc, exports);
            bundleDesc.apply(monitor);
        }
        finally {
            if (context != null && ref != null) {
                context.ungetService(ref);
            }
        }
    }

    public static void removePackageExports(IProject project, List<String> dependencies, IProgressMonitor monitor) throws CoreException {
        Preconditions.checkArgument((project.exists() && project.isOpen() && PDE.hasPluginNature((IProject)project) ? 1 : 0) != 0, (Object)String.format(INVALID_PROJECT_MESSAGE, project.getName()));
        if (dependencies.isEmpty()) {
            return;
        }
        BundleContext context = null;
        ServiceReference ref = null;
        try {
            context = Activator.getContext();
            ref = context.getServiceReference(IBundleProjectService.class);
            IBundleProjectService service = (IBundleProjectService)context.getService(ref);
            IBundleProjectDescription bundleDesc = service.getDescription(project);
            ProjectGenerationHelper.removePackageExports(service, bundleDesc, dependencies);
            bundleDesc.apply(monitor);
        }
        finally {
            if (context != null && ref != null) {
                context.ungetService(ref);
            }
        }
    }

    static void ensurePackageExports(final IBundleProjectService service, IBundleProjectDescription bundleDesc, Collection<String> exports) {
        IPackageExportDescription[] packageExports = bundleDesc.getPackageExports();
        ArrayList<String> missingExports = new ArrayList<String>(exports);
        ArrayList<IPackageExportDescription> exportList = new ArrayList<IPackageExportDescription>();
        if (packageExports != null) {
            IPackageExportDescription[] iPackageExportDescriptionArray = packageExports;
            int n = packageExports.length;
            int n2 = 0;
            while (n2 < n) {
                IPackageExportDescription export = iPackageExportDescriptionArray[n2];
                if (!missingExports.contains(export.getName())) {
                    missingExports.remove(export.getName());
                }
                exportList.add(export);
                ++n2;
            }
        }
        exportList.addAll(Lists.transform(missingExports, (Function)new Function<String, IPackageExportDescription>(){

            public IPackageExportDescription apply(String input) {
                return service.newPackageExport(input, null, true, null);
            }
        }));
        bundleDesc.setPackageExports(exportList.toArray(new IPackageExportDescription[exportList.size()]));
    }

    public static Multimap<IProject, String> getLastExported(IProject project) {
        HashMultimap exported = HashMultimap.create();
        BundleContext context = Activator.getContext();
        ServiceReference ref = context.getServiceReference(IBundleProjectService.class);
        IBundleProjectService service = (IBundleProjectService)context.getService(ref);
        try {
            IPackageExportDescription[] packageExports;
            IBundleProjectDescription bundleDesc = service.getDescription(project);
            IPackageExportDescription[] iPackageExportDescriptionArray = packageExports = bundleDesc.getPackageExports();
            int n = packageExports.length;
            int n2 = 0;
            while (n2 < n) {
                IPackageExportDescription iPackageExportDescription = iPackageExportDescriptionArray[n2];
                exported.put((Object)project, (Object)iPackageExportDescription.getName());
                ++n2;
            }
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        return exported;
    }

    static void removePackageExports(IBundleProjectService service, IBundleProjectDescription bundleDesc, List<String> exports) {
        IPackageExportDescription[] packageExports = bundleDesc.getPackageExports();
        ArrayList<IPackageExportDescription> exportList = new ArrayList<IPackageExportDescription>();
        if (packageExports != null) {
            IPackageExportDescription[] iPackageExportDescriptionArray = packageExports;
            int n = packageExports.length;
            int n2 = 0;
            while (n2 < n) {
                IPackageExportDescription export = iPackageExportDescriptionArray[n2];
                if (!exports.contains(export.getName())) {
                    exportList.add(export);
                }
                ++n2;
            }
        }
        bundleDesc.setPackageExports(exportList.toArray(new IPackageExportDescription[exportList.size()]));
    }

    public static void removePackageExports(IProject project, List<String> dependencies) throws CoreException {
        ProjectGenerationHelper.removePackageExports(project, dependencies, (IProgressMonitor)new NullProgressMonitor());
    }

    public static void ensureSourceFolders(IProject project, IProgressMonitor monitor) throws CoreException {
        Preconditions.checkArgument((project.exists() && project.isOpen() && PDE.hasPluginNature((IProject)project) ? 1 : 0) != 0, (Object)String.format(INVALID_PROJECT_MESSAGE, project.getName()));
        BundleContext context = null;
        ServiceReference ref = null;
        try {
            context = Activator.getContext();
            ref = context.getServiceReference(IBundleProjectService.class);
            IBundleProjectService service = (IBundleProjectService)context.getService(ref);
            IBundleProjectDescription bundleDesc = service.getDescription(project);
            bundleDesc.setBundleClasspath(ProjectGenerationHelper.getUpdatedBundleClasspathEntries(bundleDesc.getBundleClasspath(), service));
            bundleDesc.apply(monitor);
        }
        finally {
            if (context != null && ref != null) {
                context.ungetService(ref);
            }
        }
    }

    private static IBundleClasspathEntry[] getUpdatedBundleClasspathEntries(IBundleClasspathEntry[] oldClasspath, final IBundleProjectService service) {
        Collection classPathSourceList = Collections2.filter((Collection)Lists.newArrayList((Object[])oldClasspath), (Predicate)new Predicate<IBundleClasspathEntry>(){

            public boolean apply(IBundleClasspathEntry entry) {
                return entry.getSourcePath() != null && !entry.getSourcePath().isEmpty();
            }
        });
        final Collection existingSourceEntries = Collections2.transform((Collection)classPathSourceList, (Function)new Function<IBundleClasspathEntry, String>(){

            public String apply(IBundleClasspathEntry entry) {
                return entry.getSourcePath().toString();
            }
        });
        Collection missingSourceFolders = Collections2.filter(SOURCEFOLDERS, (Predicate)new Predicate<String>(){

            public boolean apply(String entry) {
                return !existingSourceEntries.contains(entry);
            }
        });
        Collection newClasspathEntries = Collections2.transform((Collection)missingSourceFolders, (Function)new Function<String, IBundleClasspathEntry>(){

            public IBundleClasspathEntry apply(String input) {
                return service.newBundleClasspathEntry((IPath)new Path(input), null, null);
            }
        });
        ArrayList modifiedClasspathEntries = Lists.newArrayList((Object[])oldClasspath);
        modifiedClasspathEntries.addAll(newClasspathEntries);
        return modifiedClasspathEntries.toArray(new IBundleClasspathEntry[modifiedClasspathEntries.size()]);
    }

    public static String getBundleSymbolicName(IProject project) {
        IPluginModelBase plugin = PDECore.getDefault().getModelManager().findModel(project);
        return plugin.getBundleDescription().getSymbolicName();
    }

    private static final class IDToPackageImportTransformer
    implements Function<String, IPackageImportDescription> {
        private final IBundleProjectService service;

        private IDToPackageImportTransformer(IBundleProjectService service) {
            this.service = service;
        }

        public IPackageImportDescription apply(String arg0) {
            return this.service.newPackageImport(arg0, null, false);
        }
    }

    private static final class IDToRequireBundleTransformer
    implements Function<String, IRequiredBundleDescription> {
        private final IBundleProjectService service;

        private IDToRequireBundleTransformer(IBundleProjectService service) {
            this.service = service;
        }

        public IRequiredBundleDescription apply(String input) {
            return this.service.newRequiredBundle(input, null, false, false);
        }
    }
}

