/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.dse.evolutionary;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.eclipse.viatra.dse.evolutionary.Row;

public class CsvFile {
    protected String fileBasePath = "";
    protected String fileName;
    protected Character delimeter = Character.valueOf(',');
    private File csvFile;
    private Path path;
    protected List<String> columnNamesInOrder = new ArrayList<String>();
    protected List<Row> loadedRows;

    public String getHeaderString() {
        StringBuilder sb = new StringBuilder();
        for (String string : this.columnNamesInOrder) {
            sb.append(string);
            sb.append(this.delimeter);
        }
        sb.deleteCharAt(sb.length() - 1);
        return sb.toString();
    }

    public String rowIntoString(Row row) {
        StringBuilder sb = new StringBuilder();
        for (String key : this.columnNamesInOrder) {
            String value = (String)row.get(key);
            sb.append(value);
            sb.append(this.delimeter);
        }
        if (sb.length() > 0) {
            sb.deleteCharAt(sb.length() - 1);
        }
        return sb.toString();
    }

    public boolean createCsvFile() {
        block14: {
            this.path = Paths.get(this.fileBasePath, String.valueOf(this.fileName) + ".csv");
            this.csvFile = new File(this.path.toUri());
            if (this.csvFile.exists()) {
                Logger.getLogger(this.getClass()).warn((Object)("File " + this.fileName + ".csv already exists!"));
                return false;
            }
            Throwable throwable = null;
            Object var2_4 = null;
            PrintWriter out = new PrintWriter(new BufferedWriter(new FileWriter(this.path.toString(), true)));
            try {
                out.println(this.getHeaderString());
                if (out == null) break block14;
                out.close();
            }
            catch (Throwable throwable2) {
                try {
                    if (out != null) {
                        out.close();
                    }
                    throw throwable2;
                }
                catch (Throwable throwable3) {
                    try {
                        if (throwable == null) {
                            throwable = throwable3;
                        } else if (throwable != throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        throw throwable;
                    }
                    catch (IOException e) {
                        Logger.getLogger(this.getClass()).error((Object)"Couldn't write csv file.", (Throwable)e);
                        return false;
                    }
                }
            }
        }
        return true;
    }

    public boolean appendRow(Row row) {
        block14: {
            if (this.csvFile == null) {
                throw new RuntimeException("Csv file is not created yet.");
            }
            Throwable throwable = null;
            Object var3_5 = null;
            PrintWriter out = new PrintWriter(new BufferedWriter(new FileWriter(this.path.toString(), true)));
            try {
                out.println(this.rowIntoString(row));
                if (out == null) break block14;
                out.close();
            }
            catch (Throwable throwable2) {
                try {
                    if (out != null) {
                        out.close();
                    }
                    throw throwable2;
                }
                catch (Throwable throwable3) {
                    try {
                        if (throwable == null) {
                            throwable = throwable3;
                        } else if (throwable != throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        throw throwable;
                    }
                    catch (IOException e) {
                        Logger.getLogger(this.getClass()).error((Object)"Couldn't write csv file.", (Throwable)e);
                        return false;
                    }
                }
            }
        }
        return true;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setFileBasePath(String fileBasePath) {
        this.fileBasePath = fileBasePath;
    }

    public String getFileBasePath() {
        return this.fileBasePath;
    }

    public List<String> getColumnNamesInOrder() {
        return this.columnNamesInOrder;
    }

    public void setColumnNamesInOrder(List<String> columnNamesInOrder) {
        this.columnNamesInOrder = columnNamesInOrder;
    }
}

