/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.dse.evolutionary;

import com.google.common.util.concurrent.AtomicDouble;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.BrokenBarrierException;
import java.util.concurrent.CyclicBarrier;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.log4j.Logger;
import org.eclipse.viatra.dse.api.DesignSpaceExplorer;
import org.eclipse.viatra.dse.api.strategy.interfaces.IStrategy;
import org.eclipse.viatra.dse.api.strategy.interfaces.IStrategyFactory;
import org.eclipse.viatra.dse.base.DesignSpaceManager;
import org.eclipse.viatra.dse.base.ThreadContext;
import org.eclipse.viatra.dse.evolutionary.interfaces.ICrossover;
import org.eclipse.viatra.dse.evolutionary.interfaces.IEvaluationStrategy;
import org.eclipse.viatra.dse.evolutionary.interfaces.IEvolutionaryStrategyAdapter;
import org.eclipse.viatra.dse.evolutionary.interfaces.IInitialPopulationSelector;
import org.eclipse.viatra.dse.evolutionary.interfaces.IMutation;
import org.eclipse.viatra.dse.evolutionary.interfaces.IMutationRate;
import org.eclipse.viatra.dse.evolutionary.interfaces.IParentSelectionStrategy;
import org.eclipse.viatra.dse.evolutionary.interfaces.IReproductionStrategy;
import org.eclipse.viatra.dse.evolutionary.interfaces.IStopCondition;
import org.eclipse.viatra.dse.evolutionary.interfaces.ISurvivalStrategy;
import org.eclipse.viatra.dse.objectives.TrajectoryFitness;

public class EvolutionaryStrategy
implements IStrategy {
    protected EvolutionaryStrategySharedObject so;
    protected List<IEvolutionaryStrategyAdapter> adapters = new ArrayList<IEvolutionaryStrategyAdapter>();
    protected ThreadContext context;
    protected DesignSpaceManager dsm;
    protected AtomicBoolean isInterrupted = new AtomicBoolean(false);
    protected Random random = new Random();
    protected IParentSelectionStrategy localParentSelector;
    protected boolean isFirstThread = false;
    protected Logger logger = Logger.getLogger(IStrategy.class);

    public EvolutionaryStrategy() {
        this.so = new EvolutionaryStrategySharedObject();
    }

    public void initStrategy(ThreadContext context) {
        this.context = context;
        this.dsm = context.getDesignSpaceManager();
        if (context.getSharedObject() == null) {
            this.isFirstThread = true;
            this.so.childPopulation = new HashSet<TrajectoryFitness>(this.so.childPopulationSize);
            for (IEvolutionaryStrategyAdapter adapter : this.adapters) {
                adapter.init(context);
            }
            context.setSharedObject((Object)this.so);
            this.so.evaluationStrategy.init(context);
            this.localParentSelector = this.so.parentSelectionStrategy;
            this.logger.info((Object)"Evolutionary exploration strategy is inited.");
        } else {
            this.so = (EvolutionaryStrategySharedObject)context.getSharedObject();
            this.localParentSelector = this.so.parentSelectionStrategy.createNew();
        }
    }

    public void explore() {
        block5: {
            try {
                if (this.isFirstThread) {
                    this.mainThread();
                    break block5;
                }
                while (true) {
                    this.so.barrierBeforeChildGeneration.await();
                    if (this.isInterrupted.get()) {
                        return;
                    }
                    this.generateChildren();
                    this.so.barrierAfterChildGeneration.await();
                }
            }
            catch (InterruptedException | BrokenBarrierException e) {
                Logger.getLogger(DesignSpaceExplorer.class).error((Object)e.toString());
            }
        }
    }

    protected void mainThread() throws InterruptedException, BrokenBarrierException {
        this.so.initialPopulationSelector.setPopulationSize(this.so.initialPopulationSize);
        this.so.initialPopulationSelector.initStrategy(this.context);
        this.so.initialPopulationSelector.explore();
        List<TrajectoryFitness> currentPopulation = this.so.initialPopulationSelector.getInitialPopulation();
        this.logger.info((Object)"Initial population has been generated.");
        this.dsm.setDesignSpace(null);
        if (this.isInterrupted.get()) {
            this.savePopulationsAsSolutions(currentPopulation);
            return;
        }
        int threads = this.context.getGlobalContext().getThreadPool().getMaximumPoolSize();
        this.so.barrierBeforeChildGeneration = new CyclicBarrier(threads);
        this.so.barrierAfterChildGeneration = new CyclicBarrier(threads);
        this.startThreads();
        while (true) {
            List<? extends List<TrajectoryFitness>> frontsOfCurrentPopulation = this.so.evaluationStrategy.evaluatePopulation(currentPopulation);
            List<TrajectoryFitness> survivedPopulation = this.so.survivalStrategy.selectSurvivedPopulation(frontsOfCurrentPopulation);
            for (TrajectoryFitness trajectoryFitness : survivedPopulation) {
                ++trajectoryFitness.survive;
            }
            boolean stop = this.so.stopCondition.checkStopCondition(survivedPopulation);
            if (!this.adapters.isEmpty()) {
                for (IEvolutionaryStrategyAdapter adapter : this.adapters) {
                    adapter.iterationCompleted(currentPopulation, frontsOfCurrentPopulation, survivedPopulation, stop);
                }
            }
            if (stop || this.isInterrupted.get()) {
                this.savePopulationsAsSolutions(survivedPopulation);
                this.context.getGlobalContext().stopAllThreads();
                this.so.barrierBeforeChildGeneration.await();
                return;
            }
            this.so.parentPopulation.set(this.so.reproductionStrategy.getParentPopulation(currentPopulation, frontsOfCurrentPopulation, survivedPopulation));
            this.so.mutationChance.set(this.so.mutationRate.getMutationChance(currentPopulation, survivedPopulation, (Collection<TrajectoryFitness>)this.so.parentPopulation.get()));
            this.so.childPopulation.clear();
            for (TrajectoryFitness trajectoryFitness : survivedPopulation) {
                this.so.childPopulation.add(trajectoryFitness);
            }
            this.so.barrierBeforeChildGeneration.await();
            this.generateChildren();
            this.so.barrierAfterChildGeneration.await();
            currentPopulation = new ArrayList<TrajectoryFitness>(this.so.childPopulation);
        }
    }

    protected void startThreads() {
        this.context.startAllThreads(new IStrategyFactory(){

            public IStrategy createStrategy() {
                return new EvolutionaryStrategy();
            }
        });
    }

    protected void generateChildren() {
        this.localParentSelector.init(this.so.parentPopulation.get());
        while (this.so.childPopulationSize > this.so.childPopulation.size()) {
            boolean shouldBreak;
            TrajectoryFitness parent;
            IMutation mutation;
            TrajectoryFitness child;
            boolean shouldBreak2;
            TrajectoryFitness parent2;
            TrajectoryFitness parent1;
            int index;
            ICrossover crossover;
            TrajectoryFitness[] children;
            if (!(this.random.nextDouble() < this.so.mutationChance.get()) ? (children = (crossover = this.so.crossovers.get(index = this.random.nextInt(this.so.crossovers.size()))).mutate(parent1 = this.localParentSelector.getNextParent(), parent2 = this.localParentSelector.getNextParent(), this.context)) != null && ((shouldBreak2 = this.addToChildren(children[0])) || (shouldBreak2 = this.addToChildren(children[1]))) : (child = (mutation = this.so.mutations.get(index = this.random.nextInt(this.so.mutations.size()))).mutate(parent = this.localParentSelector.getNextParent(), this.context)) != null && (shouldBreak = this.addToChildren(child))) break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean addToChildren(TrajectoryFitness child) {
        CyclicBarrier cyclicBarrier = this.so.barrierBeforeChildGeneration;
        synchronized (cyclicBarrier) {
            block4: {
                if (this.so.childPopulationSize <= this.so.childPopulation.size()) break block4;
                this.so.childPopulation.add(child);
                return false;
            }
            return true;
        }
    }

    protected void savePopulationsAsSolutions(List<TrajectoryFitness> survivedPopulation) {
        for (TrajectoryFitness trajectoryFitness : survivedPopulation) {
            if (trajectoryFitness.rank != 1) continue;
            this.context.backtrackUntilRoot();
            Object[] objectArray = trajectoryFitness.trajectory;
            int n = trajectoryFitness.trajectory.length;
            int n2 = 0;
            while (n2 < n) {
                Object transition = objectArray[n2];
                this.context.executeAcitvationId(transition);
                ++n2;
            }
            this.context.calculateFitness();
            this.context.newSolution();
        }
    }

    public void interruptStrategy() {
        this.so.initialPopulationSelector.interruptStrategy();
        this.isInterrupted.set(true);
    }

    public static class EvolutionaryStrategySharedObject {
        public int initialPopulationSize = -1;
        public int childPopulationSize = -1;
        public IInitialPopulationSelector initialPopulationSelector;
        public IEvaluationStrategy evaluationStrategy;
        public ISurvivalStrategy survivalStrategy;
        public IReproductionStrategy reproductionStrategy;
        public IParentSelectionStrategy parentSelectionStrategy;
        public IStopCondition stopCondition;
        public IMutationRate mutationRate;
        public List<ICrossover> crossovers = new ArrayList<ICrossover>();
        public List<IMutation> mutations = new ArrayList<IMutation>();
        public CyclicBarrier barrierBeforeChildGeneration;
        public CyclicBarrier barrierAfterChildGeneration;
        public AtomicDouble mutationChance = new AtomicDouble(1.0);
        public Set<TrajectoryFitness> childPopulation;
        public AtomicReference<List<TrajectoryFitness>> parentPopulation = new AtomicReference();
    }
}

