/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.dse.evolutionary.crossovers;

import java.util.Arrays;
import java.util.Random;
import org.eclipse.viatra.dse.base.DesignSpaceManager;
import org.eclipse.viatra.dse.base.ThreadContext;
import org.eclipse.viatra.dse.evolutionary.TrajectoryWithStateFitness;
import org.eclipse.viatra.dse.evolutionary.interfaces.ICrossover;
import org.eclipse.viatra.dse.objectives.Fitness;
import org.eclipse.viatra.dse.objectives.TrajectoryFitness;

public class OnePointCrossover
implements ICrossover {
    private Random random = new Random();

    @Override
    public TrajectoryFitness[] mutate(TrajectoryFitness parent1, TrajectoryFitness parent2, ThreadContext context) {
        TrajectoryFitness[] children = new TrajectoryWithStateFitness[2];
        DesignSpaceManager dsm = context.getDesignSpaceManager();
        Object[] parent1t = parent1.trajectory;
        Object[] parent2t = parent2.trajectory;
        int p1Size = parent1t.length;
        int p2Size = parent2t.length;
        if (p1Size < 2 || p2Size < 2) {
            dsm.undoUntilRoot();
            return null;
        }
        int minSize = Math.min(p1Size, p2Size);
        int index = this.random.nextInt(minSize - 1) + 1;
        dsm.executeTrajectoryWithoutStateCoding(parent1t, index);
        Object[] trajectoryEnd1 = Arrays.copyOfRange(parent2t, index, p2Size);
        context.executeTrajectoryByTryingWithoutStateCoding(trajectoryEnd1);
        Fitness fitness = context.calculateFitness();
        children[0] = new TrajectoryWithStateFitness(dsm.getTrajectoryInfo(), fitness);
        dsm.undoUntilRoot();
        dsm.executeTrajectory(parent2t, index);
        Object[] trajectoryEnd2 = Arrays.copyOfRange(parent1t, index, p1Size);
        context.executeTrajectoryByTryingWithoutStateCoding(trajectoryEnd2);
        fitness = context.calculateFitness();
        children[1] = new TrajectoryWithStateFitness(dsm.getTrajectoryInfo(), fitness);
        dsm.undoUntilRoot();
        return children;
    }
}

