/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.dse.evolutionary.crossovers;

import java.util.Arrays;
import java.util.Random;
import org.eclipse.viatra.dse.base.DesignSpaceManager;
import org.eclipse.viatra.dse.base.ThreadContext;
import org.eclipse.viatra.dse.evolutionary.TrajectoryWithStateFitness;
import org.eclipse.viatra.dse.evolutionary.interfaces.ICrossover;
import org.eclipse.viatra.dse.objectives.Fitness;
import org.eclipse.viatra.dse.objectives.TrajectoryFitness;

public class SwapTransitionCrossover
implements ICrossover {
    private Random random = new Random();

    @Override
    public TrajectoryFitness[] mutate(TrajectoryFitness parent1, TrajectoryFitness parent2, ThreadContext context) {
        TrajectoryFitness[] children = new TrajectoryWithStateFitness[2];
        DesignSpaceManager dsm = context.getDesignSpaceManager();
        Object[] parent1t = parent1.trajectory;
        Object[] parent2t = parent2.trajectory;
        int p1Size = parent1t.length;
        int p2Size = parent2t.length;
        if (p1Size < 2 || p2Size < 2) {
            dsm.undoUntilRoot();
            return null;
        }
        int index1 = this.random.nextInt(p1Size);
        int index2 = this.random.nextInt(p2Size);
        dsm.executeTrajectoryWithoutStateCoding(parent1t, index1);
        dsm.tryFireActivation(parent2t[index2]);
        Object[] trajectoryEnd1 = Arrays.copyOfRange(parent1t, index1 + 1, p1Size);
        context.executeTrajectoryByTryingWithoutStateCoding(trajectoryEnd1);
        Fitness fitness = context.calculateFitness();
        children[0] = new TrajectoryWithStateFitness(dsm.getTrajectoryInfo(), fitness);
        dsm.undoUntilRoot();
        dsm.executeTrajectoryWithoutStateCoding(parent2t, index2);
        dsm.tryFireActivation(parent1t[index1]);
        Object[] trajectoryEnd2 = Arrays.copyOfRange(parent2t, index2 + 1, p2Size);
        context.executeTrajectoryByTryingWithoutStateCoding(trajectoryEnd2);
        fitness = context.calculateFitness();
        children[1] = new TrajectoryWithStateFitness(dsm.getTrajectoryInfo(), fitness);
        dsm.undoUntilRoot();
        return children;
    }
}

