/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.dse.evolutionary.initialselectors;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Random;
import org.eclipse.viatra.dse.base.DesignSpaceManager;
import org.eclipse.viatra.dse.base.ThreadContext;
import org.eclipse.viatra.dse.evolutionary.TrajectoryWithStateFitness;
import org.eclipse.viatra.dse.evolutionary.interfaces.IInitialPopulationSelector;
import org.eclipse.viatra.dse.objectives.TrajectoryFitness;

public class RandomInitalSelector
implements IInitialPopulationSelector {
    private ThreadContext context;
    private DesignSpaceManager dsm;
    private List<TrajectoryFitness> initialPopulation;
    private int populationSize;
    private int foundInstances = 0;
    private int minDepth;
    private int maxDepth;
    private int lengthRemaining;
    private Random random = new Random();
    private boolean isInterrupted = false;

    public RandomInitalSelector(int minDepth, int maxDepth) {
        this.minDepth = minDepth;
        this.maxDepth = maxDepth;
    }

    @Override
    public void setPopulationSize(int populationSize) {
        this.populationSize = populationSize;
    }

    public void initStrategy(ThreadContext context) {
        this.context = context;
        this.dsm = context.getDesignSpaceManager();
        this.lengthRemaining = this.newLength();
        this.initialPopulation = new ArrayList<TrajectoryFitness>(this.populationSize);
    }

    private int newLength() {
        return this.random.nextInt(this.maxDepth - this.minDepth) + this.minDepth;
    }

    /*
     * Unable to fully structure code
     */
    public void explore() {
        ** GOTO lbl19
        {
            --this.lengthRemaining;
            transitions = this.dsm.getTransitionsFromCurrentState();
            index = this.random.nextInt(transitions.size());
            transition = RandomInitalSelector.getByIndex(transitions, index);
            this.dsm.fireActivation(transition);
            gcSatisfied = this.context.checkGlobalConstraints();
            if (!gcSatisfied) {
                this.dsm.undoLastTransformation();
                ++this.lengthRemaining;
            }
            do {
                if (this.lengthRemaining > 0) continue block0;
                ++this.foundInstances;
                this.initialPopulation.add(new TrajectoryWithStateFitness(this.dsm.getTrajectoryInfo(), this.context.calculateFitness()));
                this.dsm.undoUntilRoot();
                this.lengthRemaining = this.newLength();
lbl19:
                // 2 sources

            } while (!this.isInterrupted && this.foundInstances < this.populationSize);
        }
    }

    public void interruptStrategy() {
        this.isInterrupted = true;
    }

    private static Object getByIndex(Collection<Object> availableTransitions, int index) {
        int i = 0;
        for (Object transition : availableTransitions) {
            if (i == index) {
                return transition;
            }
            ++i;
        }
        throw new IndexOutOfBoundsException("size: " + availableTransitions.size() + ", index: " + index);
    }

    @Override
    public List<TrajectoryFitness> getInitialPopulation() {
        return this.initialPopulation;
    }
}

