/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.dse.evolutionary.mutations;

import java.util.Arrays;
import java.util.Random;
import org.eclipse.viatra.dse.base.ThreadContext;
import org.eclipse.viatra.dse.designspace.api.TrajectoryInfo;
import org.eclipse.viatra.dse.evolutionary.TrajectoryWithStateFitness;
import org.eclipse.viatra.dse.evolutionary.interfaces.IMutation;
import org.eclipse.viatra.dse.objectives.Fitness;
import org.eclipse.viatra.dse.objectives.TrajectoryFitness;

public class ModifyRandomTransitionMutation
implements IMutation {
    private Random rnd = new Random();

    @Override
    public TrajectoryFitness mutate(TrajectoryFitness parent, ThreadContext context) {
        Object[] trajectory = parent.trajectory;
        int trajectorySize = trajectory.length;
        int index = this.rnd.nextInt(trajectorySize);
        context.executeTrajectoryWithoutStateCoding(trajectory, index);
        boolean succesful = context.executeRandomActivationId();
        if (!succesful) {
            context.backtrackUntilRoot();
            return null;
        }
        Object[] trajectoryEnd = Arrays.copyOfRange(trajectory, index + 1, trajectory.length);
        context.executeTrajectoryByTryingWithoutStateCoding(trajectoryEnd);
        Fitness calculateFitness = context.calculateFitness();
        TrajectoryInfo trajectoryInfo = context.getTrajectoryInfo();
        TrajectoryWithStateFitness child = new TrajectoryWithStateFitness(trajectoryInfo, calculateFitness);
        context.backtrackUntilRoot();
        return child;
    }
}

