/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.dse.api;

import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.UncheckedExecutionException;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.edit.command.ChangeCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.viatra.dse.api.Solution;
import org.eclipse.viatra.dse.base.DseIdPoolHelper;
import org.eclipse.viatra.dse.statecode.IStateCoder;
import org.eclipse.viatra.dse.statecode.IStateCoderFactory;
import org.eclipse.viatra.dse.util.EMFHelper;
import org.eclipse.viatra.query.runtime.api.IMatchProcessor;
import org.eclipse.viatra.query.runtime.api.IPatternMatch;
import org.eclipse.viatra.query.runtime.api.ViatraQueryEngine;
import org.eclipse.viatra.query.runtime.api.ViatraQueryMatcher;
import org.eclipse.viatra.query.runtime.api.scope.QueryScope;
import org.eclipse.viatra.query.runtime.emf.EMFScope;
import org.eclipse.viatra.query.runtime.exception.ViatraQueryException;
import org.eclipse.viatra.transformation.runtime.emf.rules.batch.BatchTransformationRule;

public class SolutionTrajectory {
    private final List<Object> activationCodes;
    private final List<BatchTransformationRule<?, ?>> transformationRules;
    private final IStateCoderFactory stateCoderFactory;
    private Map<String, Double> fitness;
    private Solution solution;
    private ViatraQueryEngine engine;
    private Notifier model;
    private EditingDomain editingDomain;
    private IStateCoder stateCoder;
    private int currentIndex;

    public SolutionTrajectory(List<Object> activationCodes, List<BatchTransformationRule<?, ?>> transformationRules, IStateCoderFactory stateCoderFactory) {
        Preconditions.checkNotNull(transformationRules, (Object)"Parameter transformationRules cannot be null!");
        Preconditions.checkNotNull((Object)stateCoderFactory, (Object)"Parameter stateCoderFactory cannot be null!");
        Preconditions.checkNotNull(activationCodes, (Object)"Parameter activations cannot be null!");
        Preconditions.checkState((transformationRules.size() == activationCodes.size() ? 1 : 0) != 0, (Object)"The two List parameters must be the same in size.");
        this.activationCodes = activationCodes;
        this.transformationRules = transformationRules;
        this.stateCoderFactory = stateCoderFactory;
        this.currentIndex = 0;
    }

    public void setModel(Notifier model) throws ViatraQueryException {
        EMFScope scope = new EMFScope(model);
        this.engine = ViatraQueryEngine.on((QueryScope)scope);
        this.model = model;
        this.stateCoder = this.stateCoderFactory.createStateCoder();
        this.stateCoder.init(model);
        this.currentIndex = 0;
        DseIdPoolHelper.INSTANCE.disposeByThread();
        DseIdPoolHelper.INSTANCE.registerRules(new DseIdPoolHelper.IGetRuleExecutions(){

            @Override
            public int getRuleExecutions(BatchTransformationRule<?, ?> rule) {
                int id = 0;
                for (BatchTransformationRule r : SolutionTrajectory.this.transformationRules.subList(0, SolutionTrajectory.this.currentIndex)) {
                    if (!r.equals(rule)) continue;
                    ++id;
                }
                return id;
            }
        }, new HashSet(this.transformationRules));
    }

    public void setModelWithEditingDomain(Notifier modelRoot) throws ViatraQueryException {
        this.setModel(modelRoot);
        this.editingDomain = EMFHelper.createEditingDomain(this.model);
    }

    public void doTransformation(Notifier modelRoot) throws ViatraQueryException {
        this.setModel(modelRoot);
        this.doTransformation();
    }

    public void doTransformationUndoable(Notifier modelRoot) throws ViatraQueryException {
        this.setModelWithEditingDomain(modelRoot);
        this.doTransformation();
    }

    public void doTransformation() throws ViatraQueryException {
        while (this.doNextTransformation()) {
        }
    }

    public boolean doNextTransformation() throws ViatraQueryException {
        if (this.currentIndex >= this.activationCodes.size()) {
            return false;
        }
        this.doNextTransformation(this.currentIndex);
        ++this.currentIndex;
        return true;
    }

    private void doNextTransformation(int index) throws ViatraQueryException {
        Preconditions.checkNotNull((Object)this.model, (Object)"The model cannot be null! Use the setModel method.");
        BatchTransformationRule<?, ?> tr = this.transformationRules.get(index);
        ViatraQueryMatcher matcher = tr.getPrecondition().getMatcher(this.engine);
        boolean isActivationFound = false;
        for (final IPatternMatch match : matcher.getAllMatches()) {
            Object matchHash = this.stateCoder.createActivationCode(match);
            if (!matchHash.equals(this.activationCodes.get(index))) continue;
            final IMatchProcessor action = tr.getAction();
            if (this.editingDomain == null) {
                action.process(match);
            } else {
                ChangeCommand cc = new ChangeCommand(this.model){

                    protected void doExecute() {
                        action.process(match);
                    }
                };
                this.editingDomain.getCommandStack().execute((Command)cc);
            }
            isActivationFound = true;
            break;
        }
        if (!isActivationFound) {
            throw new UncheckedExecutionException("Activation was not found for transformation! Possible cause: wrong model, bad state coder.", null);
        }
    }

    public boolean undoLastTransformation() {
        Preconditions.checkNotNull((Object)this.editingDomain, (Object)"To be able to undo the transformation initialize with editing domain.");
        if (this.currentIndex > 0) {
            this.editingDomain.getCommandStack().undo();
            --this.currentIndex;
            return true;
        }
        return false;
    }

    public void undoTransformation() {
        while (this.undoLastTransformation()) {
        }
    }

    public List<Object> getActivationCodes() {
        return this.activationCodes;
    }

    public List<BatchTransformationRule<?, ?>> getTransformationRules() {
        return this.transformationRules;
    }

    public IStateCoderFactory getStateCoderFactory() {
        return this.stateCoderFactory;
    }

    public ViatraQueryEngine getEngine() {
        return this.engine;
    }

    public Notifier getModel() {
        return this.model;
    }

    public IStateCoder getStateCoder() {
        return this.stateCoder;
    }

    public int getCurrentIndex() {
        return this.currentIndex;
    }

    public int getTrajectoryLength() {
        return this.activationCodes.size();
    }

    public Map<String, Double> getFitness() {
        return this.fitness;
    }

    public void setFitness(Map<String, Double> fitness) {
        this.fitness = fitness;
    }

    public String toPrettyString() {
        StringBuilder sb = new StringBuilder();
        for (Object object : this.activationCodes) {
            sb.append(object.toString());
            sb.append(" | ");
        }
        sb.append("| Fitness: ");
        sb.append(this.fitness.toString());
        return sb.toString();
    }

    public int hashCode() {
        return this.activationCodes.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        return this.activationCodes.equals(obj);
    }

    public Solution getSolution() {
        return this.solution;
    }

    public void setSolution(Solution solution) {
        this.solution = solution;
    }
}

