/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.dse.base;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.viatra.dse.api.DSEException;
import org.eclipse.viatra.dse.api.strategy.interfaces.IStrategy;
import org.eclipse.viatra.dse.api.strategy.interfaces.IStrategyFactory;
import org.eclipse.viatra.dse.base.DesignSpaceManager;
import org.eclipse.viatra.dse.base.DseIdPoolHelper;
import org.eclipse.viatra.dse.base.ExplorerThread;
import org.eclipse.viatra.dse.base.GlobalContext;
import org.eclipse.viatra.dse.base.IDseStrategyContext;
import org.eclipse.viatra.dse.base.SingletonSetConflictResolver;
import org.eclipse.viatra.dse.designspace.api.IDesignSpace;
import org.eclipse.viatra.dse.designspace.api.TrajectoryInfo;
import org.eclipse.viatra.dse.objectives.Fitness;
import org.eclipse.viatra.dse.objectives.IGlobalConstraint;
import org.eclipse.viatra.dse.objectives.IObjective;
import org.eclipse.viatra.dse.objectives.ObjectiveComparatorHelper;
import org.eclipse.viatra.dse.solutionstore.SolutionStore;
import org.eclipse.viatra.dse.statecode.IStateCoder;
import org.eclipse.viatra.dse.util.EMFHelper;
import org.eclipse.viatra.query.runtime.api.ViatraQueryEngine;
import org.eclipse.viatra.query.runtime.api.scope.QueryScope;
import org.eclipse.viatra.query.runtime.emf.EMFScope;
import org.eclipse.viatra.query.runtime.exception.ViatraQueryException;
import org.eclipse.viatra.transformation.evm.api.Activation;
import org.eclipse.viatra.transformation.evm.api.RuleEngine;
import org.eclipse.viatra.transformation.evm.api.RuleSpecification;
import org.eclipse.viatra.transformation.evm.api.resolver.ConflictResolver;
import org.eclipse.viatra.transformation.evm.api.resolver.ConflictSet;
import org.eclipse.viatra.transformation.evm.specific.RuleEngines;
import org.eclipse.viatra.transformation.runtime.emf.rules.batch.BatchTransformationRule;

public class ThreadContext
implements IDseStrategyContext {
    private final GlobalContext globalContext;
    private final IStrategy strategy;
    private ExplorerThread explorerThread;
    private RuleEngine ruleEngine;
    private ViatraQueryEngine queryEngine;
    private EditingDomain domain;
    private Notifier model;
    private DesignSpaceManager designSpaceManager;
    private List<IObjective> objectives;
    private List<IGlobalConstraint> globalConstraints;
    private Fitness lastFitness;
    private ObjectiveComparatorHelper objectiveComparatorHelper;
    private AtomicBoolean inited = new AtomicBoolean(false);
    private boolean isFirstThread = false;
    private IObjective[][] leveledObjectives;
    private boolean isThereHardObjective;
    private SingletonSetConflictResolver conflictResolver;

    public SingletonSetConflictResolver getConflictResolver() {
        return this.conflictResolver;
    }

    public ConflictSet getConflictSet() {
        return this.conflictResolver.conflictSet;
    }

    public ThreadContext(GlobalContext globalContext, IStrategy strategy, Notifier model) {
        Preconditions.checkArgument((model != null ? 1 : 0) != 0, (Object)"Cannot initialize ThreadContext on a null model.");
        this.globalContext = globalContext;
        this.strategy = strategy;
        this.model = model;
    }

    @Override
    public void init() throws DSEException {
        AtomicBoolean isFirst = this.globalContext.getFirstThreadContextIniting();
        AtomicBoolean isFirstReady = this.globalContext.getFirstThreadContextInited();
        if (!isFirstReady.get()) {
            if (!isFirst.compareAndSet(false, true)) {
                try {
                    do {
                        Thread.sleep(5L);
                    } while (!isFirstReady.get());
                }
                catch (InterruptedException interruptedException) {}
            } else {
                this.isFirstThread = true;
            }
        }
        Preconditions.checkArgument((!this.inited.getAndSet(true) ? 1 : 0) != 0, (Object)"This Thread context has been initialized already!");
        try {
            EMFScope scope = new EMFScope(this.model);
            this.queryEngine = ViatraQueryEngine.on((QueryScope)scope);
            this.ruleEngine = RuleEngines.createViatraQueryRuleEngine((ViatraQueryEngine)this.queryEngine);
            ConflictResolver conflictResolverToWrap = this.globalContext.getConflictResolver();
            this.conflictResolver = new SingletonSetConflictResolver(conflictResolverToWrap);
            this.ruleEngine.setConflictResolver((ConflictResolver)this.conflictResolver);
            for (BatchTransformationRule<?, ?> tr : this.globalContext.getTransformations()) {
                this.ruleEngine.addRule(tr.getRuleSpecification(), tr.getFilter());
            }
        }
        catch (ViatraQueryException e) {
            throw new DSEException("Failed to create unmanaged ViatraQueryEngine on the model.", e);
        }
        if (this.isFirstThread) {
            this.objectives = this.globalContext.getObjectives();
            this.leveledObjectives = this.globalContext.getLeveledObjectives();
            this.globalConstraints = this.globalContext.getGlobalConstraints();
        } else {
            this.objectives = new ArrayList<IObjective>();
            IObjective[][] leveledObjectivesToCopy = this.globalContext.getLeveledObjectives();
            this.leveledObjectives = new IObjective[leveledObjectivesToCopy.length][];
            int i = 0;
            while (i < leveledObjectivesToCopy.length) {
                this.leveledObjectives[i] = new IObjective[leveledObjectivesToCopy[i].length];
                int j = 0;
                while (j < leveledObjectivesToCopy[i].length) {
                    this.leveledObjectives[i][j] = leveledObjectivesToCopy[i][j].createNew();
                    this.objectives.add(this.leveledObjectives[i][j]);
                    ++j;
                }
                ++i;
            }
            this.globalConstraints = new ArrayList<IGlobalConstraint>();
            for (IGlobalConstraint globalConstraint : this.globalContext.getGlobalConstraints()) {
                this.globalConstraints.add(globalConstraint.createNew());
            }
        }
        this.domain = EMFHelper.createEditingDomain(this.model);
        this.designSpaceManager = new DesignSpaceManager(this, this.model, this.domain, this.globalContext.getStateCoderFactory(), this.globalContext.getDesignSpace(), this.queryEngine);
        for (IObjective objective : this.objectives) {
            objective.init(this);
            if (!objective.isHardObjective()) continue;
            this.isThereHardObjective = true;
        }
        for (IGlobalConstraint globalConstraint : this.globalConstraints) {
            globalConstraint.init(this);
        }
        DseIdPoolHelper.INSTANCE.registerRules(new GetRuleExecutionsImpl(this.getDesignSpaceManager().getTrajectoryInfo().getRules()), this.getRules());
        this.globalContext.initVisualizersForThread(this);
        if (this.isFirstThread) {
            isFirstReady.set(true);
        }
    }

    @Override
    public Fitness calculateFitness() {
        Fitness result = new Fitness();
        boolean satisifiesHardObjectives = true;
        for (IObjective objective : this.objectives) {
            Double fitness = objective.getFitness(this);
            result.put(objective.getName(), fitness);
            if (!objective.isHardObjective() || objective.satisifiesHardObjective(fitness)) continue;
            satisifiesHardObjectives = false;
        }
        if (this.isThereHardObjective) {
            result.setSatisifiesHardObjectives(satisifiesHardObjectives);
        } else {
            result.setSatisifiesHardObjectives(false);
        }
        this.lastFitness = result;
        return result;
    }

    @Override
    public boolean checkGlobalConstraints() {
        for (IGlobalConstraint globalConstraint : this.globalContext.getGlobalConstraints()) {
            if (globalConstraint.checkGlobalConstraint(this)) continue;
            return false;
        }
        return true;
    }

    @Override
    public RuleEngine getRuleEngine() {
        return this.ruleEngine;
    }

    @Override
    public GlobalContext getGlobalContext() {
        return this.globalContext;
    }

    @Override
    public DesignSpaceManager getDesignSpaceManager() {
        return this.designSpaceManager;
    }

    @Override
    public EditingDomain getEditingDomain() {
        return this.domain;
    }

    @Override
    public Notifier getModel() {
        return this.model;
    }

    @Override
    public ViatraQueryEngine getQueryEngine() {
        return this.queryEngine;
    }

    @Override
    public IStrategy getStrategy() {
        return this.strategy;
    }

    @Override
    public ExplorerThread getExplorerThread() {
        return this.explorerThread;
    }

    public void setExplorerThread(ExplorerThread explorerThread) {
        this.explorerThread = explorerThread;
    }

    @Override
    public Fitness getLastFitness() {
        return this.lastFitness;
    }

    @Override
    public ObjectiveComparatorHelper getObjectiveComparatorHelper() {
        if (this.objectiveComparatorHelper == null) {
            this.objectiveComparatorHelper = new ObjectiveComparatorHelper(this.leveledObjectives);
        }
        return this.objectiveComparatorHelper;
    }

    @Override
    public IObjective[][] getLeveledObjectives() {
        return this.leveledObjectives;
    }

    @Override
    public List<IObjective> getObjectives() {
        return this.objectives;
    }

    @Override
    public List<IGlobalConstraint> getGlobalConstraints() {
        return this.globalConstraints;
    }

    @Override
    public SolutionStore getSolutionStore() {
        return this.globalContext.getSolutionStore();
    }

    @Override
    public void newSolution() {
        this.globalContext.getSolutionStore().newSolution(this);
    }

    @Override
    public Object getSharedObject() {
        return this.globalContext.getSharedObject();
    }

    @Override
    public void setSharedObject(Object sharedObject) {
        this.globalContext.setSharedObject(sharedObject);
    }

    @Override
    public Set<BatchTransformationRule<?, ?>> getRules() {
        return this.globalContext.getTransformations();
    }

    @Override
    public BatchTransformationRule<?, ?> getRuleByRuleSpecification(RuleSpecification<?> ruleSpecification) {
        return this.globalContext.getSpecificationRuleMap().get(ruleSpecification);
    }

    @Override
    public ExplorerThread tryStartNewThread(IStrategy strategy) {
        return this.globalContext.tryStartNewThread(this, strategy);
    }

    @Override
    public ExplorerThread tryStartNewThreadWithoutModelClone(IStrategy strategy) {
        return this.globalContext.tryStartNewThreadWithoutModelClone(this, strategy);
    }

    @Override
    public void startAllThreads(IStrategyFactory strategyFactory) {
        this.globalContext.startAllThreads(this, strategyFactory);
    }

    @Override
    public IStateCoder getStateCoder() {
        return this.designSpaceManager.getStateCoder();
    }

    @Override
    public IDesignSpace getDesignSpace() {
        return this.globalContext.getDesignSpace();
    }

    @Override
    public TrajectoryInfo getTrajectoryInfo() {
        return this.designSpaceManager.getTrajectoryInfo();
    }

    @Override
    public List<Object> getTrajectory() {
        return this.designSpaceManager.getTrajectoryInfo().getTrajectory();
    }

    @Override
    public List<Object> getTrajectoryCopied() {
        return new ArrayList<Object>(this.getTrajectory());
    }

    @Override
    public int getDepth() {
        return this.designSpaceManager.getTrajectoryInfo().getDepth();
    }

    @Override
    public Object getCurrentStateId() {
        return this.designSpaceManager.getTrajectoryInfo().getCurrentStateId();
    }

    @Override
    public Object getTransitionByActivation(Activation<?> activation) {
        return this.designSpaceManager.getTransitionByActivation(activation);
    }

    @Override
    public Activation<?> getActivationById(Object activationId) {
        return this.designSpaceManager.getActivationById(activationId);
    }

    @Override
    public BatchTransformationRule<?, ?> getRuleByActivation(Activation<?> activation) {
        return this.designSpaceManager.getRuleByActivation(activation);
    }

    @Override
    public BatchTransformationRule<?, ?> getRuleByActivationId(Object activationId) {
        return this.designSpaceManager.getRuleByActivationId(activationId);
    }

    @Override
    public Collection<Object> getCurrentActivationIds() {
        return this.designSpaceManager.getTransitionsFromCurrentState();
    }

    @Override
    public Collection<Object> getUntraversedActivationIds() {
        return this.designSpaceManager.getUntraversedTransitionsFromCurrentState();
    }

    @Override
    public void executeAcitvationId(Object activationId) {
        this.designSpaceManager.fireActivation(activationId);
    }

    @Override
    public boolean tryExecuteAcitvationId(Object activationId) {
        return this.designSpaceManager.tryFireActivation(activationId);
    }

    @Override
    public boolean executeRandomActivationId() {
        return this.designSpaceManager.executeRandomActivationId();
    }

    @Override
    public void executeTrajectory(Object[] activationIds) {
        this.designSpaceManager.executeTrajectory(activationIds);
    }

    @Override
    public void executeTrajectory(Object[] activationIds, int excludedIndex) {
        this.designSpaceManager.executeTrajectory(activationIds, excludedIndex);
    }

    @Override
    public int executeTrajectoryByTrying(Object[] activationIds) {
        return this.designSpaceManager.executeTrajectoryByTrying(activationIds);
    }

    @Override
    public int executeTrajectoryByTrying(Object[] activationIds, int excludedIndex) {
        return this.designSpaceManager.executeTrajectoryByTrying(activationIds, excludedIndex);
    }

    @Override
    public int executeTrajectoryWithoutStateCoding(Object[] activationIds) {
        return this.designSpaceManager.executeTrajectoryWithoutStateCoding(activationIds);
    }

    @Override
    public int executeTrajectoryWithoutStateCoding(Object[] activationIds, int excludedIndex) {
        return this.designSpaceManager.executeTrajectoryWithoutStateCoding(activationIds, excludedIndex);
    }

    @Override
    public int executeTrajectoryByTryingWithoutStateCoding(Object[] activationIds) {
        return this.designSpaceManager.executeTrajectoryByTryingWithoutStateCoding(activationIds);
    }

    @Override
    public int executeTrajectoryByTryingWithoutStateCoding(Object[] activationIds, int excludedIndex) {
        return this.designSpaceManager.executeTrajectoryByTryingWithoutStateCoding(activationIds, excludedIndex);
    }

    @Override
    public boolean backtrack() {
        return this.designSpaceManager.undoLastTransformation();
    }

    @Override
    public void backtrackUntilRoot() {
        this.designSpaceManager.undoUntilRoot();
    }

    @Override
    public boolean isCurrentStateAlreadyTraversed() {
        return this.designSpaceManager.isNewModelStateAlreadyTraversed();
    }

    @Override
    public boolean isCurrentStateInTrajectory() {
        return this.designSpaceManager.isCurentStateInTrajectory();
    }

    private static class GetRuleExecutionsImpl
    implements DseIdPoolHelper.IGetRuleExecutions {
        private List<BatchTransformationRule<?, ?>> executedRules;

        public GetRuleExecutionsImpl(List<BatchTransformationRule<?, ?>> executedRulesView) {
            this.executedRules = executedRulesView;
        }

        @Override
        public int getRuleExecutions(BatchTransformationRule<?, ?> rule) {
            int nextId = 0;
            for (BatchTransformationRule<?, ?> r : this.executedRules) {
                if (!r.equals(rule)) continue;
                ++nextId;
            }
            return nextId;
        }
    }
}

