/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.dse.designspace.api;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import org.eclipse.viatra.dse.designspace.api.IDesignSpace;

public class DesignSpace
implements IDesignSpace {
    Set<Object> statesView;
    Set<Object> rootStates;
    Set<Object> rootStatesView;
    Map<Object, List<Object>> statesAndActivations;
    Random random = new Random();

    public DesignSpace() {
        this.rootStates = new HashSet<Object>();
        this.rootStatesView = Collections.unmodifiableSet(this.rootStates);
        this.statesAndActivations = new HashMap<Object, List<Object>>();
        this.statesView = this.statesAndActivations.keySet();
    }

    @Override
    public synchronized Collection<Object> getStates() {
        return this.statesView;
    }

    @Override
    public synchronized Collection<Object> getRoots() {
        return this.rootStatesView;
    }

    @Override
    public synchronized void addState(Object sourceStateId, Object firedActivationId, Object newStateId) {
        List<Object> activtionIds = this.statesAndActivations.get(newStateId);
        if (activtionIds == null) {
            activtionIds = new ArrayList<Object>();
            this.statesAndActivations.put(newStateId, activtionIds);
            if (sourceStateId == null) {
                this.rootStates.add(newStateId);
                return;
            }
        }
        if ((activtionIds = this.statesAndActivations.get(sourceStateId)) == null) {
            activtionIds = new ArrayList<Object>();
            activtionIds.add(firedActivationId);
            this.statesAndActivations.put(sourceStateId, activtionIds);
        } else {
            activtionIds.add(firedActivationId);
        }
    }

    @Override
    public synchronized boolean isTraversed(Object stateId) {
        return this.statesAndActivations.containsKey(stateId);
    }

    @Override
    public synchronized Collection<Object> getActivationIds(Object stateId) {
        return this.statesAndActivations.get(stateId);
    }

    @Override
    public synchronized Object getRandomActivationId(Object stateId) {
        List<Object> activations = this.statesAndActivations.get(stateId);
        int index = this.random.nextInt(activations.size());
        return activations.get(index);
    }

    @Override
    public synchronized long getNumberOfStates() {
        return this.statesAndActivations.size();
    }

    @Override
    public synchronized long getNumberOfTransitions() {
        int numberOfTransitions = 0;
        for (List<Object> activations : this.statesAndActivations.values()) {
            numberOfTransitions += activations.size();
        }
        return numberOfTransitions;
    }
}

