/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.dse.objectives.impl;

import com.google.common.base.Preconditions;
import java.util.Comparator;
import org.eclipse.viatra.dse.base.ThreadContext;
import org.eclipse.viatra.dse.objectives.Comparators;
import org.eclipse.viatra.dse.objectives.IObjective;

public abstract class BaseObjective
implements IObjective {
    protected final String name;
    protected Comparator<Double> comparator = Comparators.HIGHER_IS_BETTER;
    protected int level = 0;
    protected double fitnessConstraint;
    protected boolean isThereFitnessConstraint = false;
    protected Comparator<Double> fitnessConstraintComparator;

    public BaseObjective(String name) {
        Preconditions.checkNotNull((Object)name, (Object)"Name of the objective cannot be null.");
        this.name = name;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setComparator(Comparator<Double> comparator) {
        this.comparator = comparator;
    }

    @Override
    public Comparator<Double> getComparator() {
        return this.comparator;
    }

    @Override
    public void setLevel(int level) {
        this.level = level;
    }

    @Override
    public int getLevel() {
        return this.level;
    }

    public BaseObjective withLevel(int level) {
        this.setLevel(level);
        return this;
    }

    public BaseObjective withComparator(Comparator<Double> comparator) {
        this.setComparator(comparator);
        return this;
    }

    public BaseObjective withHardConstraintOnFitness(double fitnessConstraint, Comparator<Double> fitnessConstraintComparator) {
        this.fitnessConstraint = fitnessConstraint;
        this.fitnessConstraintComparator = fitnessConstraintComparator;
        this.isThereFitnessConstraint = true;
        return this;
    }

    public BaseObjective withHardConstraintOnFitness(double fitnessConstraint) {
        return this.withHardConstraintOnFitness(fitnessConstraint, null);
    }

    @Override
    public void init(ThreadContext context) {
        if (this.fitnessConstraintComparator == null) {
            this.fitnessConstraintComparator = this.comparator;
        }
    }

    @Override
    public boolean isHardObjective() {
        return this.isThereFitnessConstraint;
    }

    @Override
    public boolean satisifiesHardObjective(Double fitness) {
        int compare;
        return !this.isThereFitnessConstraint || (compare = this.fitnessConstraintComparator.compare(fitness, this.fitnessConstraint)) >= 0;
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof BaseObjective) {
            BaseObjective baseObjective = (BaseObjective)obj;
            return this.name.equals(baseObjective.getName());
        }
        return false;
    }

    public String toString() {
        return this.name;
    }
}

