/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.dse.objectives.impl;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.viatra.dse.api.DSEException;
import org.eclipse.viatra.dse.base.ThreadContext;
import org.eclipse.viatra.dse.objectives.IObjective;
import org.eclipse.viatra.dse.objectives.impl.BaseObjective;
import org.eclipse.viatra.dse.objectives.impl.ModelQueryType;
import org.eclipse.viatra.query.runtime.api.IPatternMatch;
import org.eclipse.viatra.query.runtime.api.IQuerySpecification;
import org.eclipse.viatra.query.runtime.api.ViatraQueryEngine;
import org.eclipse.viatra.query.runtime.api.ViatraQueryMatcher;
import org.eclipse.viatra.query.runtime.exception.ViatraQueryException;

public class ConstraintsObjective
extends BaseObjective {
    public static final String DEFAULT_NAME = "ConstraintsObjective";
    protected List<QueryConstraint> softConstraints;
    protected List<QueryConstraint> hardConstraints;
    protected List<ViatraQueryMatcher<? extends IPatternMatch>> softMatchers;
    protected List<ViatraQueryMatcher<? extends IPatternMatch>> hardMatchers;
    protected List<Integer> softMatches;
    protected List<Integer> hardMatches;

    public ConstraintsObjective(String name, List<QueryConstraint> softConstraints, List<QueryConstraint> hardConstraints) {
        super(name);
        Preconditions.checkNotNull(softConstraints, (Object)"The list of soft constraints cannot be null.");
        Preconditions.checkNotNull(hardConstraints, (Object)"The list of hard constraints cannot be null.");
        this.softConstraints = softConstraints;
        this.hardConstraints = hardConstraints;
    }

    public ConstraintsObjective(String name, List<QueryConstraint> hardConstraints) {
        this(name, new ArrayList<QueryConstraint>(), hardConstraints);
    }

    public ConstraintsObjective(List<QueryConstraint> hardConstraints) {
        this(DEFAULT_NAME, new ArrayList<QueryConstraint>(), hardConstraints);
    }

    public ConstraintsObjective(String name) {
        this(name, new ArrayList<QueryConstraint>(), new ArrayList<QueryConstraint>());
    }

    public ConstraintsObjective() {
        this(DEFAULT_NAME, new ArrayList<QueryConstraint>(), new ArrayList<QueryConstraint>());
    }

    public ConstraintsObjective withSoftConstraint(String name, IQuerySpecification<? extends ViatraQueryMatcher<? extends IPatternMatch>> softConstraint, double weight) {
        this.softConstraints.add(new QueryConstraint(name, softConstraint, weight));
        return this;
    }

    public ConstraintsObjective withSoftConstraint(IQuerySpecification<? extends ViatraQueryMatcher<? extends IPatternMatch>> softConstraint, double weight) {
        return this.withSoftConstraint(softConstraint.getFullyQualifiedName(), softConstraint, weight);
    }

    public ConstraintsObjective withHardConstraint(String name, IQuerySpecification<? extends ViatraQueryMatcher<? extends IPatternMatch>> hardConstraint, ModelQueryType type) {
        this.hardConstraints.add(new QueryConstraint(name, hardConstraint, type));
        return this;
    }

    public ConstraintsObjective withHardConstraint(String name, IQuerySpecification<? extends ViatraQueryMatcher<? extends IPatternMatch>> hardConstraint) {
        this.hardConstraints.add(new QueryConstraint(name, hardConstraint, ModelQueryType.MUST_HAVE_MATCH));
        return this;
    }

    public ConstraintsObjective withHardConstraint(IQuerySpecification<? extends ViatraQueryMatcher<? extends IPatternMatch>> hardConstraint) {
        return this.withHardConstraint(hardConstraint.getFullyQualifiedName(), hardConstraint, ModelQueryType.MUST_HAVE_MATCH);
    }

    public ConstraintsObjective withHardConstraint(IQuerySpecification<? extends ViatraQueryMatcher<? extends IPatternMatch>> hardConstraint, ModelQueryType type) {
        return this.withHardConstraint(hardConstraint.getFullyQualifiedName(), hardConstraint, type);
    }

    @Override
    public Double getFitness(ThreadContext context) {
        if (this.softConstraints.isEmpty() && this.satisifiesHardObjective(null)) {
            return new Double(1.0);
        }
        double result = 0.0;
        int i = 0;
        while (i < this.softConstraints.size()) {
            int countMatches = this.softMatchers.get(i).countMatches();
            result += (double)countMatches * this.softConstraints.get((int)i).weight;
            this.softMatches.set(i, countMatches);
            ++i;
        }
        return new Double(result);
    }

    @Override
    public void init(ThreadContext context) {
        super.init(context);
        this.softMatches = new ArrayList<Integer>(this.softConstraints.size());
        this.softMatchers = new ArrayList<ViatraQueryMatcher<? extends IPatternMatch>>(this.softConstraints.size());
        this.hardMatches = new ArrayList<Integer>(this.hardConstraints.size());
        this.hardMatchers = new ArrayList<ViatraQueryMatcher<? extends IPatternMatch>>(this.hardConstraints.size());
        int i = 0;
        while (i < this.softConstraints.size()) {
            this.softMatches.add(0);
            ++i;
        }
        i = 0;
        while (i < this.hardConstraints.size()) {
            this.hardMatches.add(0);
            ++i;
        }
        try {
            ViatraQueryEngine queryEngine = context.getQueryEngine();
            for (QueryConstraint qc : this.softConstraints) {
                this.softMatchers.add((ViatraQueryMatcher<? extends IPatternMatch>)qc.query.getMatcher(queryEngine));
            }
            for (QueryConstraint qc : this.hardConstraints) {
                this.hardMatchers.add((ViatraQueryMatcher<? extends IPatternMatch>)qc.query.getMatcher(queryEngine));
            }
        }
        catch (ViatraQueryException e) {
            throw new DSEException("Couldn't initialize the VIATRA Query matcher, see inner exception", e);
        }
    }

    @Override
    public IObjective createNew() {
        new ArrayList(this.softConstraints.size());
        ConstraintsObjective result = new ConstraintsObjective(this.name, this.softConstraints, this.hardConstraints);
        if (this.isThereFitnessConstraint) {
            result.withHardConstraintOnFitness(this.fitnessConstraint, this.fitnessConstraintComparator);
        }
        return result.withComparator(this.comparator).withLevel(this.level);
    }

    @Override
    public boolean isHardObjective() {
        return !this.hardConstraints.isEmpty() || super.isHardObjective();
    }

    @Override
    public boolean satisifiesHardObjective(Double fitness) {
        boolean result = true;
        int i = 0;
        while (i < this.hardConstraints.size()) {
            ModelQueryType type = this.hardConstraints.get((int)i).type;
            int countMatches = this.hardMatchers.get(i).countMatches();
            this.hardMatches.set(i, countMatches);
            if (type.equals((Object)ModelQueryType.MUST_HAVE_MATCH) && countMatches <= 0 || type.equals((Object)ModelQueryType.NO_MATCH) && countMatches > 0) {
                result = false;
            }
            ++i;
        }
        result = super.satisifiesHardObjective(fitness) ? result : false;
        return result;
    }

    public List<QueryConstraint> getSoftConstraints() {
        return this.softConstraints;
    }

    public List<QueryConstraint> getHardConstraints() {
        return this.hardConstraints;
    }

    public String getSoftName(int index) {
        return this.softConstraints.get((int)index).name;
    }

    public String getHardName(int index) {
        return this.hardConstraints.get((int)index).name;
    }

    public List<Integer> getSoftMatches() {
        return this.softMatches;
    }

    public List<Integer> getHardMatches() {
        return this.hardMatches;
    }

    public List<String> getSoftNames() {
        ArrayList<String> softNames = new ArrayList<String>(this.softConstraints.size());
        for (QueryConstraint qc : this.softConstraints) {
            softNames.add(qc.name);
        }
        return softNames;
    }

    public static class QueryConstraint {
        public final String name;
        public final IQuerySpecification<? extends ViatraQueryMatcher<? extends IPatternMatch>> query;
        public final Double weight;
        public final ModelQueryType type;

        public QueryConstraint(String name, IQuerySpecification<? extends ViatraQueryMatcher<? extends IPatternMatch>> query, Double weight, ModelQueryType type) {
            this.name = name;
            this.query = query;
            this.weight = weight;
            this.type = type;
        }

        public QueryConstraint(String name, IQuerySpecification<? extends ViatraQueryMatcher<? extends IPatternMatch>> query, Double weight) {
            this(name, query, weight, ModelQueryType.MUST_HAVE_MATCH);
        }

        public QueryConstraint(String name, IQuerySpecification<? extends ViatraQueryMatcher<? extends IPatternMatch>> query, ModelQueryType type) {
            this(name, query, 0.0, type);
        }
    }
}

