/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.dse.objectives.impl;

import org.eclipse.viatra.dse.base.ThreadContext;
import org.eclipse.viatra.dse.objectives.IObjective;
import org.eclipse.viatra.dse.objectives.impl.BaseObjective;

public class MinimalDepthHardObjective
extends BaseObjective {
    private static final String DEFAULT_NAME = "MinimalDepthHardObjective";
    protected int minDepth;

    public MinimalDepthHardObjective(int minDepth) {
        super(DEFAULT_NAME);
        this.minDepth = minDepth;
    }

    public MinimalDepthHardObjective(String name, int minDepth) {
        super(name);
        this.minDepth = minDepth;
    }

    @Override
    public Double getFitness(ThreadContext context) {
        return context.getDepth() <= this.minDepth ? 1.0 : 0.0;
    }

    @Override
    public boolean isHardObjective() {
        return true;
    }

    @Override
    public boolean satisifiesHardObjective(Double fitness) {
        return fitness > 0.5;
    }

    @Override
    public IObjective createNew() {
        return this;
    }
}

