/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.integration.gmf;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import com.google.common.collect.UnmodifiableIterator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.domain.IEditingDomainProvider;
import org.eclipse.gef.EditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.GraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.parts.IDiagramGraphicalViewer;
import org.eclipse.gmf.runtime.diagram.ui.parts.IDiagramWorkbenchPart;
import org.eclipse.gmf.runtime.diagram.ui.resources.editor.parts.DiagramDocumentEditor;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.ui.IEditorPart;
import org.eclipse.viatra.query.runtime.api.IModelConnectorTypeEnum;
import org.eclipse.viatra.query.tooling.ui.queryexplorer.adapters.EMFModelConnector;

public class GMFModelConnector
extends EMFModelConnector {
    public GMFModelConnector(IEditorPart editorPart) {
        super(editorPart);
    }

    public Notifier getNotifier(IModelConnectorTypeEnum modelConnectorTypeEnum) {
        Notifier result = null;
        if (IModelConnectorTypeEnum.RESOURCESET.equals((Object)modelConnectorTypeEnum)) {
            if (this.editorPart instanceof DiagramDocumentEditor) {
                DiagramDocumentEditor diagramDocumentEditor = (DiagramDocumentEditor)this.editorPart;
                return diagramDocumentEditor.getEditingDomain().getResourceSet();
            }
            if (this.editorPart instanceof IDiagramWorkbenchPart) {
                IDiagramWorkbenchPart diagramWorkbenchPart = (IDiagramWorkbenchPart)this.editorPart;
                return diagramWorkbenchPart.getDiagramEditPart().getEditingDomain().getResourceSet();
            }
            if (this.editorPart instanceof IEditingDomainProvider) {
                EditingDomain editingDomain = ((IEditingDomainProvider)this.editorPart).getEditingDomain();
                return editingDomain.getResourceSet();
            }
        } else if (IModelConnectorTypeEnum.RESOURCE.equals((Object)modelConnectorTypeEnum)) {
            if (this.editorPart instanceof DiagramDocumentEditor) {
                DiagramDocumentEditor diagramDocumentEditor = (DiagramDocumentEditor)this.editorPart;
                Diagram diagram = diagramDocumentEditor.getDiagram();
                if (diagram != null && diagram.getElement() != null) {
                    return diagram.getElement().eResource();
                }
                return ((EObject)diagramDocumentEditor.getDiagramEditPart().getModel()).eResource();
            }
            if (this.editorPart instanceof IDiagramWorkbenchPart) {
                IDiagramWorkbenchPart diagramWorkbenchPart = (IDiagramWorkbenchPart)this.editorPart;
                Diagram diagram = diagramWorkbenchPart.getDiagram();
                if (diagram != null && diagram.getElement() != null) {
                    return diagram.getElement().eResource();
                }
                return ((EObject)diagramWorkbenchPart.getDiagramEditPart().getModel()).eResource();
            }
        }
        return result;
    }

    protected TreePath createTreePath(IEditorPart editor, EObject obj) {
        if (editor instanceof DiagramDocumentEditor) {
            DiagramDocumentEditor providerEditor = (DiagramDocumentEditor)editor;
            return this.createTreePath(providerEditor.getDiagramEditPart().getPrimaryChildEditPart(), obj);
        }
        if (editor instanceof IDiagramWorkbenchPart) {
            IDiagramWorkbenchPart dwp = (IDiagramWorkbenchPart)editor;
            return this.createTreePath(dwp.getDiagramEditPart().getPrimaryChildEditPart(), obj);
        }
        return null;
    }

    private TreePath createTreePath(EditPart epBegin, EObject obj) {
        if (epBegin instanceof GraphicalEditPart) {
            ArrayList<EditPart> nodes = new ArrayList<EditPart>();
            EditPart ep = ((GraphicalEditPart)epBegin).findEditPart((EditPart)epBegin.getRoot(), obj);
            if (ep != null) {
                nodes.add(ep);
                return new TreePath(nodes.toArray());
            }
        }
        return null;
    }

    protected void navigateToElements(IEditorPart editorPart, IStructuredSelection selection) {
        super.navigateToElements(editorPart, selection);
        IDiagramGraphicalViewer viewer = null;
        if (editorPart instanceof DiagramDocumentEditor) {
            DiagramDocumentEditor providerEditor = (DiagramDocumentEditor)editorPart;
            viewer = providerEditor.getDiagramGraphicalViewer();
        } else if (editorPart instanceof IDiagramWorkbenchPart) {
            IDiagramWorkbenchPart dwp = (IDiagramWorkbenchPart)editorPart;
            viewer = dwp.getDiagramGraphicalViewer();
        }
        if (viewer != null && selection.getFirstElement() instanceof GraphicalEditPart) {
            GraphicalEditPart part = (GraphicalEditPart)selection.getFirstElement();
            viewer.reveal((EditPart)part);
        }
    }

    protected Collection<EObject> getSelectedEObjects(ISelection selection) {
        if (selection instanceof IStructuredSelection) {
            UnmodifiableIterator selectionIterator = Iterators.filter((Iterator)((IStructuredSelection)selection).iterator(), IGraphicalEditPart.class);
            return Lists.newArrayList((Iterator)Iterators.filter((Iterator)Iterators.transform((Iterator)selectionIterator, (Function)new Function<IGraphicalEditPart, EObject>(){

                public EObject apply(IGraphicalEditPart input) {
                    return input.resolveSemanticElement();
                }
            }), (Predicate)Predicates.notNull()));
        }
        return super.getSelectedEObjects();
    }
}

