package org.eclipse.viatra.integration.mwe2.initializer

import com.google.inject.Guice
import org.eclipse.emf.ecore.EPackage
import org.eclipse.emf.ecore.resource.Resource
import org.eclipse.emf.ecore.xmi.impl.EcoreResourceFactoryImpl
import org.eclipse.emf.ecore.xmi.impl.XMIResourceFactoryImpl
import org.eclipse.emf.mwe2.language.Mwe2RuntimeModule
import org.eclipse.emf.mwe2.language.Mwe2StandaloneSetup
import org.eclipse.emf.mwe2.launch.runtime.Mwe2Runner
import org.eclipse.xtext.XtextPackage
import org.eclipse.xtext.resource.impl.BinaryGrammarResourceFactoryImpl

public class MWE2IntegrationInitializer {
	
	def Mwe2Runner initializeHeadlessEclipse(ClassLoader classLoader){
		val setup = new Mwe2StandaloneSetup
		 		if (!Resource.Factory.Registry.INSTANCE.getExtensionToFactoryMap().containsKey("ecore"))
			Resource.Factory.Registry.INSTANCE.getExtensionToFactoryMap().put(
				"ecore", new EcoreResourceFactoryImpl());
		if (!Resource.Factory.Registry.INSTANCE.getExtensionToFactoryMap().containsKey("xmi"))
			Resource.Factory.Registry.INSTANCE.getExtensionToFactoryMap().put(
				"xmi", new XMIResourceFactoryImpl());
		if (!Resource.Factory.Registry.INSTANCE.getExtensionToFactoryMap().containsKey("xtextbin"))
			Resource.Factory.Registry.INSTANCE.getExtensionToFactoryMap().put(
				"xtextbin", new BinaryGrammarResourceFactoryImpl());
		if (!EPackage.Registry.INSTANCE.containsKey(XtextPackage.eNS_URI))
			EPackage.Registry.INSTANCE.put(XtextPackage.eNS_URI, XtextPackage.eINSTANCE);
		 
		var injector =Guice.createInjector(new Mwe2RuntimeModule() {
			
			override ClassLoader bindClassLoaderToInstance() {
				return classLoader
			}
			
		})
		setup.register(injector)
		var mweRunner = injector.getInstance(Mwe2Runner)
		mweRunner
	}
	
	def Mwe2Runner initializePlainJava(){
		val injector = new Mwe2StandaloneSetup().createInjectorAndDoEMFRegistration();
        val mweRunner = injector.getInstance(Mwe2Runner);
		mweRunner
	}
}