/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.query.runtime.base.itc.alg.counting;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.viatra.query.runtime.base.itc.alg.misc.ITcRelation;
import org.eclipse.viatra.query.runtime.base.itc.alg.misc.topsort.TopSort;
import org.eclipse.viatra.query.runtime.base.itc.igraph.IBiDirectionalGraphDataSource;

public class CountingTcRelation<V>
implements ITcRelation<V> {
    private Map<V, Map<V, Integer>> tuplesForward = new HashMap<V, Map<V, Integer>>();
    private Map<V, Map<V, Integer>> tuplesBackward = null;

    protected CountingTcRelation(boolean backwardIndexing) {
        if (backwardIndexing) {
            this.tuplesBackward = new HashMap<V, Map<V, Integer>>();
        }
    }

    protected boolean isEmpty() {
        return this.tuplesForward.isEmpty();
    }

    protected void clear() {
        this.tuplesForward.clear();
        if (this.tuplesBackward != null) {
            this.tuplesBackward.clear();
        }
    }

    protected void union(CountingTcRelation<V> rA) {
        for (V source : rA.tuplesForward.keySet()) {
            for (V target : rA.tuplesForward.get(source).keySet()) {
                this.addTuple(source, target, rA.tuplesForward.get(source).get(target));
            }
        }
    }

    public int getCount(V source, V target) {
        if (this.tuplesForward.containsKey(source) && this.tuplesForward.get(source).containsKey(target)) {
            return this.tuplesForward.get(source).get(target);
        }
        return 0;
    }

    public boolean addTuple(V source, V target, int count) {
        Map<Integer, Integer> sMap = null;
        Map<Integer, Integer> tMap = null;
        if (this.tuplesBackward != null) {
            tMap = this.tuplesBackward.get(target);
            if (tMap == null) {
                sMap = new HashMap<V, Integer>();
                sMap.put((Integer)source, count);
                this.tuplesBackward.put((Map<V, Integer>)target, (Map<Map<V, Integer>, Integer>)sMap);
            } else if (tMap.containsKey(source)) {
                tMap.put((Integer)source, tMap.get(source) + count);
                if (tMap.get(source) == 0) {
                    tMap.remove(source);
                    if (tMap.size() == 0) {
                        this.tuplesBackward.remove(target);
                    }
                }
            } else {
                tMap.put((Integer)source, count);
            }
        }
        if ((sMap = this.tuplesForward.get(source)) == null) {
            tMap = new HashMap<V, Integer>();
            tMap.put((Integer)target, count);
            this.tuplesForward.put((Map<Integer, Integer>)source, (Map<Map<Integer, Integer>, Integer>)tMap);
            return true;
        }
        if (sMap.containsKey(target)) {
            sMap.put((Integer)target, sMap.get(target) + count);
            if (sMap.get(target) == 0) {
                sMap.remove(target);
                if (sMap.size() == 0) {
                    this.tuplesForward.remove(source);
                }
                return true;
            }
            return false;
        }
        sMap.put((Integer)target, count);
        return true;
    }

    public void deleteTupleEnd(V tupleEnd) {
        HashSet<V> tmp;
        this.tuplesForward.remove(tupleEnd);
        if (this.tuplesForward.keySet() != null) {
            tmp = new HashSet<V>(this.tuplesForward.keySet());
            for (Object key : tmp) {
                this.tuplesForward.get(key).remove(tupleEnd);
                if (this.tuplesForward.get(key).size() != 0) continue;
                this.tuplesForward.remove(key);
            }
        }
        if (this.tuplesBackward != null) {
            this.tuplesBackward.remove(tupleEnd);
            if (this.tuplesBackward.keySet() != null) {
                tmp = new HashSet<V>(this.tuplesBackward.keySet());
                for (Object key : tmp) {
                    this.tuplesBackward.get(key).remove(tupleEnd);
                    if (this.tuplesBackward.get(key).size() != 0) continue;
                    this.tuplesBackward.remove(key);
                }
            }
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("TcRelation = ");
        for (V source : this.tuplesForward.keySet()) {
            for (V target : this.tuplesForward.get(source).keySet()) {
                sb.append("{(" + source + "," + target + ")," + this.tuplesForward.get(source).get(target) + "} ");
            }
        }
        return sb.toString();
    }

    @Override
    public Set<V> getTupleEnds(V source) {
        Map<V, Integer> tupEnds = this.tuplesForward.get(source);
        if (tupEnds == null) {
            return null;
        }
        return new HashSet<V>(this.tuplesForward.get(source).keySet());
    }

    public Set<V> getTupleStarts(V target) {
        if (this.tuplesBackward != null) {
            Map<V, Integer> tupStarts = this.tuplesBackward.get(target);
            if (tupStarts == null) {
                return null;
            }
            return this.tuplesBackward.get(target).keySet();
        }
        return null;
    }

    @Override
    public Set<V> getTupleStarts() {
        HashSet<V> nodes = new HashSet<V>();
        nodes.addAll(this.tuplesForward.keySet());
        return nodes;
    }

    public boolean containsTuple(V source, V target) {
        return this.tuplesForward.containsKey(source) && this.tuplesForward.get(source).containsKey(target);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        CountingTcRelation aTR = (CountingTcRelation)obj;
        for (V source : aTR.tuplesForward.keySet()) {
            for (V target : aTR.tuplesForward.get(source).keySet()) {
                if (this.containsTuple(source, target)) continue;
                return false;
            }
        }
        for (V source : this.tuplesForward.keySet()) {
            for (V target : this.tuplesForward.get(source).keySet()) {
                if (aTR.containsTuple(source, target)) continue;
                return false;
            }
        }
        return true;
    }

    public int hashCode() {
        int hash = 7;
        for (Map.Entry<V, Map<V, Integer>> entry : this.tuplesForward.entrySet()) {
            hash = 31 * hash + entry.hashCode();
        }
        for (Map.Entry<V, Map<V, Integer>> entry : this.tuplesBackward.entrySet()) {
            hash = 31 * hash + entry.hashCode();
        }
        return hash;
    }

    public static <V> CountingTcRelation<V> createFrom(IBiDirectionalGraphDataSource<V> gds) {
        List<V> topologicalSorting = TopSort.getTopologicalSorting(gds);
        CountingTcRelation<V> tc = new CountingTcRelation<V>(true);
        Collections.reverse(topologicalSorting);
        for (V n : topologicalSorting) {
            List<V> sourceNodes = gds.getSourceNodes(n);
            if (sourceNodes == null) continue;
            Set<V> tupEnds = tc.getTupleEnds(n);
            for (V s : sourceNodes) {
                tc.addTuple(s, n, 1);
                if (tupEnds == null) continue;
                for (V t : tupEnds) {
                    tc.addTuple(s, t, 1);
                }
            }
        }
        return tc;
    }
}

