/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.query.runtime.base.itc.alg.misc.dfs;

import java.util.HashMap;
import java.util.List;
import org.eclipse.viatra.query.runtime.base.itc.alg.dred.DRedTcRelation;
import org.eclipse.viatra.query.runtime.base.itc.igraph.IGraphDataSource;
import org.eclipse.viatra.query.runtime.base.itc.igraph.IGraphObserver;

public class DFSAlg<V>
implements IGraphObserver<V> {
    private static final long serialVersionUID = 7397186805581323071L;
    private IGraphDataSource<V> gds;
    private DRedTcRelation<V> tc;
    private int[] visited;
    private HashMap<V, Integer> nodeMap;

    public DFSAlg(IGraphDataSource<V> gds) {
        this.gds = gds;
        this.tc = new DRedTcRelation();
        gds.attachObserver(this);
        this.deriveTc();
    }

    private void deriveTc() {
        this.tc.clear();
        this.visited = new int[this.gds.getAllNodes().size()];
        this.nodeMap = new HashMap();
        int j = 0;
        for (V n : this.gds.getAllNodes()) {
            this.nodeMap.put((Integer)n, j);
            ++j;
        }
        for (V n : this.gds.getAllNodes()) {
            this.oneDFS(n, n);
            this.initVisitedArray();
        }
    }

    private void initVisitedArray() {
        int i = 0;
        while (i < this.visited.length) {
            this.visited[i] = 0;
            ++i;
        }
    }

    private void oneDFS(V act, V source) {
        if (!act.equals(source)) {
            this.tc.addTuple(source, act);
        }
        this.visited[this.nodeMap.get(act).intValue()] = 1;
        List<V> targets = this.gds.getTargetNodes(act);
        if (targets != null) {
            for (V t : targets) {
                if (this.visited[this.nodeMap.get(t)] != 0) continue;
                this.oneDFS(t, source);
            }
        }
    }

    public DRedTcRelation<V> getTcRelation() {
        return this.tc;
    }

    @Override
    public void edgeInserted(V source, V target) {
        this.deriveTc();
    }

    @Override
    public void edgeDeleted(V source, V target) {
        this.deriveTc();
    }

    @Override
    public void nodeInserted(V n) {
        this.deriveTc();
    }

    @Override
    public void nodeDeleted(V n) {
        this.deriveTc();
    }
}

