/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.query.runtime.base.itc.alg.misc.scc;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.Stack;
import org.eclipse.viatra.query.runtime.base.itc.alg.misc.scc.SCCProperty;
import org.eclipse.viatra.query.runtime.base.itc.alg.misc.scc.SCCResult;
import org.eclipse.viatra.query.runtime.base.itc.igraph.IGraphDataSource;

public class SCC<V> {
    public static long sccId = 0L;

    public static <V> SCCResult<V> computeSCC(IGraphDataSource<V> g) {
        int index = 0;
        HashSet ret = new HashSet();
        HashMap<V, SCCProperty> nodeMap = new HashMap<V, SCCProperty>();
        HashMap targetNodeMap = new HashMap();
        HashMap notVisitedMap = new HashMap();
        Stack<Object> nodeStack = new Stack<Object>();
        Stack sccStack = new Stack();
        boolean sink = false;
        boolean finishedTraversal = true;
        Set<V> allNodes = g.getAllNodes();
        for (V n : allNodes) {
            nodeMap.put(n, new SCCProperty(0, 0));
        }
        for (V n : allNodes) {
            if (((SCCProperty)nodeMap.get(n)).getIndex() != 0) continue;
            nodeStack.push(n);
            while (!nodeStack.isEmpty()) {
                Object targetNode2;
                Object currentNode = nodeStack.peek();
                sink = false;
                finishedTraversal = false;
                SCCProperty prop = (SCCProperty)nodeMap.get(currentNode);
                if (((SCCProperty)nodeMap.get(currentNode)).getIndex() == 0) {
                    sccStack.push(currentNode);
                    prop.setIndex(++index);
                    prop.setLowlink(index);
                    notVisitedMap.put(currentNode, new HashSet());
                    if (g.getTargetNodes(currentNode) != null) {
                        targetNodeMap.put(currentNode, new ArrayList<V>(g.getTargetNodes(currentNode)));
                    }
                }
                if (targetNodeMap.get(currentNode) != null) {
                    if (((List)targetNodeMap.get(currentNode)).size() == 0) {
                        targetNodeMap.remove(currentNode);
                        nodeStack.pop();
                        List<V> targets = g.getTargetNodes(currentNode);
                        if (targets != null) {
                            for (Object targetNode2 : g.getTargetNodes(currentNode)) {
                                if (((Set)notVisitedMap.get(currentNode)).contains(targetNode2)) {
                                    prop.setLowlink(Math.min(prop.getLowlink(), ((SCCProperty)nodeMap.get(targetNode2)).getLowlink()));
                                    continue;
                                }
                                if (!sccStack.contains(targetNode2)) continue;
                                prop.setLowlink(Math.min(prop.getLowlink(), ((SCCProperty)nodeMap.get(targetNode2)).getIndex()));
                            }
                        }
                        finishedTraversal = true;
                    } else {
                        Object targetNode3 = ((List)targetNodeMap.get(currentNode)).remove(0);
                        if (((SCCProperty)nodeMap.get(targetNode3)).getIndex() == 0) {
                            ((Set)notVisitedMap.get(currentNode)).add(targetNode3);
                            nodeStack.add(targetNode3);
                        }
                    }
                } else {
                    nodeStack.pop();
                    sink = true;
                }
                if (!sink && !finishedTraversal || prop.getLowlink() != prop.getIndex()) continue;
                HashSet<Object> sc = new HashSet<Object>();
                targetNode2 = null;
                do {
                    targetNode2 = sccStack.pop();
                    sc.add(targetNode2);
                } while (!targetNode2.equals(currentNode));
                ret.add(sc);
            }
        }
        return new SCCResult(ret, g);
    }
}

