/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.query.runtime.base.api;

import com.google.common.base.Objects;
import org.eclipse.viatra.query.runtime.base.api.IndexingLevel;
import org.eclipse.viatra.query.runtime.base.api.filters.IBaseIndexObjectFilter;
import org.eclipse.viatra.query.runtime.base.api.filters.IBaseIndexResourceFilter;

public class BaseIndexOptions {
    protected static final IndexingLevel WILDCARD_MODE_DEFAULT = IndexingLevel.NONE;
    private static final boolean TRAVERS_ONLY_WELLBEHAVING_DERIVED_FEATURES_DEFAULT = true;
    protected static final boolean DYNAMIC_EMF_MODE_DEFAULT = false;
    protected boolean dynamicEMFMode = false;
    protected boolean traverseOnlyWellBehavingDerivedFeatures = true;
    protected IndexingLevel wildcardMode = WILDCARD_MODE_DEFAULT;
    protected IBaseIndexObjectFilter notifierFilterConfiguration;
    protected IBaseIndexResourceFilter resourceFilterConfiguration;

    public BaseIndexOptions() {
    }

    @Deprecated
    public BaseIndexOptions(boolean dynamicEMFMode, boolean wildcardMode) {
        this.dynamicEMFMode = dynamicEMFMode;
        this.wildcardMode = wildcardMode ? IndexingLevel.FULL : IndexingLevel.NONE;
    }

    public BaseIndexOptions(boolean dynamicEMFMode, IndexingLevel wildcardMode) {
        this.dynamicEMFMode = dynamicEMFMode;
        this.wildcardMode = wildcardMode;
    }

    public BaseIndexOptions withDynamicEMFMode(boolean dynamicEMFMode) {
        BaseIndexOptions result = this.copy();
        result.dynamicEMFMode = dynamicEMFMode;
        return result;
    }

    public BaseIndexOptions withObjectFilterConfiguration(IBaseIndexObjectFilter filter) {
        BaseIndexOptions result = this.copy();
        result.notifierFilterConfiguration = filter;
        return result;
    }

    public IBaseIndexObjectFilter getObjectFilterConfiguration() {
        return this.notifierFilterConfiguration;
    }

    public BaseIndexOptions withResourceFilterConfiguration(IBaseIndexResourceFilter filter) {
        BaseIndexOptions result = this.copy();
        result.resourceFilterConfiguration = filter;
        return result;
    }

    public IBaseIndexResourceFilter getResourceFilterConfiguration() {
        return this.resourceFilterConfiguration;
    }

    public boolean isDynamicEMFMode() {
        return this.dynamicEMFMode;
    }

    public boolean isTraverseOnlyWellBehavingDerivedFeatures() {
        return this.traverseOnlyWellBehavingDerivedFeatures;
    }

    public BaseIndexOptions withWildcardMode(boolean wildcardMode) {
        BaseIndexOptions result = this.copy();
        result.wildcardMode = wildcardMode ? IndexingLevel.FULL : IndexingLevel.NONE;
        return result;
    }

    public BaseIndexOptions withWildcardLevel(IndexingLevel wildcardLevel) {
        BaseIndexOptions result = this.copy();
        result.wildcardMode = wildcardLevel;
        return result;
    }

    public boolean isWildcardMode() {
        return this.wildcardMode == IndexingLevel.FULL;
    }

    public IndexingLevel getWildcardLevel() {
        return this.wildcardMode;
    }

    public BaseIndexOptions copy() {
        BaseIndexOptions baseIndexOptions = new BaseIndexOptions(this.dynamicEMFMode, this.wildcardMode);
        baseIndexOptions.traverseOnlyWellBehavingDerivedFeatures = this.traverseOnlyWellBehavingDerivedFeatures;
        baseIndexOptions.notifierFilterConfiguration = this.notifierFilterConfiguration;
        baseIndexOptions.resourceFilterConfiguration = this.resourceFilterConfiguration;
        return baseIndexOptions;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.dynamicEMFMode ? 1231 : 1237);
        result = 31 * result + (this.notifierFilterConfiguration == null ? 0 : this.notifierFilterConfiguration.hashCode());
        result = 31 * result + (this.resourceFilterConfiguration == null ? 0 : this.resourceFilterConfiguration.hashCode());
        result = 31 * result + (this.traverseOnlyWellBehavingDerivedFeatures ? 1231 : 1237);
        result = 31 * result + (1231 + this.wildcardMode.ordinal() * 6);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BaseIndexOptions)) {
            return false;
        }
        BaseIndexOptions other = (BaseIndexOptions)obj;
        if (this.dynamicEMFMode != other.dynamicEMFMode) {
            return false;
        }
        if (this.notifierFilterConfiguration == null ? other.notifierFilterConfiguration != null : !this.notifierFilterConfiguration.equals(other.notifierFilterConfiguration)) {
            return false;
        }
        if (this.resourceFilterConfiguration == null ? other.resourceFilterConfiguration != null : !this.resourceFilterConfiguration.equals(other.resourceFilterConfiguration)) {
            return false;
        }
        if (this.traverseOnlyWellBehavingDerivedFeatures != other.traverseOnlyWellBehavingDerivedFeatures) {
            return false;
        }
        return this.wildcardMode == other.wildcardMode;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        BaseIndexOptions.appendModifier(sb, this.dynamicEMFMode, false, "dynamicEMF");
        BaseIndexOptions.appendModifier(sb, (Object)this.wildcardMode, (Object)WILDCARD_MODE_DEFAULT, "wildcard");
        BaseIndexOptions.appendModifier(sb, this.traverseOnlyWellBehavingDerivedFeatures, true, "wellBehavingOnly");
        BaseIndexOptions.appendModifier(sb, this.notifierFilterConfiguration, null, "notifierFilter=");
        BaseIndexOptions.appendModifier(sb, this.resourceFilterConfiguration, null, "resourceFilter=");
        String result = sb.toString();
        return result.isEmpty() ? "defaults" : result;
    }

    private static void appendModifier(StringBuilder sb, Object actualValue, Object expectedValue, String switchName) {
        if (!Objects.equal((Object)expectedValue, (Object)actualValue)) {
            sb.append(Boolean.FALSE.equals(actualValue) ? (char)'-' : '+');
            sb.append(switchName);
            if (!(actualValue instanceof Boolean)) {
                sb.append(actualValue);
            }
        }
    }
}

