/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.query.runtime.base.core;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.HashMultiset;
import com.google.common.collect.Multiset;
import com.google.common.collect.Sets;
import com.google.common.collect.Table;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.viatra.query.runtime.base.core.NavigationHelperImpl;

public class EMFBaseIndexInstanceStore {
    private NavigationHelperImpl navigationHelper;
    boolean isDirty = false;
    private final Table<Object, Object, Collection<EObject>> valueToFeatureToHolderMap = HashBasedTable.create();
    private Map<Object, Multiset<EObject>> featureToHolderMap;
    private Table<EObject, Object, Set<Object>> holderToFeatureToValueMap;
    private final Map<Object, Set<EObject>> instanceMap = new HashMap<Object, Set<EObject>>();
    private final Map<Object, Map<Object, Integer>> dataTypeMap = new HashMap<Object, Map<Object, Integer>>();

    public EMFBaseIndexInstanceStore(NavigationHelperImpl navigationHelper) {
        this.navigationHelper = navigationHelper;
    }

    protected Table<Object, Object, Collection<EObject>> getValueToFeatureToHolderMap() {
        return this.valueToFeatureToHolderMap;
    }

    private boolean addToFeatureMap(Object featureKey, boolean unique, Object value, EObject holder) {
        Collection setVal = (Collection)this.valueToFeatureToHolderMap.get(value, featureKey);
        if (setVal == null) {
            setVal = unique ? new HashSet() : HashMultiset.create();
            this.valueToFeatureToHolderMap.put(value, featureKey, (Object)setVal);
        }
        boolean changed = unique || !setVal.contains(holder);
        setVal.add(holder);
        return changed;
    }

    private void addToReversedFeatureMap(Object feature, EObject holder) {
        HashMultiset setVal = this.featureToHolderMap.get(feature);
        if (setVal == null) {
            setVal = HashMultiset.create();
            this.featureToHolderMap.put(feature, (Multiset<EObject>)setVal);
        }
        setVal.add((Object)holder);
    }

    private void addToDirectFeatureMap(EObject holder, Object feature, Object value) {
        HashSet<Object> setVal = (HashSet<Object>)this.holderToFeatureToValueMap.get((Object)holder, feature);
        if (setVal == null) {
            setVal = new HashSet<Object>();
            this.holderToFeatureToValueMap.put((Object)holder, feature, setVal);
        }
        setVal.add(value);
    }

    private void removeFromReversedFeatureMap(Object feature, EObject holder) {
        Multiset<EObject> setVal = this.featureToHolderMap.get(feature);
        if (setVal != null) {
            setVal.remove((Object)holder);
            if (setVal.isEmpty()) {
                this.featureToHolderMap.remove(feature);
            }
        }
    }

    private boolean removeFromFeatureMap(Object featureKey, boolean unique, Object value, EObject holder) {
        Collection setHolder = (Collection)this.valueToFeatureToHolderMap.get(value, featureKey);
        if (setHolder != null) {
            setHolder.remove(holder);
            if (setHolder.isEmpty()) {
                this.valueToFeatureToHolderMap.remove(value, featureKey);
            }
            return unique || !setHolder.contains(holder);
        }
        return false;
    }

    private void removeFromDirectFeatureMap(EObject holder, Object feature, Object value) {
        Set setVal = (Set)this.holderToFeatureToValueMap.get((Object)holder, feature);
        if (setVal != null) {
            setVal.remove(value);
            if (setVal.isEmpty()) {
                this.holderToFeatureToValueMap.remove((Object)holder, feature);
            }
        }
    }

    public void insertFeatureTuple(Object featureKey, boolean unique, Object value, EObject holder) {
        boolean changed = this.addToFeatureMap(featureKey, unique, value, holder);
        if (changed) {
            if (this.featureToHolderMap != null) {
                this.addToReversedFeatureMap(featureKey, holder);
            }
            if (this.holderToFeatureToValueMap != null) {
                this.addToDirectFeatureMap(holder, featureKey, value);
            }
            this.isDirty = true;
            this.navigationHelper.notifyFeatureListeners(holder, featureKey, value, true);
        }
    }

    public void removeFeatureTuple(Object featureKey, boolean unique, Object value, EObject holder) {
        boolean changed = this.removeFromFeatureMap(featureKey, unique, value, holder);
        if (changed) {
            if (this.featureToHolderMap != null) {
                this.removeFromReversedFeatureMap(featureKey, holder);
            }
            if (this.holderToFeatureToValueMap != null) {
                this.removeFromDirectFeatureMap(holder, featureKey, value);
            }
            this.isDirty = true;
            this.navigationHelper.notifyFeatureListeners(holder, featureKey, value, false);
        }
    }

    public Set<EObject> getInstanceSet(Object keyClass) {
        return this.instanceMap.get(keyClass);
    }

    public void removeInstanceSet(Object keyClass) {
        this.instanceMap.remove(keyClass);
    }

    public void insertIntoInstanceSet(Object keyClass, EObject value) {
        Set<EObject> set = this.instanceMap.get(keyClass);
        if (set == null) {
            set = new HashSet<EObject>();
            this.instanceMap.put(keyClass, set);
        }
        set.add(value);
        this.isDirty = true;
        this.navigationHelper.notifyInstanceListeners(keyClass, value, true);
    }

    public void removeFromInstanceSet(Object keyClass, EObject value) {
        Set<EObject> set = this.instanceMap.get(keyClass);
        if (set != null) {
            set.remove(value);
            if (set.isEmpty()) {
                this.instanceMap.remove(keyClass);
            }
        }
        this.isDirty = true;
        this.navigationHelper.notifyInstanceListeners(keyClass, value, false);
    }

    public Map<Object, Integer> getDataTypeMap(Object keyType) {
        return this.dataTypeMap.get(keyType);
    }

    public void removeDataTypeMap(Object keyType) {
        this.dataTypeMap.remove(keyType);
    }

    public void insertIntoDataTypeMap(Object keyType, Object value) {
        boolean firstOccurrence;
        Map<Object, Integer> valMap = this.dataTypeMap.get(keyType);
        if (valMap == null) {
            valMap = new HashMap<Object, Integer>();
            this.dataTypeMap.put(keyType, valMap);
        }
        boolean bl = firstOccurrence = valMap.get(value) == null;
        if (firstOccurrence) {
            valMap.put(value, 1);
        } else {
            Integer count = valMap.get(value);
            count = count + 1;
            valMap.put(value, count);
        }
        this.isDirty = true;
        this.navigationHelper.notifyDataTypeListeners(keyType, value, true, firstOccurrence);
    }

    public void removeFromDataTypeMap(Object keyType, Object value) {
        Map<Object, Integer> valMap = this.dataTypeMap.get(keyType);
        if (valMap != null && valMap.get(value) != null) {
            boolean lastOccurrence;
            Integer count = valMap.get(value);
            boolean bl = lastOccurrence = (count = Integer.valueOf(count - 1)) == 0;
            if (lastOccurrence) {
                valMap.remove(value);
                if (valMap.size() == 0) {
                    this.dataTypeMap.remove(keyType);
                }
            } else {
                valMap.put(value, count);
            }
            this.isDirty = true;
            this.navigationHelper.notifyDataTypeListeners(keyType, value, false, lastOccurrence);
        }
    }

    protected static Set<EObject> holderCollectionToUniqueSet(Collection<EObject> holders) {
        if (holders instanceof Set) {
            return (Set)holders;
        }
        if (holders instanceof Multiset) {
            Multiset multiSet = (Multiset)holders;
            return multiSet.elementSet();
        }
        throw new IllegalStateException("Neither Set nor Multiset: " + holders);
    }

    protected Map<Object, Multiset<EObject>> getFeatureToHolderMap() {
        if (this.featureToHolderMap == null) {
            this.featureToHolderMap = new HashMap<Object, Multiset<EObject>>();
            this.initReversedFeatureMap();
        }
        return this.featureToHolderMap;
    }

    protected Map<Object, Multiset<EObject>> peekFeatureToHolderMap() {
        return this.featureToHolderMap;
    }

    protected Table<EObject, Object, Set<Object>> getHolderToFeatureToValueMap() {
        if (this.holderToFeatureToValueMap == null) {
            this.holderToFeatureToValueMap = HashBasedTable.create();
            this.initDirectFeatureMap();
        }
        return this.holderToFeatureToValueMap;
    }

    protected Table<EObject, Object, Set<Object>> peekHolderToFeatureToValueMap() {
        return this.holderToFeatureToValueMap;
    }

    private void initReversedFeatureMap() {
        for (Table.Cell entry : this.valueToFeatureToHolderMap.cellSet()) {
            Object feature = entry.getColumnKey();
            for (EObject holder : EMFBaseIndexInstanceStore.holderCollectionToUniqueSet((Collection)entry.getValue())) {
                this.addToReversedFeatureMap(feature, holder);
            }
        }
    }

    private void initDirectFeatureMap() {
        for (Table.Cell entry : this.valueToFeatureToHolderMap.cellSet()) {
            Object value = entry.getRowKey();
            Object feature = entry.getColumnKey();
            for (EObject holder : EMFBaseIndexInstanceStore.holderCollectionToUniqueSet((Collection)entry.getValue())) {
                this.addToDirectFeatureMap(holder, feature, value);
            }
        }
    }

    public Set<EClass> getAllCurrentClasses() {
        HashSet result = Sets.newHashSet();
        Set<Object> classifierKeys = this.instanceMap.keySet();
        for (Object classifierKey : classifierKeys) {
            EClassifier knownClassifier = this.navigationHelper.metaStore.getKnownClassifierForKey(classifierKey);
            if (!(knownClassifier instanceof EClass)) continue;
            result.add((EClass)knownClassifier);
        }
        return result;
    }

    Set<Object> getOldValuesForHolderAndFeature(EObject source, EStructuralFeature feature) {
        Map oldValuesToHolders = this.valueToFeatureToHolderMap.column((Object)feature);
        HashSet<Object> oldValues = new HashSet<Object>();
        for (Map.Entry entry : oldValuesToHolders.entrySet()) {
            if (!((Collection)entry.getValue()).contains(source)) continue;
            oldValues.add(entry.getKey());
        }
        return oldValues;
    }
}

