/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.query.runtime.base.core;

import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.concurrent.Callable;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.viatra.query.runtime.base.api.BaseIndexOptions;
import org.eclipse.viatra.query.runtime.base.api.filters.IBaseIndexObjectFilter;
import org.eclipse.viatra.query.runtime.base.api.filters.IBaseIndexResourceFilter;
import org.eclipse.viatra.query.runtime.base.comprehension.EMFModelComprehension;
import org.eclipse.viatra.query.runtime.base.comprehension.EMFVisitor;
import org.eclipse.viatra.query.runtime.base.core.NavigationHelperImpl;
import org.eclipse.viatra.query.runtime.base.core.NavigationHelperVisitor;

public class NavigationHelperContentAdapter
extends AdapterImpl {
    private final NavigationHelperImpl navigationHelper;
    protected EObject ignoreInsertionAndDeletion;
    private final EMFModelComprehension comprehension;
    private IBaseIndexObjectFilter objectFilterConfiguration;
    private IBaseIndexResourceFilter resourceFilterConfiguration;
    private EMFVisitor removalVisitor;
    private EMFVisitor insertionVisitor;

    public NavigationHelperContentAdapter(NavigationHelperImpl navigationHelper) {
        this.navigationHelper = navigationHelper;
        BaseIndexOptions options = this.navigationHelper.getBaseIndexOptions();
        this.objectFilterConfiguration = options.getObjectFilterConfiguration();
        this.resourceFilterConfiguration = options.getResourceFilterConfiguration();
        this.comprehension = navigationHelper.getComprehension();
        this.removalVisitor = new NavigationHelperVisitor.ChangeVisitor(navigationHelper, false);
        this.insertionVisitor = new NavigationHelperVisitor.ChangeVisitor(navigationHelper, true);
    }

    public void notifyChanged(final Notification notification) {
        try {
            this.navigationHelper.coalesceTraversals(new Callable<Void>(){

                @Override
                public Void call() throws Exception {
                    NavigationHelperContentAdapter.this.simpleNotifyChanged(notification);
                    Object oFeature = notification.getFeature();
                    Object oNotifier = notification.getNotifier();
                    if (oNotifier instanceof EObject && oFeature instanceof EStructuralFeature) {
                        EObject notifier = (EObject)oNotifier;
                        EStructuralFeature feature = (EStructuralFeature)oFeature;
                        boolean notifyLightweightObservers = NavigationHelperContentAdapter.this.handleNotification(notification, notifier, feature);
                        if (notifyLightweightObservers) {
                            NavigationHelperContentAdapter.this.navigationHelper.notifyLightweightObservers(notifier, feature, notification);
                        }
                    } else if (oNotifier instanceof Resource && notification.getFeatureID(Resource.class) == 4) {
                        Resource resource = (Resource)oNotifier;
                        if (NavigationHelperContentAdapter.this.comprehension.isLoading(resource)) {
                            ((NavigationHelperContentAdapter)NavigationHelperContentAdapter.this).navigationHelper.resolutionDelayingResources.add(resource);
                        } else {
                            ((NavigationHelperContentAdapter)NavigationHelperContentAdapter.this).navigationHelper.resolutionDelayingResources.remove(resource);
                        }
                    }
                    return null;
                }
            });
        }
        catch (InvocationTargetException ex) {
            this.navigationHelper.processingFatal(ex.getCause(), "handling the following update notification: " + notification);
        }
        catch (Exception ex) {
            this.navigationHelper.processingFatal(ex, "handling the following update notification: " + notification);
        }
        this.navigationHelper.notifyBaseIndexChangeListeners();
    }

    private boolean handleNotification(Notification notification, EObject notifier, EStructuralFeature feature) {
        Object oldValue = notification.getOldValue();
        Object newValue = notification.getNewValue();
        int positionInt = notification.getPosition();
        Integer position = positionInt == -1 ? null : Integer.valueOf(positionInt);
        int eventType = notification.getEventType();
        boolean notifyLightweightObservers = true;
        switch (eventType) {
            case 3: {
                this.featureUpdate(true, notifier, feature, newValue, position);
                break;
            }
            case 5: {
                for (Object newElement : (Collection)newValue) {
                    this.featureUpdate(true, notifier, feature, newElement, position);
                }
                break;
            }
            case 0: {
                notifyLightweightObservers = false;
                break;
            }
            case 7: {
                break;
            }
            case 4: {
                this.featureUpdate(false, notifier, feature, oldValue, position);
                break;
            }
            case 6: {
                for (Object oldElement : (Collection)oldValue) {
                    this.featureUpdate(false, notifier, feature, oldElement, position);
                }
                break;
            }
            case 8: {
                notifyLightweightObservers = false;
                break;
            }
            case 9: {
                if (this.navigationHelper.isFeatureResolveIgnored(feature)) break;
                if (!feature.isMany()) {
                    this.navigationHelper.delayedProxyResolutions.remove((Object)notifier, (Object)feature);
                }
            }
            case 1: 
            case 2: {
                this.featureUpdate(false, notifier, feature, oldValue, position);
                this.featureUpdate(true, notifier, feature, newValue, position);
                break;
            }
            default: {
                notifyLightweightObservers = false;
            }
        }
        return notifyLightweightObservers;
    }

    private void featureUpdate(boolean isInsertion, EObject notifier, EStructuralFeature feature, Object value, Integer position) {
        this.comprehension.traverseFeature(this.getVisitorForChange(isInsertion), notifier, feature, value, position);
    }

    protected void addAdapter(final Notifier notifier) {
        if (notifier == this.ignoreInsertionAndDeletion) {
            return;
        }
        try {
            if (notifier.eAdapters().contains((Object)this)) {
                return;
            }
            if (this.objectFilterConfiguration != null && this.objectFilterConfiguration.isFiltered(notifier)) {
                return;
            }
            this.navigationHelper.coalesceTraversals(new Callable<Void>(){

                @Override
                public Void call() throws Exception {
                    if (notifier instanceof EObject) {
                        NavigationHelperContentAdapter.this.comprehension.traverseObject(NavigationHelperContentAdapter.this.getVisitorForChange(true), (EObject)notifier);
                    } else if (notifier instanceof Resource) {
                        Resource resource = (Resource)notifier;
                        if (NavigationHelperContentAdapter.this.resourceFilterConfiguration != null && NavigationHelperContentAdapter.this.resourceFilterConfiguration.isResourceFiltered(resource)) {
                            return null;
                        }
                        if (NavigationHelperContentAdapter.this.comprehension.isLoading(resource)) {
                            ((NavigationHelperContentAdapter)NavigationHelperContentAdapter.this).navigationHelper.resolutionDelayingResources.add(resource);
                        }
                    }
                    NavigationHelperContentAdapter.this.simpleAddAdapter(notifier);
                    return null;
                }
            });
        }
        catch (InvocationTargetException ex) {
            this.navigationHelper.processingFatal(ex.getCause(), "add the object: " + notifier);
        }
        catch (Exception ex) {
            this.navigationHelper.processingFatal(ex, "add the object: " + notifier);
        }
    }

    protected void removeAdapter(Notifier notifier) {
        if (notifier == this.ignoreInsertionAndDeletion) {
            return;
        }
        try {
            this.removeAdapterInternal(notifier);
        }
        catch (InvocationTargetException ex) {
            this.navigationHelper.processingFatal(ex.getCause(), "remove the object: " + notifier);
        }
        catch (Exception ex) {
            this.navigationHelper.processingFatal(ex, "remove the object: " + notifier);
        }
    }

    void removeAdapter(Notifier notifier, boolean additionalObjectContainerPossible, boolean additionalResourceContainerPossible) {
        if (notifier == this.ignoreInsertionAndDeletion) {
            return;
        }
        try {
            if (notifier instanceof InternalEObject) {
                InternalEObject eInternalContainer;
                Resource.Internal eDirectResource;
                InternalEObject internalEObject = (InternalEObject)notifier;
                if (additionalResourceContainerPossible && (eDirectResource = internalEObject.eDirectResource()) != null && eDirectResource.eAdapters().contains((Object)this)) {
                    return;
                }
                if (additionalObjectContainerPossible && (eInternalContainer = internalEObject.eInternalContainer()) != null && eInternalContainer.eAdapters().contains((Object)this)) {
                    return;
                }
            }
            this.removeAdapterInternal(notifier);
        }
        catch (InvocationTargetException ex) {
            this.navigationHelper.processingFatal(ex.getCause(), "remove the object: " + notifier);
        }
        catch (Exception ex) {
            this.navigationHelper.processingFatal(ex, "remove the object: " + notifier);
        }
    }

    private void removeAdapterInternal(final Notifier notifier) throws InvocationTargetException {
        if (this.objectFilterConfiguration != null && this.objectFilterConfiguration.isFiltered(notifier)) {
            return;
        }
        this.navigationHelper.coalesceTraversals(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                if (notifier instanceof EObject) {
                    EObject eObject = (EObject)notifier;
                    NavigationHelperContentAdapter.this.comprehension.traverseObject(NavigationHelperContentAdapter.this.getVisitorForChange(false), eObject);
                    ((NavigationHelperContentAdapter)NavigationHelperContentAdapter.this).navigationHelper.delayedProxyResolutions.removeAll((Object)eObject);
                } else if (notifier instanceof Resource) {
                    if (NavigationHelperContentAdapter.this.resourceFilterConfiguration != null && NavigationHelperContentAdapter.this.resourceFilterConfiguration.isResourceFiltered((Resource)notifier)) {
                        return null;
                    }
                    ((NavigationHelperContentAdapter)NavigationHelperContentAdapter.this).navigationHelper.resolutionDelayingResources.remove(notifier);
                }
                NavigationHelperContentAdapter.this.simpleRemoveAdapter(notifier);
                return null;
            }
        });
    }

    protected EMFVisitor getVisitorForChange(boolean isInsertion) {
        return isInsertion ? this.insertionVisitor : this.removalVisitor;
    }

    protected void setTarget(EObject target) {
        this.basicSetTarget((Notifier)target);
        this.spreadToChildren(target, true);
    }

    protected void unsetTarget(EObject target) {
        this.basicUnsetTarget((Notifier)target);
        this.spreadToChildren(target, false);
    }

    protected void spreadToChildren(EObject target, boolean add) {
        EList features = target.eClass().getEAllReferences();
        for (EReference feature : features) {
            if (!feature.isContainment() || !this.comprehension.representable((EStructuralFeature)feature)) continue;
            if (feature.isMany()) {
                Collection values = (Collection)target.eGet((EStructuralFeature)feature);
                for (Object value : values) {
                    Notifier notifier = (Notifier)value;
                    if (add) {
                        this.addAdapter(notifier);
                        continue;
                    }
                    this.removeAdapter(notifier, false, true);
                }
                continue;
            }
            Object value = target.eGet((EStructuralFeature)feature);
            if (value == null) continue;
            Notifier notifier = (Notifier)value;
            if (add) {
                this.addAdapter(notifier);
                continue;
            }
            this.removeAdapter(notifier, false, true);
        }
    }

    public void simpleNotifyChanged(Notification notification) {
        this.selfAdapt(notification);
        super.notifyChanged(notification);
    }

    protected void simpleAddAdapter(Notifier notifier) {
        EList eAdapters = notifier.eAdapters();
        if (!eAdapters.contains((Object)this)) {
            eAdapters.add((Object)this);
        }
    }

    protected void simpleRemoveAdapter(Notifier notifier) {
        notifier.eAdapters().remove((Object)this);
    }

    protected void selfAdapt(Notification notification) {
        EReference eReference;
        Object feature;
        Object notifier = notification.getNotifier();
        if (notifier instanceof ResourceSet) {
            if (notification.getFeatureID(ResourceSet.class) == 0) {
                this.handleContainment(notification);
            }
        } else if (notifier instanceof Resource) {
            if (notification.getFeatureID(Resource.class) == 2) {
                this.handleContainment(notification);
            }
        } else if (notifier instanceof EObject && (feature = notification.getFeature()) instanceof EReference && (eReference = (EReference)feature).isContainment()) {
            this.handleContainment(notification);
        }
    }

    protected void handleContainment(Notification notification) {
        switch (notification.getEventType()) {
            case 9: {
                Notifier oldValue = (Notifier)notification.getOldValue();
                if (!oldValue.eAdapters().contains((Object)this)) break;
                this.removeAdapter(oldValue);
                Notifier newValue = (Notifier)notification.getNewValue();
                this.addAdapter(newValue);
                break;
            }
            case 2: {
                Notifier newValue;
                Object oldValue = notification.getOldValue();
                if (oldValue == Boolean.TRUE || oldValue == Boolean.FALSE) break;
                if (oldValue != null) {
                    this.removeAdapter((Notifier)oldValue, false, true);
                }
                if ((newValue = (Notifier)notification.getNewValue()) == null) break;
                this.addAdapter(newValue);
                break;
            }
            case 1: {
                Notifier newValue;
                Notifier oldValue = (Notifier)notification.getOldValue();
                if (oldValue != null) {
                    this.removeAdapter(oldValue, false, true);
                }
                if ((newValue = (Notifier)notification.getNewValue()) == null) break;
                this.addAdapter(newValue);
                break;
            }
            case 3: {
                Notifier newValue = (Notifier)notification.getNewValue();
                if (newValue == null) break;
                this.addAdapter(newValue);
                break;
            }
            case 5: {
                Collection newValues = (Collection)notification.getNewValue();
                for (Notifier newValue : newValues) {
                    this.addAdapter(newValue);
                }
                break;
            }
            case 4: {
                Notifier oldValue = (Notifier)notification.getOldValue();
                if (oldValue == null) break;
                boolean checkContainer = notification.getNotifier() instanceof Resource;
                boolean checkResource = notification.getFeature() != null;
                this.removeAdapter(oldValue, checkContainer, checkResource);
                break;
            }
            case 6: {
                boolean checkContainer = notification.getNotifier() instanceof Resource;
                boolean checkResource = notification.getFeature() != null;
                Collection oldValues = (Collection)notification.getOldValue();
                for (Notifier oldContentValue : oldValues) {
                    this.removeAdapter(oldContentValue, checkContainer, checkResource);
                }
                break;
            }
        }
    }

    public void setTarget(Notifier target) {
        if (target instanceof EObject) {
            this.setTarget((EObject)target);
        } else if (target instanceof Resource) {
            this.setTarget((Resource)target);
        } else if (target instanceof ResourceSet) {
            this.setTarget((ResourceSet)target);
        } else {
            this.basicSetTarget(target);
        }
    }

    protected void basicSetTarget(Notifier target) {
        super.setTarget(target);
    }

    protected void setTarget(Resource target) {
        this.basicSetTarget((Notifier)target);
        EList contents = target.getContents();
        int i = 0;
        int size = contents.size();
        while (i < size) {
            Notifier notifier = (Notifier)contents.get(i);
            this.addAdapter(notifier);
            ++i;
        }
    }

    protected void setTarget(ResourceSet target) {
        this.basicSetTarget((Notifier)target);
        EList resources = target.getResources();
        int i = 0;
        while (i < resources.size()) {
            Notifier notifier = (Notifier)resources.get(i);
            this.addAdapter(notifier);
            ++i;
        }
    }

    public void unsetTarget(Notifier target) {
        this.unsetTarget((Object)target);
    }

    protected void basicUnsetTarget(Notifier target) {
        super.unsetTarget(target);
    }

    @Deprecated
    protected void unsetTarget(Object target) {
        if (target instanceof EObject) {
            this.unsetTarget((EObject)target);
        } else if (target instanceof Resource) {
            this.unsetTarget((Resource)target);
        } else if (target instanceof ResourceSet) {
            this.unsetTarget((ResourceSet)target);
        } else {
            this.basicUnsetTarget((Notifier)target);
        }
    }

    protected void unsetTarget(Resource target) {
        this.basicUnsetTarget((Notifier)target);
        EList contents = target.getContents();
        int i = 0;
        int size = contents.size();
        while (i < size) {
            Notifier notifier = (Notifier)contents.get(i);
            this.removeAdapter(notifier, true, false);
            ++i;
        }
    }

    protected void unsetTarget(ResourceSet target) {
        this.basicUnsetTarget((Notifier)target);
        EList resources = target.getResources();
        int i = 0;
        while (i < resources.size()) {
            Notifier notifier = (Notifier)resources.get(i);
            this.removeAdapter(notifier, false, false);
            ++i;
        }
    }

    protected boolean resolve() {
        return true;
    }
}

