/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.query.runtime.matchers.planning.helpers;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.viatra.query.runtime.matchers.context.IInputKey;
import org.eclipse.viatra.query.runtime.matchers.context.IQueryMetaContext;
import org.eclipse.viatra.query.runtime.matchers.psystem.ITypeInfoProviderConstraint;
import org.eclipse.viatra.query.runtime.matchers.psystem.PConstraint;
import org.eclipse.viatra.query.runtime.matchers.psystem.PVariable;
import org.eclipse.viatra.query.runtime.matchers.psystem.TypeJudgement;

public class TypeHelper {
    public static Map<PVariable, Set<TypeJudgement>> inferUnaryTypes(Set<PConstraint> constraints, IQueryMetaContext context) {
        Set<TypeJudgement> equivalentJudgements = TypeHelper.getDirectJudgements(constraints, context);
        Set<TypeJudgement> impliedJudgements = TypeHelper.typeClosure(equivalentJudgements, context);
        HashMap<PVariable, Set<TypeJudgement>> results = new HashMap<PVariable, Set<TypeJudgement>>();
        for (TypeJudgement typeJudgement : impliedJudgements) {
            IInputKey inputKey = typeJudgement.getInputKey();
            if (inputKey.getArity() != 1) continue;
            PVariable variable = (PVariable)typeJudgement.getVariablesTuple().get(0);
            HashSet<TypeJudgement> inferredTypes = (HashSet<TypeJudgement>)results.get(variable);
            if (inferredTypes == null) {
                inferredTypes = new HashSet<TypeJudgement>();
                results.put(variable, inferredTypes);
            }
            inferredTypes.add(typeJudgement);
        }
        return results;
    }

    public static Set<TypeJudgement> getDirectJudgements(Set<PConstraint> constraints, IQueryMetaContext context) {
        HashSet<TypeJudgement> equivalentJudgements = new HashSet<TypeJudgement>();
        for (PConstraint pConstraint : constraints) {
            if (!(pConstraint instanceof ITypeInfoProviderConstraint)) continue;
            equivalentJudgements.addAll(((ITypeInfoProviderConstraint)pConstraint).getImpliedJudgements(context));
        }
        return equivalentJudgements;
    }

    public static Set<TypeJudgement> typeClosure(Set<TypeJudgement> typesToClose, IQueryMetaContext context) {
        HashSet<TypeJudgement> closure;
        HashSet<TypeJudgement> delta = closure = new HashSet<TypeJudgement>(typesToClose);
        while (!delta.isEmpty()) {
            HashSet<TypeJudgement> newTypes = new HashSet<TypeJudgement>();
            for (TypeJudgement deltaType : delta) {
                newTypes.addAll(deltaType.getDirectlyImpliedJudgements(context));
            }
            newTypes.removeAll(closure);
            delta = newTypes;
            closure.addAll(delta);
        }
        return closure;
    }

    public static Set<TypeJudgement> subsumeTypes(Set<TypeJudgement> subsumableTypes, Set<TypeJudgement> subsumingTypes, IQueryMetaContext context) {
        Set<TypeJudgement> closure = TypeHelper.typeClosure(subsumingTypes, context);
        HashSet<TypeJudgement> subsumed = new HashSet<TypeJudgement>(subsumableTypes);
        subsumed.removeAll(closure);
        return subsumed;
    }
}

