/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.query.runtime.matchers.psystem;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import org.eclipse.viatra.query.runtime.matchers.context.IQueryMetaContext;
import org.eclipse.viatra.query.runtime.matchers.planning.helpers.TypeHelper;
import org.eclipse.viatra.query.runtime.matchers.psystem.PConstraint;
import org.eclipse.viatra.query.runtime.matchers.psystem.PVariable;
import org.eclipse.viatra.query.runtime.matchers.psystem.TypeJudgement;
import org.eclipse.viatra.query.runtime.matchers.psystem.basicdeferred.ExportedParameter;
import org.eclipse.viatra.query.runtime.matchers.psystem.basicenumerables.ConstantValue;
import org.eclipse.viatra.query.runtime.matchers.psystem.queries.PDisjunction;
import org.eclipse.viatra.query.runtime.matchers.psystem.queries.PQuery;

public class PBody {
    public static final String VIRTUAL_VARIABLE_PREFIX = ".virtual";
    private static final String VIRTUAL_VARIABLE_PATTERN = ".virtual{%d}";
    private PQuery query;
    private PQuery.PQueryStatus status = PQuery.PQueryStatus.UNINITIALIZED;
    private Set<PVariable> allVariables;
    private Set<PVariable> uniqueVariables;
    private List<ExportedParameter> symbolicParameters;
    private Map<Object, PVariable> variablesByName;
    private Set<PConstraint> constraints;
    private int nextVirtualNodeID;
    private PDisjunction containerDisjunction;
    private WeakHashMap<IQueryMetaContext, Map<PVariable, Set<TypeJudgement>>> allUnaryTypeRestrictions = new WeakHashMap();

    public PBody(PQuery query) {
        this.query = query;
        this.allVariables = new LinkedHashSet<PVariable>();
        this.uniqueVariables = new LinkedHashSet<PVariable>();
        this.variablesByName = new HashMap<Object, PVariable>();
        this.constraints = new LinkedHashSet<PConstraint>();
    }

    private boolean addVariable(PVariable var) {
        this.checkMutability();
        String name = var.getName();
        if (!this.variablesByName.containsKey(name)) {
            this.allVariables.add(var);
            if (var.isUnique()) {
                this.uniqueVariables.add(var);
            }
            this.variablesByName.put(name, var);
            return true;
        }
        return false;
    }

    boolean registerConstraint(PConstraint constraint) {
        this.checkMutability();
        return this.constraints.add(constraint);
    }

    boolean unregisterConstraint(PConstraint constraint) {
        this.checkMutability();
        return this.constraints.remove(constraint);
    }

    public <ConstraintType> Set<ConstraintType> getConstraintsOfType(Class<ConstraintType> constraintClass) {
        HashSet<PConstraint> result = new HashSet<PConstraint>();
        for (PConstraint pConstraint : this.constraints) {
            if (!constraintClass.isInstance(pConstraint)) continue;
            result.add(pConstraint);
        }
        return result;
    }

    public PVariable newVirtualVariable() {
        String name;
        this.checkMutability();
        while (this.variablesByName.containsKey(name = String.format(VIRTUAL_VARIABLE_PATTERN, this.nextVirtualNodeID++))) {
        }
        PVariable var = new PVariable(this, name, true);
        this.addVariable(var);
        return var;
    }

    public PVariable newVirtualVariable(String name) {
        this.checkMutability();
        Preconditions.checkArgument((!this.variablesByName.containsKey(name) ? 1 : 0) != 0, (String)"ID %s already used for a virtual variable", (Object[])new Object[]{name});
        PVariable var = new PVariable(this, name, true);
        this.addVariable(var);
        return var;
    }

    public PVariable newConstantVariable(Object value) {
        this.checkMutability();
        PVariable virtual = this.newVirtualVariable();
        new ConstantValue(this, virtual, value);
        return virtual;
    }

    public Set<PVariable> getAllVariables() {
        return this.allVariables;
    }

    public Set<PVariable> getUniqueVariables() {
        return this.uniqueVariables;
    }

    private PVariable getVariableByName(Object name) {
        return this.variablesByName.get(name).getUnifiedIntoRoot();
    }

    public PVariable getVariableByNameChecked(Object name) throws IllegalArgumentException {
        if (!this.variablesByName.containsKey(name)) {
            throw new IllegalArgumentException(String.format("Cannot find PVariable %s", name));
        }
        return this.getVariableByName(name);
    }

    public PVariable getOrCreateVariableByName(String name) {
        this.checkMutability();
        if (!this.variablesByName.containsKey(name)) {
            this.addVariable(new PVariable(this, name, name.startsWith(VIRTUAL_VARIABLE_PREFIX)));
        }
        return this.getVariableByName(name);
    }

    public Set<PConstraint> getConstraints() {
        return this.constraints;
    }

    public PQuery getPattern() {
        return this.query;
    }

    void noLongerUnique(PVariable pVariable) {
        assert (!pVariable.isUnique());
        this.uniqueVariables.remove(pVariable);
    }

    public List<PVariable> getSymbolicParameterVariables() {
        return Lists.transform(this.getSymbolicParameters(), (Function)new Function<ExportedParameter, PVariable>(){

            public PVariable apply(ExportedParameter constraint) {
                return constraint.getParameterVariable();
            }
        });
    }

    public List<ExportedParameter> getSymbolicParameters() {
        if (this.symbolicParameters == null) {
            this.symbolicParameters = Lists.newArrayList();
        }
        return this.symbolicParameters;
    }

    public void setSymbolicParameters(List<ExportedParameter> symbolicParameters) {
        this.checkMutability();
        this.symbolicParameters = Lists.newArrayList(symbolicParameters);
    }

    public void setStatus(PQuery.PQueryStatus status) {
        this.status = status;
    }

    public boolean isMutable() {
        if (this.status == null) {
            return this.query.isMutable();
        }
        return this.status.equals((Object)PQuery.PQueryStatus.UNINITIALIZED);
    }

    void checkMutability() throws IllegalStateException {
        if (this.status == null) {
            this.query.checkMutability();
        } else {
            Preconditions.checkState((boolean)this.status.equals((Object)PQuery.PQueryStatus.UNINITIALIZED));
        }
    }

    public PDisjunction getContainerDisjunction() {
        return this.containerDisjunction;
    }

    public void setContainerDisjunction(PDisjunction containerDisjunction) {
        Preconditions.checkArgument((boolean)this.query.equals(containerDisjunction.getQuery()), (String)"Disjunction of pattern %s incompatible with body %s", (Object[])new Object[]{containerDisjunction.getQuery().getFullyQualifiedName(), this.query.getFullyQualifiedName()});
        Preconditions.checkState((this.containerDisjunction == null ? 1 : 0) != 0, (Object)"Disjunction is already set.");
        this.containerDisjunction = containerDisjunction;
    }

    public Map<PVariable, Set<TypeJudgement>> getAllUnaryTypeRestrictions(IQueryMetaContext context) {
        Map<PVariable, Set<TypeJudgement>> currentRestrictions = this.allUnaryTypeRestrictions.get(context);
        if (currentRestrictions == null) {
            currentRestrictions = TypeHelper.inferUnaryTypes(this.getConstraints(), context);
            this.allUnaryTypeRestrictions.put(context, currentRestrictions);
        }
        return currentRestrictions;
    }
}

