/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.query.runtime.matchers.psystem;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.viatra.query.runtime.matchers.context.IInputKey;
import org.eclipse.viatra.query.runtime.matchers.context.IQueryMetaContext;
import org.eclipse.viatra.query.runtime.matchers.context.InputKeyImplication;
import org.eclipse.viatra.query.runtime.matchers.tuple.FlatTuple;
import org.eclipse.viatra.query.runtime.matchers.tuple.Tuple;

public class TypeJudgement {
    private IInputKey inputKey;
    private Tuple variablesTuple;

    public TypeJudgement(IInputKey inputKey, Tuple variablesTuple) {
        this.inputKey = inputKey;
        this.variablesTuple = variablesTuple;
    }

    public IInputKey getInputKey() {
        return this.inputKey;
    }

    public Tuple getVariablesTuple() {
        return this.variablesTuple;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.inputKey == null ? 0 : this.inputKey.hashCode());
        result = 31 * result + (this.variablesTuple == null ? 0 : this.variablesTuple.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TypeJudgement)) {
            return false;
        }
        TypeJudgement other = (TypeJudgement)obj;
        if (this.inputKey == null ? other.inputKey != null : !this.inputKey.equals(other.inputKey)) {
            return false;
        }
        return !(this.variablesTuple == null ? other.variablesTuple != null : !this.variablesTuple.equals(other.variablesTuple));
    }

    public Set<TypeJudgement> getDirectlyImpliedJudgements(IQueryMetaContext context) {
        HashSet<TypeJudgement> results = new HashSet<TypeJudgement>();
        results.add(this);
        Collection<InputKeyImplication> implications = context.getImplications(this.inputKey);
        for (InputKeyImplication inputKeyImplication : implications) {
            results.add(new TypeJudgement(inputKeyImplication.getImpliedKey(), this.transcribeVariablesToTuple(inputKeyImplication.getImpliedIndices())));
        }
        return results;
    }

    private Tuple transcribeVariablesToTuple(List<Integer> indices) {
        Object[] elements = new Object[indices.size()];
        int i = 0;
        while (i < indices.size()) {
            elements[i] = this.variablesTuple.get(indices.get(i));
            ++i;
        }
        return new FlatTuple(elements);
    }

    public String toString() {
        return "TypeJudgement:" + this.inputKey.getPrettyPrintableName() + "@" + this.variablesTuple.toString();
    }
}

