/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.query.runtime.matchers.psystem.basicdeferred;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.viatra.query.runtime.matchers.context.IInputKey;
import org.eclipse.viatra.query.runtime.matchers.context.IQueryMetaContext;
import org.eclipse.viatra.query.runtime.matchers.psystem.ITypeInfoProviderConstraint;
import org.eclipse.viatra.query.runtime.matchers.psystem.PBody;
import org.eclipse.viatra.query.runtime.matchers.psystem.PVariable;
import org.eclipse.viatra.query.runtime.matchers.psystem.TypeJudgement;
import org.eclipse.viatra.query.runtime.matchers.psystem.aggregations.BoundAggregator;
import org.eclipse.viatra.query.runtime.matchers.psystem.basicdeferred.PatternCallBasedDeferred;
import org.eclipse.viatra.query.runtime.matchers.psystem.queries.PQuery;
import org.eclipse.viatra.query.runtime.matchers.tuple.FlatTuple;
import org.eclipse.viatra.query.runtime.matchers.tuple.Tuple;

public class AggregatorConstraint
extends PatternCallBasedDeferred
implements ITypeInfoProviderConstraint {
    protected PVariable resultVariable;
    private BoundAggregator aggregator;
    protected int aggregatedColumn;

    public AggregatorConstraint(BoundAggregator aggregator, PBody pBody, Tuple actualParametersTuple, PQuery query, PVariable resultVariable, int aggregatedColumn) {
        super(pBody, actualParametersTuple, query, Collections.singleton(resultVariable));
        this.resultVariable = resultVariable;
        this.aggregatedColumn = aggregatedColumn;
        this.aggregator = aggregator;
    }

    public int getAggregatedColumn() {
        return this.aggregatedColumn;
    }

    public BoundAggregator getAggregator() {
        return this.aggregator;
    }

    @Override
    public Set<PVariable> getDeducedVariables() {
        return Collections.singleton(this.resultVariable);
    }

    @Override
    public Map<Set<PVariable>, Set<PVariable>> getFunctionalDependencies(IQueryMetaContext context) {
        HashMap<Set<PVariable>, Set<PVariable>> result = new HashMap<Set<PVariable>, Set<PVariable>>();
        result.put(this.getDeferringVariables(), this.getDeducedVariables());
        return result;
    }

    @Override
    protected void doDoReplaceVariables(PVariable obsolete, PVariable replacement) {
        if (this.resultVariable.equals(obsolete)) {
            this.resultVariable = replacement;
        }
    }

    @Override
    protected Set<PVariable> getCandidateQuantifiedVariables() {
        return this.actualParametersTuple.getDistinctElements();
    }

    @Override
    protected String toStringRest() {
        return String.valueOf(this.query.getFullyQualifiedName()) + "@" + this.actualParametersTuple.toString() + "->" + this.resultVariable.toString();
    }

    public PVariable getResultVariable() {
        return this.resultVariable;
    }

    @Override
    public Set<TypeJudgement> getImpliedJudgements(IQueryMetaContext context) {
        IInputKey aggregateResultType = this.aggregator.getAggregateResultTypeAsInputKey();
        if (aggregateResultType != null) {
            return Collections.singleton(new TypeJudgement(aggregateResultType, new FlatTuple(this.resultVariable)));
        }
        return Collections.emptySet();
    }
}

