/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.query.runtime.rete.recipes.helper;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.viatra.query.runtime.rete.recipes.RecipesPackage;
import org.eclipse.viatra.query.runtime.rete.recipes.ReteNodeRecipe;

public class RecipeRecognizer {
    private static long nextRecipeEquivalenceClassID = 0L;
    Map<EClass, Set<ReteNodeRecipe>> canonicalRecipesByClass = Maps.newHashMap();
    Map<Long, ReteNodeRecipe> canonicalRecipeByEquivalenceClassID = Maps.newHashMap();

    public ReteNodeRecipe peekCanonicalRecipe(ReteNodeRecipe recipe) {
        for (Long classID : recipe.getEquivalenceClassIDs()) {
            ReteNodeRecipe knownRecipe = this.canonicalRecipeByEquivalenceClassID.get(classID);
            if (knownRecipe == null) continue;
            return knownRecipe;
        }
        Set<ReteNodeRecipe> sameClassRecipes = this.getSameClassCanonicalRecipes(recipe);
        for (ReteNodeRecipe knownRecipe : sameClassRecipes) {
            if (!this.isEquivalentRecipe(recipe, knownRecipe)) continue;
            recipe.getEquivalenceClassIDs().add((Object)((Long)knownRecipe.getEquivalenceClassIDs().get(0)));
            return knownRecipe;
        }
        return null;
    }

    public void makeCanonical(ReteNodeRecipe recipe) {
        if (recipe.getEquivalenceClassIDs().isEmpty()) {
            recipe.getEquivalenceClassIDs().add((Object)nextRecipeEquivalenceClassID++);
        }
        for (Long classID : recipe.getEquivalenceClassIDs()) {
            this.canonicalRecipeByEquivalenceClassID.put(classID, recipe);
        }
        this.getSameClassCanonicalRecipes(recipe).add(recipe);
    }

    public ReteNodeRecipe canonicalizeRecipe(ReteNodeRecipe recipe) {
        ReteNodeRecipe knownRecipe = this.peekCanonicalRecipe(recipe);
        if (knownRecipe == null) {
            knownRecipe = recipe;
            this.makeCanonical(recipe);
        }
        return knownRecipe;
    }

    public boolean isKnownCanonicalRecipe(ReteNodeRecipe recipe) {
        if (recipe.getEquivalenceClassIDs().isEmpty()) {
            return false;
        }
        ReteNodeRecipe knownRecipe = this.canonicalRecipeByEquivalenceClassID.get(recipe.getEquivalenceClassIDs().get(0));
        return recipe == knownRecipe;
    }

    private Set<ReteNodeRecipe> getSameClassCanonicalRecipes(ReteNodeRecipe recipe) {
        HashSet sameClassRecipes = this.canonicalRecipesByClass.get(recipe.eClass());
        if (sameClassRecipes == null) {
            sameClassRecipes = Sets.newHashSet();
            this.canonicalRecipesByClass.put(recipe.eClass(), sameClassRecipes);
        }
        return sameClassRecipes;
    }

    private boolean isEquivalentRecipe(ReteNodeRecipe recipe, ReteNodeRecipe knownRecipe) {
        return new EqualityHelper().equals(recipe, knownRecipe);
    }

    private static class EqualityHelper
    extends EcoreUtil.EqualityHelper {
        private static final long serialVersionUID = -8841971394686015188L;
        static final EAttribute reteNodeRecipe_EquivalenceClassIDs = RecipesPackage.eINSTANCE.getReteNodeRecipe_EquivalenceClassIDs();

        private EqualityHelper() {
        }

        protected boolean haveEqualFeature(EObject eObject1, EObject eObject2, EStructuralFeature feature) {
            if (reteNodeRecipe_EquivalenceClassIDs.equals(feature)) {
                return true;
            }
            return super.haveEqualFeature(eObject1, eObject2, feature);
        }

        public boolean equals(EObject eObject1, EObject eObject2) {
            EList<Long> eqClassIDs2;
            EList<Long> eqClassIDs1;
            if (eObject1 instanceof ReteNodeRecipe && eObject2 instanceof ReteNodeRecipe && !Collections.disjoint(eqClassIDs1 = ((ReteNodeRecipe)eObject1).getEquivalenceClassIDs(), eqClassIDs2 = ((ReteNodeRecipe)eObject2).getEquivalenceClassIDs())) {
                return true;
            }
            return super.equals(eObject1, eObject2);
        }
    }
}

