/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.query.runtime.rete.matcher;

import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.LinkedList;
import java.util.Map;
import java.util.concurrent.Callable;
import org.apache.log4j.Logger;
import org.eclipse.viatra.query.runtime.matchers.backend.IQueryBackend;
import org.eclipse.viatra.query.runtime.matchers.backend.IQueryResultProvider;
import org.eclipse.viatra.query.runtime.matchers.backend.QueryEvaluationHint;
import org.eclipse.viatra.query.runtime.matchers.context.IQueryRuntimeContext;
import org.eclipse.viatra.query.runtime.matchers.planning.QueryProcessingException;
import org.eclipse.viatra.query.runtime.matchers.psystem.queries.PQuery;
import org.eclipse.viatra.query.runtime.matchers.tuple.TupleMask;
import org.eclipse.viatra.query.runtime.matchers.util.CollectionsFactory;
import org.eclipse.viatra.query.runtime.rete.boundary.Disconnectable;
import org.eclipse.viatra.query.runtime.rete.boundary.ReteBoundary;
import org.eclipse.viatra.query.runtime.rete.construction.RetePatternBuildException;
import org.eclipse.viatra.query.runtime.rete.construction.plancompiler.ReteRecipeCompiler;
import org.eclipse.viatra.query.runtime.rete.index.Indexer;
import org.eclipse.viatra.query.runtime.rete.index.ProjectionIndexer;
import org.eclipse.viatra.query.runtime.rete.matcher.RetePatternMatcher;
import org.eclipse.viatra.query.runtime.rete.network.Network;
import org.eclipse.viatra.query.runtime.rete.network.NodeProvisioner;
import org.eclipse.viatra.query.runtime.rete.traceability.RecipeTraceInfo;

public class ReteEngine
implements IQueryBackend {
    protected Network reteNet;
    protected final int reteThreads;
    protected ReteBoundary boundary;
    private Logger logger;
    protected IQueryRuntimeContext runtimeContext;
    protected Collection<Disconnectable> disconnectables;
    protected Map<PQuery, RetePatternMatcher> matchers;
    protected ReteRecipeCompiler compiler;
    protected final boolean parallelExecutionEnabled;
    private boolean disposedOrUninitialized = true;

    public ReteEngine(Logger logger, IQueryRuntimeContext runtimeContext, int reteThreads) {
        this.logger = logger;
        this.runtimeContext = runtimeContext;
        this.reteThreads = reteThreads;
        this.parallelExecutionEnabled = reteThreads > 0;
        this.initEngine();
        this.compiler = null;
    }

    private synchronized void initEngine() {
        this.disposedOrUninitialized = false;
        this.disconnectables = new LinkedList<Disconnectable>();
        this.reteNet = new Network(this.reteThreads, this);
        this.boundary = new ReteBoundary(this);
        this.matchers = CollectionsFactory.getMap();
    }

    private synchronized void deconstructEngine() {
        this.ensureInitialized();
        this.reteNet.kill();
        for (Disconnectable disc : this.disconnectables) {
            disc.disconnect();
        }
        this.matchers = null;
        this.disconnectables = null;
        this.reteNet = null;
        this.boundary = null;
        this.disposedOrUninitialized = true;
    }

    public void killEngine() {
        this.deconstructEngine();
        this.compiler = null;
        this.logger = null;
    }

    public void reset() {
        this.deconstructEngine();
        this.initEngine();
        this.compiler.reset();
    }

    public synchronized RetePatternMatcher accessMatcher(final PQuery query) throws QueryProcessingException {
        this.ensureInitialized();
        RetePatternMatcher matcher = this.matchers.get(query);
        if (matcher == null) {
            this.constructionWrapper(new Callable<Void>(){

                @Override
                public Void call() throws QueryProcessingException {
                    RecipeTraceInfo prodNode = ReteEngine.this.boundary.accessProductionTrace(query);
                    RetePatternMatcher retePatternMatcher = new RetePatternMatcher(ReteEngine.this, prodNode);
                    retePatternMatcher.setTag(query);
                    ReteEngine.this.matchers.put(query, retePatternMatcher);
                    return null;
                }
            });
            matcher = this.matchers.get(query);
        }
        return matcher;
    }

    public synchronized void buildMatchersCoalesced(final Collection<PQuery> specifications) throws QueryProcessingException {
        this.ensureInitialized();
        this.constructionWrapper(new Callable<Void>(){

            @Override
            public Void call() throws QueryProcessingException {
                for (PQuery specification : specifications) {
                    ReteEngine.this.boundary.accessProductionNode(specification);
                }
                return null;
            }
        });
    }

    private void constructionWrapper(Callable<Void> payload) throws RetePatternBuildException {
        if (this.parallelExecutionEnabled) {
            this.reteNet.getStructuralChangeLock().lock();
        }
        try {
            try {
                this.runtimeContext.coalesceTraversals(payload);
            }
            catch (InvocationTargetException ex) {
                Throwable cause = ex.getCause();
                if (cause instanceof RetePatternBuildException) {
                    throw (RetePatternBuildException)((Object)cause);
                }
                if (cause instanceof RuntimeException) {
                    throw (RuntimeException)cause;
                }
                assert (false);
            }
        }
        finally {
            if (this.parallelExecutionEnabled) {
                this.reteNet.getStructuralChangeLock().unlock();
            }
            this.reteNet.waitForReteTermination();
        }
    }

    synchronized Indexer accessProjection(RecipeTraceInfo production, TupleMask mask) {
        this.ensureInitialized();
        NodeProvisioner nodeProvisioner = this.reteNet.getHeadContainer().getProvisioner();
        ProjectionIndexer result = nodeProvisioner.peekProjectionIndexer(production, mask);
        if (result == null) {
            if (this.parallelExecutionEnabled) {
                this.reteNet.getStructuralChangeLock().lock();
            }
            try {
                result = nodeProvisioner.accessProjectionIndexerOnetime(production, mask);
            }
            finally {
                if (this.parallelExecutionEnabled) {
                    this.reteNet.getStructuralChangeLock().unlock();
                }
            }
        }
        return result;
    }

    public void settle() {
        this.ensureInitialized();
        this.reteNet.waitForReteTermination();
    }

    public void settle(Runnable action) {
        this.ensureInitialized();
        this.reteNet.waitForReteTermination(action);
    }

    public Network getReteNet() {
        this.ensureInitialized();
        return this.reteNet;
    }

    public ReteBoundary getBoundary() {
        this.ensureInitialized();
        return this.boundary;
    }

    public void setCompiler(ReteRecipeCompiler builder) {
        this.ensureInitialized();
        this.compiler = builder;
    }

    public void addDisconnectable(Disconnectable disc) {
        this.ensureInitialized();
        this.disconnectables.add(disc);
    }

    public boolean isParallelExecutionEnabled() {
        return this.parallelExecutionEnabled;
    }

    public Logger getLogger() {
        this.ensureInitialized();
        return this.logger;
    }

    public IQueryRuntimeContext getRuntimeContext() {
        this.ensureInitialized();
        return this.runtimeContext;
    }

    public ReteRecipeCompiler getCompiler() {
        this.ensureInitialized();
        return this.compiler;
    }

    void ensureInitialized() {
        if (this.disposedOrUninitialized) {
            throw new IllegalStateException("Trying to use a Rete engine that has been disposed or has not yet been initialized.");
        }
    }

    public IQueryResultProvider getResultProvider(PQuery query) throws QueryProcessingException {
        return this.accessMatcher(query);
    }

    public IQueryResultProvider getResultProvider(PQuery query, QueryEvaluationHint hints) throws QueryProcessingException {
        return this.accessMatcher(query);
    }

    public IQueryResultProvider peekExistingResultProvider(PQuery query) {
        this.ensureInitialized();
        return this.matchers.get(query);
    }

    public void dispose() {
        this.killEngine();
    }

    public boolean isCaching() {
        return true;
    }
}

