/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.query.runtime.rete.single;

import java.util.Collection;
import java.util.Collections;
import org.eclipse.viatra.query.runtime.matchers.tuple.Tuple;
import org.eclipse.viatra.query.runtime.rete.network.ReteContainer;
import org.eclipse.viatra.query.runtime.rete.network.StandardNode;
import org.eclipse.viatra.query.runtime.rete.network.Supplier;
import org.eclipse.viatra.query.runtime.rete.network.Tunnel;
import org.eclipse.viatra.query.runtime.rete.traceability.TraceInfo;

public abstract class SingleInputNode
extends StandardNode
implements Tunnel {
    protected Supplier parent = null;

    public SingleInputNode(ReteContainer reteContainer) {
        super(reteContainer);
    }

    @Override
    public void appendParent(Supplier supplier) {
        if (this.parent != null) {
            throw new UnsupportedOperationException("Illegal RETE edge: " + this + " already has a parent (" + this.parent + ") and cannot connect to additional parent (" + supplier + ") as it is not a Uniqueness Enforcer Node. ");
        }
        this.parent = supplier;
    }

    @Override
    public void removeParent(Supplier supplier) {
        if (this.parent != supplier) {
            throw new IllegalArgumentException("Illegal RETE edge removal: the parent of " + this + " is not " + supplier);
        }
        this.parent = null;
    }

    public void propagatePullInto(Collection<Tuple> collector) {
        if (this.parent != null) {
            this.parent.pullInto(collector);
        }
    }

    @Override
    public Collection<Supplier> getParents() {
        if (this.parent == null) {
            return Collections.emptySet();
        }
        return Collections.singleton(this.parent);
    }

    @Override
    public void assignTraceInfo(TraceInfo traceInfo) {
        super.assignTraceInfo(traceInfo);
        if (traceInfo.propagateFromStandardNodeToSupplierParent() && this.parent != null) {
            this.parent.acceptPropagatedTraceInfo(traceInfo);
        }
    }
}

