/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.query.runtime.api;

import java.util.Arrays;
import org.eclipse.viatra.query.runtime.api.GenericPatternMatcher;
import org.eclipse.viatra.query.runtime.api.GenericQuerySpecification;
import org.eclipse.viatra.query.runtime.api.IPatternMatch;
import org.eclipse.viatra.query.runtime.api.impl.BasePatternMatch;

public abstract class GenericPatternMatch
extends BasePatternMatch {
    private final GenericQuerySpecification<? extends GenericPatternMatcher> specification;
    private final Object[] array;

    private GenericPatternMatch(GenericQuerySpecification<? extends GenericPatternMatcher> specification, Object[] array) {
        this.specification = specification;
        this.array = array;
    }

    @Override
    public Object get(String parameterName) {
        Integer index = this.specification.getPositionOfParameter(parameterName);
        return index == null ? null : this.array[index];
    }

    @Override
    public boolean set(String parameterName, Object newValue) {
        if (!this.isMutable()) {
            throw new UnsupportedOperationException();
        }
        Integer index = this.specification.getPositionOfParameter(parameterName);
        if (index == null) {
            return false;
        }
        this.array[index.intValue()] = newValue;
        return true;
    }

    @Override
    public Object[] toArray() {
        return Arrays.copyOf(this.array, this.array.length);
    }

    public int hashCode() {
        int result = 1;
        int i = 0;
        while (i < this.array.length) {
            result = 31 * result + (this.array[i] == null ? 0 : this.array[i].hashCode());
            ++i;
        }
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof GenericPatternMatch)) {
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof IPatternMatch)) {
                return false;
            }
            IPatternMatch other = (IPatternMatch)obj;
            if (!this.specification().equals(other.specification())) {
                return false;
            }
            return Arrays.deepEquals(this.array, other.toArray());
        }
        GenericPatternMatch other = (GenericPatternMatch)obj;
        return this.specification().equals(other.specification()) && Arrays.deepEquals(this.array, other.array);
    }

    @Override
    public String prettyPrint() {
        StringBuilder result = new StringBuilder();
        int i = 0;
        while (i < this.array.length) {
            if (i != 0) {
                result.append(", ");
            }
            result.append("\"" + this.parameterNames().get(i) + "\"=" + GenericPatternMatch.prettyPrintValue(this.array[i]));
            ++i;
        }
        return result.toString();
    }

    public GenericQuerySpecification<? extends GenericPatternMatcher> specification() {
        return this.specification;
    }

    public static GenericPatternMatch newEmptyMatch(GenericQuerySpecification<? extends GenericPatternMatcher> specification) {
        return new Mutable(specification, new Object[specification.getParameters().size()]);
    }

    public static GenericPatternMatch newMutableMatch(GenericQuerySpecification<? extends GenericPatternMatcher> specification, Object ... parameters) {
        return new Mutable(specification, parameters);
    }

    public static GenericPatternMatch newMatch(GenericQuerySpecification<? extends GenericPatternMatcher> specification, Object ... parameters) {
        return new Immutable(specification, Arrays.copyOf(parameters, parameters.length));
    }

    @Override
    public IPatternMatch toImmutable() {
        return this.isMutable() ? GenericPatternMatch.newMatch(this.specification, this.array) : this;
    }

    /* synthetic */ GenericPatternMatch(GenericQuerySpecification genericQuerySpecification, Object[] objectArray, GenericPatternMatch genericPatternMatch) {
        this(genericQuerySpecification, objectArray);
    }

    static final class Immutable
    extends GenericPatternMatch {
        Immutable(GenericQuerySpecification<? extends GenericPatternMatcher> specification, Object[] array) {
            super(specification, array, null);
        }

        @Override
        public boolean isMutable() {
            return false;
        }
    }

    static final class Mutable
    extends GenericPatternMatch {
        Mutable(GenericQuerySpecification<? extends GenericPatternMatcher> specification, Object[] array) {
            super(specification, array, null);
        }

        @Override
        public boolean isMutable() {
            return true;
        }
    }
}

