/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.query.runtime.api;

import com.google.common.base.Joiner;
import com.google.common.base.Objects;
import java.util.AbstractMap;
import java.util.Collections;
import java.util.Map;
import org.eclipse.viatra.query.runtime.matchers.backend.IQueryBackendFactory;
import org.eclipse.viatra.query.runtime.matchers.backend.QueryEvaluationHint;
import org.eclipse.viatra.query.runtime.rete.matcher.ReteBackendFactory;

public final class ViatraQueryEngineOptions {
    private final QueryEvaluationHint engineDefaultHints;
    private final IQueryBackendFactory defaultCachingBackendFactory;
    public static final ViatraQueryEngineOptions DEFAULT = new Builder().build();

    public static Builder defineOptions() {
        return new Builder();
    }

    public static Builder copyOptions(ViatraQueryEngineOptions options) {
        return new Builder(options);
    }

    private ViatraQueryEngineOptions(QueryEvaluationHint engineDefaultHints, IQueryBackendFactory defaultCachingBackendFactory) {
        this.engineDefaultHints = new QueryEvaluationHint(engineDefaultHints.getQueryBackendFactory(), engineDefaultHints.getBackendHints());
        this.defaultCachingBackendFactory = defaultCachingBackendFactory;
    }

    public QueryEvaluationHint getEngineDefaultHints() {
        return this.engineDefaultHints;
    }

    public IQueryBackendFactory getDefaultBackendFactory() {
        return this.engineDefaultHints.getQueryBackendFactory();
    }

    public IQueryBackendFactory getDefaultCachingBackendFactory() {
        return this.defaultCachingBackendFactory;
    }

    public String toString() {
        String result;
        StringBuilder sb = new StringBuilder();
        if (!Objects.equal((Object)this.engineDefaultHints, (Object)ViatraQueryEngineOptions.DEFAULT.engineDefaultHints)) {
            sb.append("backend: ").append(this.engineDefaultHints.getQueryBackendFactory().getBackendClass().getSimpleName());
            Map backendHints = this.engineDefaultHints.getBackendHints();
            sb.append("hints: ");
            if (backendHints instanceof AbstractMap) {
                sb.append(backendHints.toString());
            } else {
                String joinedHintMap = Joiner.on((String)", ").withKeyValueSeparator("=").join(backendHints);
                sb.append('{').append(joinedHintMap).append('}');
            }
        }
        return (result = sb.toString()).isEmpty() ? "defaults" : result;
    }

    /* synthetic */ ViatraQueryEngineOptions(QueryEvaluationHint queryEvaluationHint, IQueryBackendFactory iQueryBackendFactory, ViatraQueryEngineOptions viatraQueryEngineOptions) {
        this(queryEvaluationHint, iQueryBackendFactory);
    }

    public static final class Builder {
        private QueryEvaluationHint engineDefaultHints;
        private IQueryBackendFactory defaultBackendFactory;
        private IQueryBackendFactory defaultCachingBackendFactory;

        public Builder() {
        }

        public Builder(ViatraQueryEngineOptions from) {
            this.engineDefaultHints = from.engineDefaultHints;
            this.defaultBackendFactory = this.engineDefaultHints.getQueryBackendFactory();
            this.defaultCachingBackendFactory = from.defaultCachingBackendFactory;
        }

        public Builder withDefaultHint(QueryEvaluationHint engineDefaultHints) {
            this.engineDefaultHints = engineDefaultHints;
            return this;
        }

        public Builder withDefaultBackend(IQueryBackendFactory defaultBackendFactory) {
            this.defaultBackendFactory = defaultBackendFactory;
            return this;
        }

        public Builder withDefaultCachingBackend(IQueryBackendFactory defaultCachingBackendFactory) {
            this.defaultCachingBackendFactory = defaultCachingBackendFactory;
            return this;
        }

        public ViatraQueryEngineOptions build() {
            ReteBackendFactory defaultFactory = this.defaultBackendFactory == null ? new ReteBackendFactory() : this.defaultBackendFactory;
            ReteBackendFactory defaultCachingFactory = this.defaultCachingBackendFactory == null ? new ReteBackendFactory() : this.defaultBackendFactory;
            QueryEvaluationHint hint = this.engineDefaultHints == null ? new QueryEvaluationHint((IQueryBackendFactory)defaultFactory, Collections.emptyMap()) : this.engineDefaultHints;
            hint = hint.overrideBy(new QueryEvaluationHint((IQueryBackendFactory)defaultFactory, null));
            return new ViatraQueryEngineOptions(hint, (IQueryBackendFactory)defaultCachingFactory, null);
        }
    }
}

