/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.query.runtime.api.impl;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.viatra.query.runtime.api.IPatternMatch;

public abstract class BasePatternMatch
implements IPatternMatch {
    protected static <T> List<T> makeImmutableList(T ... elements) {
        return Collections.unmodifiableList(Arrays.asList(elements));
    }

    public static String prettyPrintValue(Object o) {
        if (o == null) {
            return "(null)";
        }
        String name = BasePatternMatch.prettyPrintFeature(o, "name");
        if (name != null) {
            return name;
        }
        return o.toString();
    }

    public static String prettyPrintFeature(Object o, String featureName) {
        Object value;
        EStructuralFeature feature;
        if (o instanceof EObject && (feature = ((EObject)o).eClass().getEStructuralFeature(featureName)) != null && (value = ((EObject)o).eGet(feature)) != null) {
            return value.toString();
        }
        return null;
    }

    @Override
    public Object get(int position) {
        if (position >= 0 && position < this.parameterNames().size()) {
            return this.get(this.parameterNames().get(position));
        }
        return null;
    }

    @Override
    public boolean set(int position, Object newValue) {
        if (!this.isMutable()) {
            throw new UnsupportedOperationException();
        }
        if (position >= 0 && position < this.parameterNames().size()) {
            return this.set(this.parameterNames().get(position), newValue);
        }
        return false;
    }

    public String toString() {
        return "Match<" + this.patternName() + ">{" + this.prettyPrint() + "}";
    }

    @Override
    public boolean isCompatibleWith(IPatternMatch other) {
        if (other == null) {
            return true;
        }
        if (!this.specification().equals(other.specification())) {
            return false;
        }
        int i = 0;
        while (i < this.parameterNames().size()) {
            Object value = this.get(i);
            Object otherValue = other.get(i);
            if (value != null && otherValue != null && !value.equals(otherValue)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    @Override
    public String patternName() {
        return this.specification().getFullyQualifiedName();
    }

    @Override
    public List<String> parameterNames() {
        return this.specification().getParameterNames();
    }
}

