/**
 * Copyright (c) 2010-2015, Grill Bal�zs, Istvan Rath and Daniel Varro
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * Contributors:
 * Grill Bal�zs - initial API and implementation
 */
package org.eclipse.viatra.query.testing.core;

import com.google.common.base.Objects;
import com.google.common.collect.Iterables;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.viatra.query.runtime.api.IPatternMatch;
import org.eclipse.viatra.query.runtime.api.IQuerySpecification;
import org.eclipse.viatra.query.runtime.api.ViatraQueryMatcher;
import org.eclipse.viatra.query.runtime.exception.ViatraQueryException;
import org.eclipse.viatra.query.testing.core.IMatchSetModelProvider;
import org.eclipse.viatra.query.testing.snapshot.MatchSetRecord;
import org.eclipse.viatra.query.testing.snapshot.QuerySnapshot;
import org.eclipse.xtext.xbase.lib.Functions.Function1;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

@SuppressWarnings("all")
public class SnapshotMatchSetModelProvider implements IMatchSetModelProvider {
  private final URI snapshotModel;
  
  public SnapshotMatchSetModelProvider(final URI snapshotModel) {
    this.snapshotModel = snapshotModel;
  }
  
  @Override
  public <Match extends IPatternMatch> MatchSetRecord getMatchSetRecord(final ResourceSet resourceSet, final IQuerySpecification<? extends ViatraQueryMatcher<Match>> querySpecification, final Match filter) throws ViatraQueryException {
    MatchSetRecord _xblockexpression = null;
    {
      final String FQN = querySpecification.getFullyQualifiedName();
      Resource _resource = resourceSet.getResource(this.snapshotModel, true);
      EList<EObject> _contents = _resource.getContents();
      final Iterable<QuerySnapshot> snapshot = Iterables.<QuerySnapshot>filter(_contents, QuerySnapshot.class);
      boolean _isEmpty = IterableExtensions.isEmpty(snapshot);
      if (_isEmpty) {
        String _plus = (this.snapshotModel + " is not a Snapshot model");
        throw new IllegalArgumentException(_plus);
      }
      QuerySnapshot _head = IterableExtensions.<QuerySnapshot>head(snapshot);
      EList<MatchSetRecord> _matchSetRecords = null;
      if (_head!=null) {
        _matchSetRecords=_head.getMatchSetRecords();
      }
      final Function1<MatchSetRecord, Boolean> _function = new Function1<MatchSetRecord, Boolean>() {
        @Override
        public Boolean apply(final MatchSetRecord it) {
          String _patternQualifiedName = it.getPatternQualifiedName();
          return Boolean.valueOf(Objects.equal(FQN, _patternQualifiedName));
        }
      };
      final MatchSetRecord record = IterableExtensions.<MatchSetRecord>findFirst(_matchSetRecords, _function);
      boolean _equals = Objects.equal(record, null);
      if (_equals) {
        throw new IllegalArgumentException(((("Could not find snapshot for " + FQN) + " in ") + this.snapshotModel));
      }
      _xblockexpression = record;
    }
    return _xblockexpression;
  }
  
  @Override
  public void dispose() {
  }
  
  @Override
  public boolean updatedByModify() {
    return false;
  }
}
