/**
 * Copyright (c) 2010-2015, Balázs Grill, Istvan Rath and Daniel Varro
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * Contributors:
 * Balázs Grill - initial API and implementation
 */
package org.eclipse.viatra.query.testing.core;

import org.apache.log4j.AppenderSkeleton;
import org.apache.log4j.Level;
import org.apache.log4j.spi.LoggingEvent;

/**
 * @author Grill Balázs
 */
@SuppressWarnings("all")
public class TestingSeverityAggregatorLogAppender extends AppenderSkeleton {
  private Level severity = Level.INFO;
  
  private LoggingEvent event;
  
  @Override
  public void close() {
  }
  
  public void clear() {
    this.severity = Level.INFO;
  }
  
  @Override
  public boolean requiresLayout() {
    return false;
  }
  
  @Override
  protected void append(final LoggingEvent event) {
    final Level eventLevel = event.getLevel();
    int _int = this.severity.toInt();
    int _int_1 = eventLevel.toInt();
    boolean _lessThan = (_int < _int_1);
    if (_lessThan) {
      this.severity = eventLevel;
      this.event = event;
    }
  }
  
  public LoggingEvent getEvent() {
    return this.event;
  }
  
  public Level getSeverity() {
    return this.severity;
  }
}
