/**
 * Copyright (c) 2010-2015, Grill Balázs, Istvan Rath and Daniel Varro
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * Contributors:
 * Grill Balázs - initial API and implementation
 */
package org.eclipse.viatra.query.testing.core.internal;

import com.google.common.base.Equivalence;
import com.google.common.collect.MapDifference;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.viatra.query.testing.core.SnapshotHelper;
import org.eclipse.viatra.query.testing.snapshot.MatchRecord;
import org.eclipse.viatra.query.testing.snapshot.MatchSubstitutionRecord;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions.Function1;
import org.eclipse.xtext.xbase.lib.Functions.Function2;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;

/**
 * @author Grill Balázs
 */
@SuppressWarnings("all")
public class MatchRecordEquvalence extends Equivalence<MatchRecord> {
  @Extension
  private SnapshotHelper _snapshotHelper = new SnapshotHelper();
  
  public final static MatchRecordEquvalence INSTANCE = new MatchRecordEquvalence();
  
  public HashSet<Equivalence.Wrapper<MatchRecord>> wrap(final Iterable<MatchRecord> matches) {
    final Function1<MatchRecord, Equivalence.Wrapper<MatchRecord>> _function = new Function1<MatchRecord, Equivalence.Wrapper<MatchRecord>>() {
      @Override
      public Equivalence.Wrapper<MatchRecord> apply(final MatchRecord it) {
        return MatchRecordEquvalence.this.<MatchRecord>wrap(it);
      }
    };
    Iterable<Equivalence.Wrapper<MatchRecord>> _map = IterableExtensions.<MatchRecord, Equivalence.Wrapper<MatchRecord>>map(matches, _function);
    return Sets.<Equivalence.Wrapper<MatchRecord>>newHashSet(_map);
  }
  
  public HashSet<MatchRecord> unwrap(final Iterable<Equivalence.Wrapper<MatchRecord>> wrapped) {
    final Function1<Equivalence.Wrapper<MatchRecord>, MatchRecord> _function = new Function1<Equivalence.Wrapper<MatchRecord>, MatchRecord>() {
      @Override
      public MatchRecord apply(final Equivalence.Wrapper<MatchRecord> it) {
        return it.get();
      }
    };
    Iterable<MatchRecord> _map = IterableExtensions.<Equivalence.Wrapper<MatchRecord>, MatchRecord>map(wrapped, _function);
    return Sets.<MatchRecord>newHashSet(_map);
  }
  
  public HashMap<String, Object> toMap(final MatchRecord record) {
    final HashMap<String, Object> result = CollectionLiterals.<String, Object>newHashMap();
    EList<MatchSubstitutionRecord> _substitutions = record.getSubstitutions();
    for (final MatchSubstitutionRecord sub : _substitutions) {
      String _parameterName = sub.getParameterName();
      Object _derivedValue = this._snapshotHelper.derivedValue(sub);
      result.put(_parameterName, _derivedValue);
    }
    return result;
  }
  
  /**
   * (non-Javadoc)
   * @see Equivalence#doEquivalent(java.lang.Object, java.lang.Object)
   */
  @Override
  protected boolean doEquivalent(final MatchRecord a, final MatchRecord b) {
    HashMap<String, Object> _map = this.toMap(a);
    HashMap<String, Object> _map_1 = this.toMap(b);
    MapDifference<String, Object> _difference = Maps.<String, Object>difference(_map, _map_1);
    return _difference.areEqual();
  }
  
  /**
   * (non-Javadoc)
   * @see Equivalence#doHash(java.lang.Object)
   */
  @Override
  protected int doHash(final MatchRecord t) {
    EList<MatchSubstitutionRecord> _substitutions = t.getSubstitutions();
    final Function1<MatchSubstitutionRecord, Integer> _function = new Function1<MatchSubstitutionRecord, Integer>() {
      @Override
      public Integer apply(final MatchSubstitutionRecord it) {
        Object _derivedValue = MatchRecordEquvalence.this._snapshotHelper.derivedValue(it);
        int _hashCode = 0;
        if (_derivedValue!=null) {
          _hashCode=_derivedValue.hashCode();
        }
        return Integer.valueOf(_hashCode);
      }
    };
    List<Integer> _map = ListExtensions.<MatchSubstitutionRecord, Integer>map(_substitutions, _function);
    final Function2<Integer, Integer, Integer> _function_1 = new Function2<Integer, Integer, Integer>() {
      @Override
      public Integer apply(final Integer r, final Integer e) {
        return Integer.valueOf(((r).intValue() + (e).intValue()));
      }
    };
    return (int) IterableExtensions.<Integer, Integer>fold(_map, Integer.valueOf(0), _function_1);
  }
}
