/**
 * Copyright (c) 2010-2015, Grill Balázs, Istvan Rath and Daniel Varro
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * Contributors:
 * Grill Balázs - initial API and implementation
 */
package org.eclipse.viatra.query.testing.core;

import com.google.common.base.Equivalence;
import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.emf.common.util.EList;
import org.eclipse.viatra.query.testing.core.internal.MatchRecordEquvalence;
import org.eclipse.viatra.query.testing.snapshot.MatchRecord;
import org.eclipse.viatra.query.testing.snapshot.MatchSetRecord;

/**
 * Difference descriptor for {@link MatchSetRecord} elements.
 */
@SuppressWarnings("all")
public class MatchSetRecordDiff {
  public MatchSetRecordDiff(final Set<MatchRecord> additions, final Set<MatchRecord> removals) {
    this.additions = additions;
    this.removals = removals;
  }
  
  private final Set<MatchRecord> additions;
  
  private final Set<MatchRecord> removals;
  
  public Set<MatchRecord> getAdditions() {
    return this.additions;
  }
  
  public Set<MatchRecord> getRemovals() {
    return this.removals;
  }
  
  public boolean isEmpty() {
    boolean _and = false;
    boolean _isEmpty = this.additions.isEmpty();
    if (!_isEmpty) {
      _and = false;
    } else {
      boolean _isEmpty_1 = this.removals.isEmpty();
      _and = _isEmpty_1;
    }
    return _and;
  }
  
  public static MatchSetRecordDiff compute(final MatchSetRecord expected, final MatchSetRecord actual) {
    MatchSetRecordDiff _xblockexpression = null;
    {
      EList<MatchRecord> _matches = expected.getMatches();
      final HashSet<Equivalence.Wrapper<MatchRecord>> expectedSet = MatchRecordEquvalence.INSTANCE.wrap(_matches);
      EList<MatchRecord> _matches_1 = actual.getMatches();
      final HashSet<Equivalence.Wrapper<MatchRecord>> actualSet = MatchRecordEquvalence.INSTANCE.wrap(_matches_1);
      final Sets.SetView<Equivalence.Wrapper<MatchRecord>> unexpected = Sets.<Equivalence.Wrapper<MatchRecord>>difference(actualSet, expectedSet);
      final Sets.SetView<Equivalence.Wrapper<MatchRecord>> missing = Sets.<Equivalence.Wrapper<MatchRecord>>difference(expectedSet, actualSet);
      HashSet<MatchRecord> _unwrap = MatchRecordEquvalence.INSTANCE.unwrap(unexpected);
      HashSet<MatchRecord> _unwrap_1 = MatchRecordEquvalence.INSTANCE.unwrap(missing);
      _xblockexpression = new MatchSetRecordDiff(_unwrap, _unwrap_1);
    }
    return _xblockexpression;
  }
}
