/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.query.testing.ui.handlers;

import com.google.common.collect.Iterators;
import com.google.common.collect.Sets;
import com.google.inject.Inject;
import java.io.IOException;
import java.util.Iterator;
import java.util.Set;
import org.apache.log4j.Logger;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.ui.dialogs.WorkspaceResourceDialog;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.viatra.query.runtime.api.ViatraQueryEngine;
import org.eclipse.viatra.query.runtime.api.scope.QueryScope;
import org.eclipse.viatra.query.runtime.emf.EMFScope;
import org.eclipse.viatra.query.testing.core.ModelLoadHelper;
import org.eclipse.viatra.query.testing.core.SnapshotHelper;
import org.eclipse.viatra.query.testing.snapshot.QuerySnapshot;
import org.eclipse.viatra.query.testing.snapshot.SnapshotFactory;
import org.eclipse.viatra.query.tooling.ui.queryexplorer.content.matcher.PatternMatcherContent;
import org.eclipse.viatra.query.tooling.ui.queryexplorer.content.matcher.PatternMatcherRootContent;
import org.eclipse.viatra.query.tooling.ui.util.IFilteredMatcherContent;

public class SaveSnapshotHandler
extends AbstractHandler {
    @Inject
    SnapshotHelper helper;
    @Inject
    ModelLoadHelper loader;
    @Inject
    private Logger logger;

    public Object execute(ExecutionEvent event) throws ExecutionException {
        IStructuredSelection selection = (IStructuredSelection)HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        if (selection instanceof TreeSelection) {
            this.saveSnapshot((TreeSelection)selection, event);
        }
        return null;
    }

    /*
     * Unable to fully structure code
     */
    private void saveSnapshot(TreeSelection selection, ExecutionEvent event) {
        block19: {
            block17: {
                block18: {
                    obj = selection.getFirstElement();
                    editor = null;
                    matchers = Sets.newHashSet();
                    engine = null;
                    if (obj instanceof PatternMatcherContent) {
                        observablePatternMatcher = (PatternMatcherContent)obj;
                        editor = ((PatternMatcherRootContent)observablePatternMatcher.getParent()).getEditorPart();
                        matchers.add(observablePatternMatcher);
                        matcher = observablePatternMatcher.getMatcher();
                        if (matcher != null) {
                            engine = matcher.getEngine();
                        }
                    } else if (obj instanceof PatternMatcherRootContent) {
                        matcherRoot = (PatternMatcherRootContent)obj;
                        editor = matcherRoot.getEditorPart();
                        iterator = matcherRoot.getChildrenIterator();
                        while (iterator.hasNext()) {
                            patternMatcherContent = (PatternMatcherContent)iterator.next();
                            matchers.add(patternMatcherContent);
                            matcher = patternMatcherContent.getMatcher();
                            if (matcher == null || matcher.getEngine() == null) continue;
                            engine = matcher.getEngine();
                        }
                    } else {
                        filteredMatchers = Iterators.filter((Iterator)selection.iterator(), IFilteredMatcherContent.class);
                        while (filteredMatchers.hasNext()) {
                            selectedElement = (IFilteredMatcherContent)filteredMatchers.next();
                            matchers.add(selectedElement);
                            engine = selectedElement.getMatcher().getEngine();
                        }
                    }
                    if (engine == null) {
                        this.logger.error((Object)"Cannot save snapshot without ViatraQueryEngine!");
                        return;
                    }
                    resourceSet = this.getResourceSetForScope(engine.getScope());
                    if (resourceSet == null) {
                        this.logger.error((Object)"Cannot save snapshot, models not in ResourceSet!");
                        return;
                    }
                    snapshotFile = null;
                    files = WorkspaceResourceDialog.openFileSelection((Shell)HandlerUtil.getActiveShell((ExecutionEvent)event), (String)"Existing snapshot", (String)"Select existing Query snapshot file (Cancel for new file)", (boolean)false, null, null);
                    snapshot = null;
                    if (files.length != 0) break block17;
                    snapshotFile = WorkspaceResourceDialog.openNewFile((Shell)HandlerUtil.getActiveShell((ExecutionEvent)event), (String)"New snapshot", (String)"Select Query snapshot target file (.snapshot extension)", null, null);
                    if (snapshotFile == null || snapshotFile.exists()) break block18;
                    snapshot = SnapshotFactory.eINSTANCE.createQuerySnapshot();
                    res = resourceSet.createResource(URI.createPlatformResourceURI((String)snapshotFile.getFullPath().toString(), (boolean)true));
                    res.getContents().add((Object)snapshot);
                    break block19;
                }
                this.logger.error((Object)"Selected file name must use .snapshot extension!");
                return;
            }
            snapshotFile = files[0];
            if (snapshotFile == null || !snapshotFile.getFileExtension().equals("snapshot")) ** GOTO lbl66
            snapshot = this.loader.loadExpectedResultsFromFile(resourceSet, snapshotFile);
            if (snapshot != null) {
                if (!this.validateInputSpecification(engine, snapshot)) {
                    return;
                }
            } else {
                this.logger.error((Object)"Selected file does not contain snapshot!");
                return;
lbl66:
                // 1 sources

                this.logger.error((Object)"Selected file not .snapshot!");
                return;
            }
        }
        for (IFilteredMatcherContent matcher : matchers) {
            if (matcher.getMatcher() == null) continue;
            filter = matcher.getFilterMatch();
            this.helper.saveMatchesToSnapshot(matcher.getMatcher(), filter, snapshot);
        }
        if (editor != null) {
            editor.doSave((IProgressMonitor)new NullProgressMonitor());
        } else {
            try {
                snapshot.eResource().save(null);
            }
            catch (IOException e) {
                this.logger.error((Object)"Error during saving snapshot into file!", (Throwable)e);
            }
        }
    }

    private boolean validateInputSpecification(ViatraQueryEngine engine, QuerySnapshot snapshot) {
        if (snapshot.getInputSpecification() != null) {
            Notifier root = this.helper.getEMFRootForSnapshot(snapshot);
            Notifier matcherRoot = this.getScopeRoot(engine.getScope());
            if (matcherRoot != root) {
                this.logger.error((Object)("Existing snapshot model root (" + root + ") not equal to selected input (" + matcherRoot + ")!"));
                return false;
            }
            return true;
        }
        return true;
    }

    private ResourceSet getResourceSetForScope(QueryScope scope) {
        if (scope instanceof EMFScope) {
            EMFScope emfScope = (EMFScope)scope;
            Set scopeRoots = emfScope.getScopeRoots();
            if (scopeRoots.size() > 1) {
                throw new IllegalArgumentException("EMF scopes with multiple ResourceSets are not supported!");
            }
            Notifier notifier = (Notifier)scopeRoots.iterator().next();
            if (notifier instanceof EObject) {
                Resource resource = ((EObject)notifier).eResource();
                if (resource != null) {
                    return resource.getResourceSet();
                }
                return null;
            }
            if (notifier instanceof Resource) {
                return ((Resource)notifier).getResourceSet();
            }
            if (notifier instanceof ResourceSet) {
                return (ResourceSet)notifier;
            }
            return null;
        }
        throw new IllegalArgumentException("Non-EMF scopes are not supported!");
    }

    private Notifier getScopeRoot(QueryScope scope) {
        if (scope instanceof EMFScope) {
            EMFScope emfScope = (EMFScope)scope;
            Set scopeRoots = emfScope.getScopeRoots();
            if (scopeRoots.size() > 1) {
                throw new IllegalArgumentException("EMF scopes with multiple ResourceSets are not supported!");
            }
            return (Notifier)scopeRoots.iterator().next();
        }
        throw new IllegalArgumentException("Non-EMF scopes are not supported!");
    }
}

