/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.query.tooling.localsearch.ui.debugger.handlers;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.viatra.query.runtime.api.AdvancedViatraQueryEngine;
import org.eclipse.viatra.query.runtime.api.IQuerySpecification;
import org.eclipse.viatra.query.runtime.api.ViatraQueryEngine;
import org.eclipse.viatra.query.runtime.api.ViatraQueryMatcher;
import org.eclipse.viatra.query.runtime.exception.ViatraQueryException;
import org.eclipse.viatra.query.runtime.localsearch.matcher.ILocalSearchAdapter;
import org.eclipse.viatra.query.runtime.localsearch.matcher.LocalSearchMatcher;
import org.eclipse.viatra.query.runtime.localsearch.matcher.integration.LocalSearchBackendFactory;
import org.eclipse.viatra.query.runtime.localsearch.matcher.integration.LocalSearchResultProvider;
import org.eclipse.viatra.query.runtime.matchers.backend.IQueryBackend;
import org.eclipse.viatra.query.runtime.matchers.backend.IQueryBackendFactory;
import org.eclipse.viatra.query.runtime.matchers.planning.QueryProcessingException;
import org.eclipse.viatra.query.tooling.localsearch.ui.debugger.LocalSearchDebugger;
import org.eclipse.viatra.query.tooling.ui.util.IFilteredMatcherContent;

public class StartLocalSearchHandler
extends AbstractHandler {
    public static Thread planExecutorThread = null;

    public Object execute(final ExecutionEvent event) throws ExecutionException {
        try {
            Object obj;
            ISelection selection = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
            if (selection instanceof IStructuredSelection && (obj = ((IStructuredSelection)selection).iterator().next()) instanceof IFilteredMatcherContent) {
                IFilteredMatcherContent content = (IFilteredMatcherContent)obj;
                ViatraQueryMatcher matcher = content.getMatcher();
                IQuerySpecification specification = matcher.getSpecification();
                AdvancedViatraQueryEngine engine = AdvancedViatraQueryEngine.from((ViatraQueryEngine)matcher.getEngine());
                IQueryBackend lsBackend = engine.getQueryBackend((IQueryBackendFactory)LocalSearchBackendFactory.INSTANCE);
                final Object[] adornment = content.getFilterMatch().toArray();
                final LocalSearchResultProvider lsResultProvider = (LocalSearchResultProvider)lsBackend.getResultProvider(specification.getInternalQueryRepresentation());
                Runnable planExecutorRunnable = new Runnable(){

                    @Override
                    public void run() {
                        try {
                            LocalSearchMatcher localSearchMatcher = lsResultProvider.newLocalSearchMatcher(adornment);
                            LocalSearchDebugger debugger = new LocalSearchDebugger();
                            localSearchMatcher.addAdapter((ILocalSearchAdapter)debugger);
                            debugger.setStartHandlerCalled(true);
                            localSearchMatcher.getAllMatches();
                        }
                        catch (Exception e) {
                            final Shell shell = HandlerUtil.getActiveShell((ExecutionEvent)event);
                            shell.getDisplay().asyncExec(new Runnable(){

                                @Override
                                public void run() {
                                    MessageDialog.open((int)1, (Shell)shell, (String)"Local search debugger", (String)("Error while initializing local search debugger: " + e.getMessage()), (int)0x10000000);
                                }
                            });
                            throw new RuntimeException(e);
                        }
                    }
                };
                if (planExecutorThread == null || !planExecutorThread.isAlive()) {
                    planExecutorThread = new Thread(planExecutorRunnable);
                    planExecutorThread.start();
                } else if (planExecutorThread.isAlive()) {
                    planExecutorThread.interrupt();
                    planExecutorThread = new Thread(planExecutorRunnable);
                    planExecutorThread.start();
                }
            }
        }
        catch (ViatraQueryException | QueryProcessingException e) {
            throw new ExecutionException("Error starting local search debugger", e);
        }
        return null;
    }
}

