/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.query.tooling.ui.queryresult;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import com.google.common.collect.Table;
import com.google.common.collect.TreeMultimap;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.viatra.query.patternlanguage.emf.specification.SpecificationBuilder;
import org.eclipse.viatra.query.runtime.api.AdvancedViatraQueryEngine;
import org.eclipse.viatra.query.runtime.api.IMatchProcessor;
import org.eclipse.viatra.query.runtime.api.IPatternMatch;
import org.eclipse.viatra.query.runtime.api.IQuerySpecification;
import org.eclipse.viatra.query.runtime.api.ViatraQueryEngine;
import org.eclipse.viatra.query.runtime.api.ViatraQueryEngineLifecycleListener;
import org.eclipse.viatra.query.runtime.api.ViatraQueryMatcher;
import org.eclipse.viatra.query.runtime.api.scope.QueryScope;
import org.eclipse.viatra.query.runtime.base.api.BaseIndexOptions;
import org.eclipse.viatra.query.runtime.emf.EMFScope;
import org.eclipse.viatra.query.runtime.extensibility.IQuerySpecificationProvider;
import org.eclipse.viatra.query.runtime.matchers.backend.QueryEvaluationHint;
import org.eclipse.viatra.query.runtime.matchers.psystem.queries.PQuery;
import org.eclipse.viatra.query.runtime.registry.IQuerySpecificationRegistry;
import org.eclipse.viatra.query.runtime.registry.IQuerySpecificationRegistryChangeListener;
import org.eclipse.viatra.query.runtime.registry.IQuerySpecificationRegistryEntry;
import org.eclipse.viatra.query.runtime.registry.IRegistryView;
import org.eclipse.viatra.query.runtime.registry.IRegistryViewFactory;
import org.eclipse.viatra.query.runtime.registry.view.AbstractRegistryView;
import org.eclipse.viatra.query.tooling.ui.ViatraQueryGUIPlugin;
import org.eclipse.viatra.query.tooling.ui.browser.ViatraQueryToolingBrowserPlugin;
import org.eclipse.viatra.query.tooling.ui.queryexplorer.IModelConnector;
import org.eclipse.viatra.query.tooling.ui.queryregistry.index.IPatternBasedSpecificationProvider;
import org.eclipse.viatra.query.tooling.ui.queryresult.IQueryResultViewModelListener;
import org.eclipse.viatra.query.tooling.ui.queryresult.QueryResultTreeMatcher;
import org.eclipse.viatra.query.tooling.ui.util.IFilteredMatcherCollection;
import org.eclipse.viatra.query.tooling.ui.util.IFilteredMatcherContent;
import org.eclipse.viatra.transformation.evm.api.ActivationLifeCycle;
import org.eclipse.viatra.transformation.evm.api.ExecutionSchema;
import org.eclipse.viatra.transformation.evm.api.Job;
import org.eclipse.viatra.transformation.evm.api.RuleSpecification;
import org.eclipse.viatra.transformation.evm.api.Scheduler;
import org.eclipse.viatra.transformation.evm.api.resolver.ConflictResolver;
import org.eclipse.viatra.transformation.evm.specific.ExecutionSchemas;
import org.eclipse.viatra.transformation.evm.specific.Jobs;
import org.eclipse.viatra.transformation.evm.specific.Lifecycles;
import org.eclipse.viatra.transformation.evm.specific.Rules;
import org.eclipse.viatra.transformation.evm.specific.Schedulers;
import org.eclipse.viatra.transformation.evm.specific.crud.CRUDActivationStateEnum;
import org.eclipse.viatra.transformation.evm.specific.resolver.InvertedDisappearancePriorityConflictResolver;
import org.eclipse.viatra.transformation.evm.specific.scheduler.UpdateCompleteBasedScheduler;
import org.eclipse.xtend.lib.annotations.AccessorType;
import org.eclipse.xtend.lib.annotations.Accessors;
import org.eclipse.xtend.lib.annotations.FinalFieldsConstructor;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.Procedures;
import org.eclipse.xtext.xbase.lib.Pure;
import org.osgi.framework.Bundle;

public class QueryResultTreeInput
implements IFilteredMatcherCollection {
    @Accessors(value={AccessorType.PUBLIC_GETTER})
    private AdvancedViatraQueryEngine engine;
    @Accessors(value={AccessorType.PUBLIC_GETTER})
    private boolean readOnlyEngine;
    @Accessors(value={AccessorType.PUBLIC_GETTER})
    private Map<String, QueryResultTreeMatcher> matchers;
    @Accessors(value={AccessorType.PUBLIC_GETTER, AccessorType.PROTECTED_SETTER})
    private IModelConnector modelConnector;
    private Table<String, String, IQuerySpecificationRegistryEntry> loadedEntries;
    private Multimap<String, String> knownErrorEntries;
    private SpecificationBuilder builder;
    private ExecutionSchema schema;
    private EngineLifecycleListener lifecycleListener;
    private RegistryChangeListener registryListener;
    private IRegistryView view;
    @Accessors(value={AccessorType.PUBLIC_GETTER})
    private QueryEvaluationHint hint;
    private Set<IQueryResultViewModelListener> listeners;

    public QueryResultTreeInput(AdvancedViatraQueryEngine engine, final IQuerySpecificationRegistry registry, boolean readOnlyEngine, QueryEvaluationHint hint) {
        EngineLifecycleListener _engineLifecycleListener;
        ExecutionSchema _createViatraQueryExecutionSchema;
        HashSet _newHashSet;
        SpecificationBuilder _specificationBuilder;
        TreeMultimap _create_1;
        HashBasedTable _create;
        TreeMap _newTreeMap;
        this.engine = engine;
        this.hint = hint;
        this.readOnlyEngine = readOnlyEngine;
        this.matchers = _newTreeMap = Maps.newTreeMap();
        this.loadedEntries = _create = HashBasedTable.create();
        this.knownErrorEntries = _create_1 = TreeMultimap.create();
        this.builder = _specificationBuilder = new SpecificationBuilder();
        this.listeners = _newHashSet = Sets.newHashSet();
        UpdateCompleteBasedScheduler.UpdateCompleteBasedSchedulerFactory _queryEngineSchedulerFactory = Schedulers.getQueryEngineSchedulerFactory((ViatraQueryEngine)engine);
        InvertedDisappearancePriorityConflictResolver _invertedDisappearancePriorityConflictResolver = new InvertedDisappearancePriorityConflictResolver();
        this.schema = _createViatraQueryExecutionSchema = ExecutionSchemas.createViatraQueryExecutionSchema((ViatraQueryEngine)engine, (Scheduler.ISchedulerFactory)_queryEngineSchedulerFactory, (ConflictResolver)_invertedDisappearancePriorityConflictResolver);
        Set _currentMatchers = engine.getCurrentMatchers();
        Procedures.Procedure1<ViatraQueryMatcher<? extends IPatternMatch>> _function = new Procedures.Procedure1<ViatraQueryMatcher<? extends IPatternMatch>>(){

            public void apply(ViatraQueryMatcher<? extends IPatternMatch> it) {
                QueryResultTreeInput.this.createMatcher(it);
            }
        };
        IterableExtensions.forEach((Iterable)_currentMatchers, (Procedures.Procedure1)_function);
        this.schema.startUnscheduledExecution();
        this.lifecycleListener = _engineLifecycleListener = new EngineLifecycleListener(this);
        engine.addLifecycleListener((ViatraQueryEngineLifecycleListener)this.lifecycleListener);
        if (!readOnlyEngine) {
            IRegistryView _createView;
            RegistryChangeListener _registryChangeListener;
            this.registryListener = _registryChangeListener = new RegistryChangeListener(this);
            IRegistryViewFactory _function_1 = new IRegistryViewFactory(){

                public IRegistryView createView(IQuerySpecificationRegistry it) {
                    return new AbstractRegistryView(registry, true){

                        protected boolean isEntryRelevant(IQuerySpecificationRegistryEntry entry) {
                            return true;
                        }
                    };
                }
            };
            this.view = _createView = registry.createView(_function_1);
            this.view.addViewListener((IQuerySpecificationRegistryChangeListener)this.registryListener);
        }
    }

    public QueryEvaluationHint setHint(QueryEvaluationHint hint) {
        QueryEvaluationHint _xblockexpression = null;
        Preconditions.checkNotNull((Object)hint);
        _xblockexpression = this.hint = hint;
        return _xblockexpression;
    }

    public QueryResultTreeMatcher createMatcher(ViatraQueryMatcher matcher) {
        final QueryResultTreeMatcher treeMatcher = new QueryResultTreeMatcher(this, matcher);
        IMatchProcessor<IPatternMatch> _function = new IMatchProcessor<IPatternMatch>(){

            public void process(final IPatternMatch match) {
                Procedures.Procedure1<IQueryResultViewModelListener> _function = new Procedures.Procedure1<IQueryResultViewModelListener>(){

                    public void apply(IQueryResultViewModelListener it) {
                        it.matchAdded(treeMatcher, match);
                    }
                };
                IterableExtensions.forEach((Iterable)QueryResultTreeInput.this.listeners, (Procedures.Procedure1)_function);
            }
        };
        Job matchCreatedJob = Jobs.newStatelessJob((CRUDActivationStateEnum)CRUDActivationStateEnum.CREATED, (IMatchProcessor)_function);
        IMatchProcessor<IPatternMatch> _function_1 = new IMatchProcessor<IPatternMatch>(){

            public void process(final IPatternMatch match) {
                Procedures.Procedure1<IQueryResultViewModelListener> _function = new Procedures.Procedure1<IQueryResultViewModelListener>(){

                    public void apply(IQueryResultViewModelListener it) {
                        it.matchUpdated(treeMatcher, match);
                    }
                };
                IterableExtensions.forEach((Iterable)QueryResultTreeInput.this.listeners, (Procedures.Procedure1)_function);
            }
        };
        Job matchUpdatedJob = Jobs.newStatelessJob((CRUDActivationStateEnum)CRUDActivationStateEnum.UPDATED, (IMatchProcessor)_function_1);
        IMatchProcessor<IPatternMatch> _function_2 = new IMatchProcessor<IPatternMatch>(){

            public void process(final IPatternMatch match) {
                Procedures.Procedure1<IQueryResultViewModelListener> _function = new Procedures.Procedure1<IQueryResultViewModelListener>(){

                    public void apply(IQueryResultViewModelListener it) {
                        it.matchRemoved(treeMatcher, match);
                    }
                };
                IterableExtensions.forEach((Iterable)QueryResultTreeInput.this.listeners, (Procedures.Procedure1)_function);
            }
        };
        Job matchDeletedJob = Jobs.newStatelessJob((CRUDActivationStateEnum)CRUDActivationStateEnum.DELETED, (IMatchProcessor)_function_2);
        ActivationLifeCycle _default = Lifecycles.getDefault((boolean)true, (boolean)true);
        RuleSpecification ruleSpec = Rules.newMatcherRuleSpecification((ViatraQueryMatcher)matcher, (ActivationLifeCycle)_default, Collections.unmodifiableSet(CollectionLiterals.newHashSet((Object[])new Job[]{matchCreatedJob, matchUpdatedJob, matchDeletedJob})));
        treeMatcher.setRuleSpec(ruleSpec);
        IQuerySpecification _specification = matcher.getSpecification();
        String fullyQualifiedName = _specification.getFullyQualifiedName();
        this.matchers.put(fullyQualifiedName, treeMatcher);
        Procedures.Procedure1<IQueryResultViewModelListener> _function_3 = new Procedures.Procedure1<IQueryResultViewModelListener>(){

            public void apply(IQueryResultViewModelListener it) {
                it.matcherAdded(treeMatcher);
            }
        };
        IterableExtensions.forEach(this.listeners, (Procedures.Procedure1)_function_3);
        this.schema.addRule(ruleSpec);
        return treeMatcher;
    }

    public Object addMatcherIfLoaded(IQuerySpecificationRegistryEntry entry) {
        String _fullyQualifiedName;
        Object _xifexpression = null;
        String _sourceIdentifier = entry.getSourceIdentifier();
        boolean _contains = this.loadedEntries.contains((Object)_sourceIdentifier, (Object)(_fullyQualifiedName = entry.getFullyQualifiedName()));
        if (_contains) {
            _xifexpression = null;
        }
        return _xifexpression;
    }

    public Object removeMatcherIfLoaded(IQuerySpecificationRegistryEntry entry) {
        String _fullyQualifiedName;
        Object _xifexpression = null;
        String _sourceIdentifier = entry.getSourceIdentifier();
        boolean _contains = this.loadedEntries.contains((Object)_sourceIdentifier, (Object)(_fullyQualifiedName = entry.getFullyQualifiedName()));
        if (_contains) {
            _xifexpression = null;
        }
        return _xifexpression;
    }

    public QueryResultTreeMatcher removeMatcher(IQuerySpecificationRegistryEntry entry) {
        boolean _notEquals;
        String _fullyQualifiedName = entry.getFullyQualifiedName();
        QueryResultTreeMatcher treeMatcher = this.matchers.get(_fullyQualifiedName);
        boolean _and = false;
        boolean bl = _notEquals = !Objects.equal((Object)treeMatcher, null);
        if (!_notEquals) {
            _and = false;
        } else {
            boolean _equals;
            IQuerySpecificationRegistryEntry _entry = treeMatcher.getEntry();
            String _sourceIdentifier = _entry.getSourceIdentifier();
            String _sourceIdentifier_1 = entry.getSourceIdentifier();
            _and = _equals = Objects.equal((Object)_sourceIdentifier, (Object)_sourceIdentifier_1);
        }
        if (_and) {
            return this.removeMatcher(treeMatcher);
        }
        return null;
    }

    public QueryResultTreeMatcher removeMatcher(final QueryResultTreeMatcher matcher) {
        ViatraQueryMatcher _matcher;
        boolean _notEquals_1;
        boolean _notEquals;
        IQuerySpecificationRegistryEntry _entry = matcher.getEntry();
        String _fullyQualifiedName = _entry.getFullyQualifiedName();
        this.matchers.remove(_fullyQualifiedName);
        Procedures.Procedure1<IQueryResultViewModelListener> _function = new Procedures.Procedure1<IQueryResultViewModelListener>(){

            public void apply(IQueryResultViewModelListener it) {
                it.matcherRemoved(matcher);
            }
        };
        IterableExtensions.forEach(this.listeners, (Procedures.Procedure1)_function);
        RuleSpecification _ruleSpec = matcher.getRuleSpec();
        boolean bl = _notEquals = !Objects.equal((Object)_ruleSpec, null);
        if (_notEquals) {
            RuleSpecification _ruleSpec_1 = matcher.getRuleSpec();
            this.schema.removeRule(_ruleSpec_1);
        }
        boolean bl2 = _notEquals_1 = !Objects.equal((Object)(_matcher = matcher.getMatcher()), null);
        if (_notEquals_1) {
            ViatraQueryMatcher _matcher_1 = matcher.getMatcher();
            IQuerySpecification _specification = _matcher_1.getSpecification();
            this.builder.forgetSpecificationTransitively(_specification);
        } else {
            boolean _notEquals_2;
            IQuerySpecificationRegistryEntry _entry_1 = matcher.getEntry();
            String _fullyQualifiedName_1 = _entry_1.getFullyQualifiedName();
            IQuerySpecification spec = this.builder.getSpecification(_fullyQualifiedName_1);
            boolean bl3 = _notEquals_2 = !Objects.equal((Object)spec, null);
            if (_notEquals_2) {
                this.builder.forgetSpecificationTransitively(spec);
            }
        }
        return matcher;
    }

    public void loadQueries(Iterable<IQuerySpecificationRegistryEntry> entries) {
        SpecificationBuilder _specificationBuilder;
        if (this.readOnlyEngine) {
            throw new UnsupportedOperationException("Cannot load queries to read-only engine");
        }
        this.builder = _specificationBuilder = new SpecificationBuilder();
        Procedures.Procedure1<IQuerySpecificationRegistryEntry> _function = new Procedures.Procedure1<IQuerySpecificationRegistryEntry>(){

            public void apply(IQuerySpecificationRegistryEntry entry) {
                String _fullyQualifiedName = entry.getFullyQualifiedName();
                boolean _containsKey = QueryResultTreeInput.this.matchers.containsKey(_fullyQualifiedName);
                if (_containsKey) {
                    QueryResultTreeInput.this.removeMatcher(entry);
                }
                QueryResultTreeInput.this.loadQuery(entry);
                String _sourceIdentifier = entry.getSourceIdentifier();
                String _fullyQualifiedName_1 = entry.getFullyQualifiedName();
                QueryResultTreeInput.this.loadedEntries.put((Object)_sourceIdentifier, (Object)_fullyQualifiedName_1, (Object)entry);
            }
        };
        IterableExtensions.forEach(entries, (Procedures.Procedure1)_function);
        this.schema.startUnscheduledExecution();
    }

    private QueryResultTreeMatcher loadQuery(IQuerySpecificationRegistryEntry entry) {
        QueryResultTreeMatcher _xblockexpression = null;
        String entryFQN = entry.getFullyQualifiedName();
        boolean _containsKey = this.matchers.containsKey(entryFQN);
        if (_containsKey) {
            this.removeMatcher(entry);
        }
        QueryResultTreeMatcher _xtrycatchfinallyexpression = null;
        try {
            IQuerySpecification<?> _specificationOfProvider;
            QueryResultTreeMatcher _xblockexpression_1 = null;
            IQuerySpecificationProvider _provider = entry.getProvider();
            IQuerySpecification<?> specification = _specificationOfProvider = this.getSpecificationOfProvider(_provider);
            QueryResultTreeMatcher _xifexpression = null;
            PQuery _internalQueryRepresentation = specification.getInternalQueryRepresentation();
            PQuery.PQueryStatus _status = _internalQueryRepresentation.getStatus();
            boolean _equals = Objects.equal((Object)_status, (Object)PQuery.PQueryStatus.ERROR);
            if (!_equals) {
                boolean _notEquals;
                this.engine.getMatcher(specification, this.hint);
                String specificationFQN = specification.getFullyQualifiedName();
                QueryResultTreeMatcher treeMatcher = this.matchers.get(specificationFQN);
                boolean bl = _notEquals = !Objects.equal((Object)specificationFQN, (Object)entryFQN);
                if (_notEquals) {
                    this.matchers.remove(specificationFQN);
                    this.matchers.put(entryFQN, treeMatcher);
                }
                treeMatcher.setEntry(entry);
                treeMatcher.setHint(this.hint);
                String _sourceIdentifier = entry.getSourceIdentifier();
                this.knownErrorEntries.remove((Object)_sourceIdentifier, (Object)entryFQN);
                return treeMatcher;
            }
            IllegalArgumentException _illegalArgumentException = new IllegalArgumentException("Query definition contains errors");
            _xifexpression = this.addErroneousMatcher(entry, _illegalArgumentException);
            _xtrycatchfinallyexpression = _xblockexpression_1 = _xifexpression;
        }
        catch (Throwable _t) {
            if (_t instanceof Exception) {
                Exception ex = (Exception)_t;
                return this.addErroneousMatcher(entry, ex);
            }
            throw Exceptions.sneakyThrow((Throwable)_t);
        }
        _xblockexpression = _xtrycatchfinallyexpression;
        return _xblockexpression;
    }

    private QueryResultTreeMatcher addErroneousMatcher(IQuerySpecificationRegistryEntry entry, Exception ex) {
        String entryFQN = entry.getFullyQualifiedName();
        final QueryResultTreeMatcher treeMatcher = new QueryResultTreeMatcher(this, null);
        treeMatcher.setException(ex);
        treeMatcher.setEntry(entry);
        this.matchers.put(entryFQN, treeMatcher);
        Procedures.Procedure1<IQueryResultViewModelListener> _function = new Procedures.Procedure1<IQueryResultViewModelListener>(){

            public void apply(IQueryResultViewModelListener it) {
                it.matcherAdded(treeMatcher);
            }
        };
        IterableExtensions.forEach(this.listeners, (Procedures.Procedure1)_function);
        String _sourceIdentifier = entry.getSourceIdentifier();
        boolean _put = this.knownErrorEntries.put((Object)_sourceIdentifier, (Object)entryFQN);
        if (_put) {
            String _message = ex.getMessage();
            String logMessage = String.format("Query Explorer has encountered an error during evaluation of query %s: %s", entryFQN, _message);
            ViatraQueryToolingBrowserPlugin _default = ViatraQueryToolingBrowserPlugin.getDefault();
            ILog _log = _default.getLog();
            ViatraQueryGUIPlugin _default_1 = ViatraQueryGUIPlugin.getDefault();
            Bundle _bundle = _default_1.getBundle();
            String _symbolicName = _bundle.getSymbolicName();
            Status _status = new Status(4, _symbolicName, logMessage, (Throwable)ex);
            _log.log((IStatus)_status);
        }
        return treeMatcher;
    }

    private IQuerySpecification<?> getSpecificationOfProvider(IQuerySpecificationProvider provider) {
        if (provider instanceof IPatternBasedSpecificationProvider) {
            IQuerySpecification<?> specification = ((IPatternBasedSpecificationProvider)provider).getSpecification(this.builder);
            return specification;
        }
        IQuerySpecification specification_1 = (IQuerySpecification)provider.get();
        return specification_1;
    }

    public boolean addListener(IQueryResultViewModelListener listener) {
        return this.listeners.add(listener);
    }

    public boolean removeListener(IQueryResultViewModelListener listener) {
        return this.listeners.remove(listener);
    }

    public IRegistryView dispose() {
        IRegistryView _xblockexpression = null;
        if (this.schema != null) {
            this.schema.dispose();
        }
        this.schema = null;
        if (this.engine != null) {
            this.engine.removeLifecycleListener((ViatraQueryEngineLifecycleListener)this.lifecycleListener);
        }
        this.engine = null;
        this.resetMatchers();
        this.listeners.clear();
        if (this.view != null) {
            this.view.removeViewListener((IQuerySpecificationRegistryChangeListener)this.registryListener);
        }
        this.view = null;
        _xblockexpression = null;
        return _xblockexpression;
    }

    protected void resetInput() {
        Collection<QueryResultTreeMatcher> _values = this.matchers.values();
        Procedures.Procedure1<QueryResultTreeMatcher> _function = new Procedures.Procedure1<QueryResultTreeMatcher>(){

            public void apply(QueryResultTreeMatcher it) {
                boolean _notEquals;
                RuleSpecification _ruleSpec = it.getRuleSpec();
                boolean bl = _notEquals = !Objects.equal((Object)_ruleSpec, null);
                if (_notEquals) {
                    RuleSpecification _ruleSpec_1 = it.getRuleSpec();
                    QueryResultTreeInput.this.schema.removeRule(_ruleSpec_1);
                }
            }
        };
        IterableExtensions.forEach(_values, (Procedures.Procedure1)_function);
        this.resetMatchers();
        if (!this.readOnlyEngine) {
            this.engine.removeLifecycleListener((ViatraQueryEngineLifecycleListener)this.lifecycleListener);
            this.engine.wipe();
            this.engine.addLifecycleListener((ViatraQueryEngineLifecycleListener)this.lifecycleListener);
        }
    }

    protected void resetMatchers() {
        SpecificationBuilder _specificationBuilder;
        Collection<QueryResultTreeMatcher> _values = this.matchers.values();
        Procedures.Procedure1<QueryResultTreeMatcher> _function = new Procedures.Procedure1<QueryResultTreeMatcher>(){

            public void apply(final QueryResultTreeMatcher matcher) {
                Procedures.Procedure1<IQueryResultViewModelListener> _function = new Procedures.Procedure1<IQueryResultViewModelListener>(){

                    public void apply(IQueryResultViewModelListener it) {
                        it.matcherRemoved(matcher);
                    }
                };
                IterableExtensions.forEach((Iterable)QueryResultTreeInput.this.listeners, (Procedures.Procedure1)_function);
            }
        };
        IterableExtensions.forEach(_values, (Procedures.Procedure1)_function);
        this.builder = _specificationBuilder = new SpecificationBuilder();
        this.matchers.clear();
        this.loadedEntries.clear();
    }

    public BaseIndexOptions getBaseIndexOptions() {
        QueryScope _scope = this.engine.getScope();
        EMFScope emfScope = (EMFScope)_scope;
        return emfScope.getOptions();
    }

    public Iterable<IFilteredMatcherContent> getFilteredMatchers() {
        Collection<QueryResultTreeMatcher> _values = this.matchers.values();
        return Iterables.filter(_values, IFilteredMatcherContent.class);
    }

    public void matcherFilterUpdated(final QueryResultTreeMatcher matcher) {
        Procedures.Procedure1<IQueryResultViewModelListener> _function = new Procedures.Procedure1<IQueryResultViewModelListener>(){

            public void apply(IQueryResultViewModelListener it) {
                it.matcherFilterUpdated(matcher);
            }
        };
        IterableExtensions.forEach(this.listeners, (Procedures.Procedure1)_function);
    }

    @Pure
    public AdvancedViatraQueryEngine getEngine() {
        return this.engine;
    }

    @Pure
    public boolean isReadOnlyEngine() {
        return this.readOnlyEngine;
    }

    @Pure
    public Map<String, QueryResultTreeMatcher> getMatchers() {
        return this.matchers;
    }

    @Pure
    public IModelConnector getModelConnector() {
        return this.modelConnector;
    }

    protected void setModelConnector(IModelConnector modelConnector) {
        this.modelConnector = modelConnector;
    }

    @Pure
    public QueryEvaluationHint getHint() {
        return this.hint;
    }

    @FinalFieldsConstructor
    public static class EngineLifecycleListener
    implements ViatraQueryEngineLifecycleListener {
        private final QueryResultTreeInput input;

        public void engineBecameTainted(String message, Throwable t) {
            this.input.dispose();
        }

        public void engineDisposed() {
            this.input.dispose();
        }

        public void engineWiped() {
            this.input.resetInput();
        }

        public void matcherInstantiated(ViatraQueryMatcher<? extends IPatternMatch> matcher) {
            this.input.createMatcher(matcher);
        }

        public EngineLifecycleListener(QueryResultTreeInput input) {
            this.input = input;
        }
    }

    @FinalFieldsConstructor
    public static class RegistryChangeListener
    implements IQuerySpecificationRegistryChangeListener {
        private final QueryResultTreeInput input;

        public void entryAdded(IQuerySpecificationRegistryEntry entry) {
            this.input.addMatcherIfLoaded(entry);
        }

        public void entryRemoved(IQuerySpecificationRegistryEntry entry) {
            this.input.removeMatcherIfLoaded(entry);
        }

        public RegistryChangeListener(QueryResultTreeInput input) {
            this.input = input;
        }
    }
}

