/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.query.tooling.ui.queryexplorer.content.detail;

import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Singleton;
import java.lang.reflect.Method;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.jface.databinding.viewers.ObservableListContentProvider;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.viatra.query.runtime.api.IQuerySpecification;
import org.eclipse.viatra.query.runtime.matchers.psystem.queries.PParameter;
import org.eclipse.viatra.query.tooling.ui.queryexplorer.content.detail.DetailComparator;
import org.eclipse.viatra.query.tooling.ui.queryexplorer.content.detail.DetailElementCellModifier;
import org.eclipse.viatra.query.tooling.ui.queryexplorer.content.detail.DetailElementLabelProvider;
import org.eclipse.viatra.query.tooling.ui.queryexplorer.content.detail.DetailObserver;
import org.eclipse.viatra.query.tooling.ui.queryexplorer.content.detail.MatcherConfiguration;
import org.eclipse.viatra.query.tooling.ui.queryexplorer.content.detail.MatcherConfigurationCellModifier;
import org.eclipse.viatra.query.tooling.ui.queryexplorer.content.detail.MatcherConfigurationContentProvider;
import org.eclipse.viatra.query.tooling.ui.queryexplorer.content.detail.MatcherConfigurationLabelProvider;
import org.eclipse.viatra.query.tooling.ui.queryexplorer.content.detail.ModelElementCellEditor;
import org.eclipse.viatra.query.tooling.ui.queryexplorer.content.matcher.PatternMatchContent;
import org.eclipse.viatra.query.tooling.ui.queryexplorer.content.matcher.PatternMatcherContent;
import org.eclipse.viatra.query.tooling.ui.queryexplorer.util.QueryExplorerPatternRegistry;

@Singleton
public class DetailsViewerUtil {
    @Inject
    private Injector injector;
    private final Set<String> primitiveTypes = new HashSet<String>();

    protected DetailsViewerUtil() {
        this.primitiveTypes.add(Boolean.class.getName());
        this.primitiveTypes.add(Character.class.getName());
        this.primitiveTypes.add(Byte.class.getName());
        this.primitiveTypes.add(Short.class.getName());
        this.primitiveTypes.add(Integer.class.getName());
        this.primitiveTypes.add(Long.class.getName());
        this.primitiveTypes.add(Float.class.getName());
        this.primitiveTypes.add(Double.class.getName());
        this.primitiveTypes.add(Void.class.getName());
        this.primitiveTypes.add(String.class.getName());
    }

    public boolean isPrimitiveType(String fqn) {
        return this.primitiveTypes.contains(fqn);
    }

    public void prepareFor(PatternMatchContent match, TableViewer viewer) {
        this.clearTableViewerColumns(viewer);
        String[] titles = new String[]{"Parameter", "Value"};
        this.createColumns(viewer, titles);
        viewer.setUseHashlookup(true);
        viewer.setColumnProperties(titles);
        viewer.setContentProvider((IContentProvider)new ObservableListContentProvider());
        viewer.setLabelProvider((IBaseLabelProvider)new DetailElementLabelProvider());
        viewer.setCellModifier((ICellModifier)new DetailElementCellModifier());
        viewer.setComparator(new ViewerComparator((Comparator)new DetailComparator(match.getPatternMatch().parameterNames())));
        DetailObserver observer = new DetailObserver(match);
        viewer.setInput((Object)observer);
    }

    public void prepareFor(PatternMatcherContent observableMatcher, TableViewer viewer) {
        MatcherConfiguration[] input;
        this.clearTableViewerColumns(viewer);
        String[] titles = new String[]{"Parameter", "Filter", "Class"};
        this.createColumns(viewer, titles);
        viewer.setUseHashlookup(true);
        viewer.setColumnProperties(titles);
        viewer.setContentProvider((IContentProvider)new MatcherConfigurationContentProvider());
        viewer.setLabelProvider((IBaseLabelProvider)new MatcherConfigurationLabelProvider());
        viewer.setCellModifier((ICellModifier)new MatcherConfigurationCellModifier(viewer));
        viewer.setComparator(new ViewerComparator((Comparator)new DetailComparator(observableMatcher.getMatcher().getParameterNames())));
        Table table = viewer.getTable();
        CellEditor[] editors = new CellEditor[titles.length];
        editors[0] = new TextCellEditor((Composite)table);
        ModelElementCellEditor cellEditor = new ModelElementCellEditor(table, observableMatcher);
        this.injector.injectMembers((Object)cellEditor);
        editors[1] = cellEditor;
        editors[2] = new TextCellEditor((Composite)table);
        viewer.setCellEditors(editors);
        IQuerySpecification<?> specification = QueryExplorerPatternRegistry.getInstance().getPatternByFqn(observableMatcher.getPatternName());
        Object[] filter = observableMatcher.getFilter();
        if (specification != null) {
            input = new MatcherConfiguration[specification.getParameters().size()];
            if (filter != null) {
                int i = 0;
                while (i < specification.getParameters().size()) {
                    PParameter var = (PParameter)specification.getParameters().get(i);
                    input[i] = new MatcherConfiguration(var.getName(), var.getTypeName(), filter[i]);
                    ++i;
                }
            }
        } else {
            input = new MatcherConfiguration[]{};
        }
        viewer.setInput((Object)input);
    }

    public void clearTableViewerColumns(TableViewer viewer) {
        if (viewer.getContentProvider() != null) {
            viewer.setInput(null);
        }
        while (viewer.getTable().getColumnCount() > 0) {
            viewer.getTable().getColumns()[0].dispose();
        }
        if (viewer.getCellEditors() != null) {
            CellEditor[] cellEditorArray = viewer.getCellEditors();
            int n = cellEditorArray.length;
            int n2 = 0;
            while (n2 < n) {
                CellEditor cellEditor = cellEditorArray[n2];
                cellEditor.dispose();
                ++n2;
            }
        }
        viewer.refresh();
    }

    private void createColumns(TableViewer viewer, String[] titles) {
        int i = 0;
        while (i < titles.length) {
            this.createTableViewerColumn(viewer, titles[i], i);
            ++i;
        }
    }

    private TableViewerColumn createTableViewerColumn(TableViewer viewer, String title, int index) {
        TableViewerColumn viewerColumn = new TableViewerColumn(viewer, 0, index);
        TableColumn column = viewerColumn.getColumn();
        column.setText(title);
        column.setResizable(true);
        column.setMoveable(true);
        column.setWidth(150);
        return viewerColumn;
    }

    public Object createValue(String classFqn, Object value) {
        if (!(value instanceof String)) {
            return value;
        }
        if (value.toString().matches("")) {
            return null;
        }
        if (String.class.getName().matches(classFqn)) {
            return value;
        }
        try {
            Class<?> clazz = Class.forName(classFqn);
            Method method = clazz.getMethod("valueOf", String.class);
            return method.invoke(null, value);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public boolean isValidValue(String classFqn, String value) {
        classFqn = classFqn.toLowerCase();
        if (Boolean.class.getName().toLowerCase().matches(classFqn)) {
            return value.toLowerCase().matches("true") || value.toLowerCase().matches("false");
        }
        if (Character.class.getName().toLowerCase().matches(classFqn)) {
            return true;
        }
        if (Byte.class.getName().toLowerCase().matches(classFqn) || Short.class.getName().toLowerCase().matches(classFqn) || Integer.class.getName().toLowerCase().matches(classFqn) || Long.class.getName().toLowerCase().matches(classFqn)) {
            return value.matches("[0-9]*");
        }
        if (Float.class.getName().toLowerCase().matches(classFqn) || Double.class.getName().toLowerCase().matches(classFqn)) {
            return value.matches("[0-9]*\\.?[0-9]*");
        }
        return true;
    }
}

