/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.query.tooling.ui.queryexplorer.content.patternsviewer;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.viatra.query.tooling.ui.queryexplorer.QueryExplorer;
import org.eclipse.viatra.query.tooling.ui.queryexplorer.content.patternsviewer.PatternComposite;

public abstract class PatternComponent {
    protected String patternNameFragment;
    protected boolean selected = true;
    protected PatternComposite parent;

    public PatternComposite getParent() {
        return this.parent;
    }

    public boolean getCheckedState() {
        return this.selected;
    }

    public abstract void updateHasChildren();

    public Collection<PatternComponent> setCheckedState(boolean checked) {
        HashSet<PatternComponent> changedComponents = new HashSet<PatternComponent>();
        if (this.selected != checked) {
            changedComponents.add(this);
            this.selected = checked;
            if (QueryExplorer.getInstance() != null) {
                QueryExplorer.getInstance().getPatternsViewer().setChecked((Object)this, checked);
            }
        }
        changedComponents.addAll(this.propagateSelectionStateDownwards());
        if (this.getParent() != null) {
            changedComponents.addAll(this.getParent().propagateSelectionStateUpwards());
        }
        return changedComponents;
    }

    protected Set<PatternComponent> propagateSelectionStateUpwards() {
        return Collections.emptySet();
    }

    protected Set<PatternComponent> propagateSelectionStateDownwards() {
        return Collections.emptySet();
    }

    public abstract String getFullPatternNamePrefix();

    public String getPatternNameFragment() {
        return this.patternNameFragment;
    }

    public String toString() {
        return this.patternNameFragment;
    }
}

