/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.query.tooling.ui.queryexplorer.handlers;

import com.google.common.collect.Maps;
import com.google.inject.Inject;
import com.google.inject.Injector;
import java.util.Map;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.viatra.query.tooling.ui.queryexplorer.handlers.RuntimeMatcherRegistrator;
import org.eclipse.viatra.query.tooling.ui.queryexplorer.util.AttachFileEditorPartListener;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.ui.editor.model.IXtextModelListener;
import org.eclipse.xtext.ui.editor.model.XtextDocument;
import org.eclipse.xtext.util.concurrent.IUnitOfWork;
import org.eclipse.xtext.xbase.ui.editor.XbaseEditor;

public class AttachVqlEditorRegistrationHandler
extends AbstractHandler {
    @Inject
    private Injector injector;
    private Map<IFile, TrickyXtextModelListener> listenerMap = Maps.newHashMap();
    private AttachFileEditorPartListener pListener = new AttachFileEditorPartListener(this);
    private boolean pListenerRegistered = false;

    public boolean thereIsAnAttachedEditorForFile(IFile f) {
        return this.listenerMap.containsKey(f);
    }

    public void removeAttachmentRegistrationForFile(IFile f) {
        this.listenerMap.remove(f);
    }

    private void registerListener(XbaseEditor editor) {
        FileEditorInput input = (FileEditorInput)editor.getEditorInput();
        IFile targetfile = input.getFile();
        XtextDocument doc = (XtextDocument)editor.getDocument();
        if (this.listenerMap.containsKey(targetfile)) {
            doc.removeModelListener((IXtextModelListener)this.listenerMap.get(targetfile));
        }
        final TrickyXtextModelListener l = new TrickyXtextModelListener(targetfile);
        doc.addModelListener((IXtextModelListener)l);
        this.listenerMap.put(targetfile, l);
        doc.readOnly((IUnitOfWork)new IUnitOfWork<Object, XtextResource>(){

            public String exec(XtextResource resource) {
                l.modelChanged(resource);
                return null;
            }
        });
        if (!this.pListenerRegistered) {
            editor.getEditorSite().getPage().addPartListener((IPartListener)this.pListener);
            this.pListenerRegistered = true;
        }
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        IEditorPart editor = HandlerUtil.getActiveEditor((ExecutionEvent)event);
        if (editor instanceof XbaseEditor) {
            this.registerListener((XbaseEditor)editor);
        }
        return null;
    }

    private class TrickyXtextModelListener
    implements IXtextModelListener {
        IFile targetFile = null;

        public TrickyXtextModelListener(IFile f) {
            this.targetFile = f;
        }

        public void modelChanged(XtextResource resource) {
            if (resource != null && resource.getErrors().isEmpty()) {
                RuntimeMatcherRegistrator registrator = new RuntimeMatcherRegistrator(this.targetFile, (Resource)resource);
                AttachVqlEditorRegistrationHandler.this.injector.injectMembers((Object)registrator);
                Display.getDefault().syncExec((Runnable)registrator);
            }
        }
    }
}

