/**
 * Copyright (c) 2010-2016, Peter Lunk, IncQuery Labs Ltd.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *   Peter Lunk - initial API and implementation
 */
package org.eclipse.viatra.transformation.debug.configuration;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.viatra.transformation.debug.TransformationDebugger;
import org.eclipse.viatra.transformation.evm.api.adapter.IAdapterConfiguration;
import org.eclipse.viatra.transformation.evm.api.adapter.IEVMAdapter;
import org.eclipse.viatra.transformation.evm.api.adapter.IEVMListener;

/**
 * Configuration class that defines the debugger.
 * 
 * @author Peter Lunk
 */
@SuppressWarnings("all")
public class TransformationDebuggerConfiguration implements IAdapterConfiguration {
  private List<IEVMAdapter> adapters;
  
  private List<IEVMListener> listeners;
  
  public TransformationDebuggerConfiguration() {
    long _nanoTime = System.nanoTime();
    String _string = Long.valueOf(_nanoTime).toString();
    final String id = ("Transformation_" + _string);
    ArrayList<IEVMAdapter> _newArrayList = Lists.<IEVMAdapter>newArrayList();
    this.adapters = _newArrayList;
    ArrayList<IEVMListener> _newArrayList_1 = Lists.<IEVMListener>newArrayList();
    this.listeners = _newArrayList_1;
    final TransformationDebugger debugger = new TransformationDebugger(id);
    this.listeners.add(debugger);
    this.adapters.add(debugger);
  }
  
  @Override
  public List<IEVMAdapter> getAdapters() {
    return this.adapters;
  }
  
  @Override
  public List<IEVMListener> getListeners() {
    return this.listeners;
  }
}
