/**
 * 
 *   Copyright (c) 2010-2015, Csaba Debreceni, Istvan Rath and Daniel Varro
 *   All rights reserved. This program and the accompanying materials
 *   are made available under the terms of the Eclipse Public License v1.0
 *   which accompanies this distribution, and is available at
 *   http://www.eclipse.org/legal/epl-v10.html
 *  
 *   Contributors:
 *     Csaba Debreceni - initial API and implementation
 *  
 */
package org.eclipse.viatra.transformation.views.traceability.patterns.util;

import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.viatra.query.runtime.api.ViatraQueryEngine;
import org.eclipse.viatra.query.runtime.api.impl.BaseGeneratedEMFPQuery;
import org.eclipse.viatra.query.runtime.api.impl.BaseGeneratedEMFQuerySpecification;
import org.eclipse.viatra.query.runtime.emf.types.EClassTransitiveInstancesKey;
import org.eclipse.viatra.query.runtime.emf.types.EStructuralFeatureInstancesKey;
import org.eclipse.viatra.query.runtime.exception.ViatraQueryException;
import org.eclipse.viatra.query.runtime.matchers.backend.QueryEvaluationHint;
import org.eclipse.viatra.query.runtime.matchers.context.IInputKey;
import org.eclipse.viatra.query.runtime.matchers.psystem.PBody;
import org.eclipse.viatra.query.runtime.matchers.psystem.PVariable;
import org.eclipse.viatra.query.runtime.matchers.psystem.annotations.PAnnotation;
import org.eclipse.viatra.query.runtime.matchers.psystem.basicdeferred.Equality;
import org.eclipse.viatra.query.runtime.matchers.psystem.basicdeferred.ExportedParameter;
import org.eclipse.viatra.query.runtime.matchers.psystem.basicenumerables.TypeConstraint;
import org.eclipse.viatra.query.runtime.matchers.psystem.queries.PParameter;
import org.eclipse.viatra.query.runtime.matchers.psystem.queries.PParameterDirection;
import org.eclipse.viatra.query.runtime.matchers.psystem.queries.QueryInitializationException;
import org.eclipse.viatra.query.runtime.matchers.tuple.FlatTuple;
import org.eclipse.viatra.transformation.views.traceability.patterns.Trace2paramMatch;
import org.eclipse.viatra.transformation.views.traceability.patterns.Trace2paramMatcher;

/**
 * A pattern-specific query specification that can instantiate Trace2paramMatcher in a type-safe way.
 * 
 * @see Trace2paramMatcher
 * @see Trace2paramMatch
 * 
 */
@SuppressWarnings("all")
public final class Trace2paramQuerySpecification extends BaseGeneratedEMFQuerySpecification<Trace2paramMatcher> {
  private Trace2paramQuerySpecification() {
    super(GeneratedPQuery.INSTANCE);
  }
  
  /**
   * @return the singleton instance of the query specification
   * @throws ViatraQueryException if the pattern definition could not be loaded
   * 
   */
  public static Trace2paramQuerySpecification instance() throws ViatraQueryException {
    try{
    	return LazyHolder.INSTANCE;
    } catch (ExceptionInInitializerError err) {
    	throw processInitializerError(err);
    }
  }
  
  @Override
  protected Trace2paramMatcher instantiate(final ViatraQueryEngine engine) throws ViatraQueryException {
    return Trace2paramMatcher.on(engine);
  }
  
  @Override
  public Trace2paramMatcher instantiate() throws ViatraQueryException {
    return Trace2paramMatcher.create();
  }
  
  @Override
  public Trace2paramMatch newEmptyMatch() {
    return Trace2paramMatch.newEmptyMatch();
  }
  
  @Override
  public Trace2paramMatch newMatch(final Object... parameters) {
    return Trace2paramMatch.newMatch((org.eclipse.emf.ecore.EObject) parameters[0], (org.eclipse.viatra.transformation.views.traceability.Trace) parameters[1], (java.lang.String) parameters[2]);
  }
  
  /**
   * Inner class allowing the singleton instance of {@link Trace2paramQuerySpecification} to be created 
   * 	<b>not</b> at the class load time of the outer class, 
   * 	but rather at the first call to {@link Trace2paramQuerySpecification#instance()}.
   * 
   * <p> This workaround is required e.g. to support recursion.
   * 
   */
  private static class LazyHolder {
    private final static Trace2paramQuerySpecification INSTANCE = new Trace2paramQuerySpecification();
    
    /**
     * Statically initializes the query specification <b>after</b> the field {@link #INSTANCE} is assigned.
     * This initialization order is required to support indirect recursion.
     * 
     * <p> The static initializer is defined using a helper field to work around limitations of the code generator.
     * 
     */
    private final static Object STATIC_INITIALIZER = ensureInitialized();
    
    public static Object ensureInitialized() {
      INSTANCE.ensureInitializedInternalSneaky();
      return null;
    }
  }
  
  private static class GeneratedPQuery extends BaseGeneratedEMFPQuery {
    private final static Trace2paramQuerySpecification.GeneratedPQuery INSTANCE = new GeneratedPQuery();
    
    private final PParameter parameter_pParam = new PParameter("param", "org.eclipse.emf.ecore.EObject", new EClassTransitiveInstancesKey((EClass)getClassifierLiteralSafe("http://www.eclipse.org/emf/2002/Ecore", "EObject")), PParameterDirection.INOUT);
    
    private final PParameter parameter_pTrace = new PParameter("trace", "org.eclipse.viatra.transformation.views.traceability.Trace", new EClassTransitiveInstancesKey((EClass)getClassifierLiteralSafe("http://www.eclipse.org/viatra/transformation/views/traceability/1.0", "Trace")), PParameterDirection.INOUT);
    
    private final PParameter parameter_pId = new PParameter("id", "java.lang.String", (IInputKey)null, PParameterDirection.INOUT);
    
    private final List<PParameter> parameters = Arrays.asList(parameter_pParam, parameter_pTrace, parameter_pId);
    
    @Override
    public String getFullyQualifiedName() {
      return "org.eclipse.viatra.transformation.views.traceability.patterns.trace2param";
    }
    
    @Override
    public List<String> getParameterNames() {
      return Arrays.asList("param","trace","id");
    }
    
    @Override
    public List<PParameter> getParameters() {
      return parameters;
    }
    
    @Override
    public Set<PBody> doGetContainedBodies() throws QueryInitializationException {
      setEvaluationHints(new QueryEvaluationHint(null, Collections.<String,Object>emptyMap()));
      Set<PBody> bodies = Sets.newLinkedHashSet();
      try {
      	{
      		PBody body = new PBody(this);
      		PVariable var_param = body.getOrCreateVariableByName("param");
      		PVariable var_trace = body.getOrCreateVariableByName("trace");
      		PVariable var_id = body.getOrCreateVariableByName("id");
      		new TypeConstraint(body, new FlatTuple(var_param), new EClassTransitiveInstancesKey((EClass)getClassifierLiteral("http://www.eclipse.org/emf/2002/Ecore", "EObject")));
      		new TypeConstraint(body, new FlatTuple(var_trace), new EClassTransitiveInstancesKey((EClass)getClassifierLiteral("http://www.eclipse.org/viatra/transformation/views/traceability/1.0", "Trace")));
      		body.setSymbolicParameters(Arrays.<ExportedParameter>asList(
      		   new ExportedParameter(body, var_param, parameter_pParam),
      		   new ExportedParameter(body, var_trace, parameter_pTrace),
      		   new ExportedParameter(body, var_id, parameter_pId)
      		));
      		// 	Trace.params(trace, param)
      		new TypeConstraint(body, new FlatTuple(var_trace), new EClassTransitiveInstancesKey((EClass)getClassifierLiteral("http://www.eclipse.org/viatra/transformation/views/traceability/1.0", "Trace")));
      		PVariable var__virtual_0_ = body.getOrCreateVariableByName(".virtual{0}");
      		new TypeConstraint(body, new FlatTuple(var_trace, var__virtual_0_), new EStructuralFeatureInstancesKey(getFeatureLiteral("http://www.eclipse.org/viatra/transformation/views/traceability/1.0", "Trace", "params")));
      		new Equality(body, var__virtual_0_, var_param);
      		// 	Trace.id(trace, id)
      		new TypeConstraint(body, new FlatTuple(var_trace), new EClassTransitiveInstancesKey((EClass)getClassifierLiteral("http://www.eclipse.org/viatra/transformation/views/traceability/1.0", "Trace")));
      		PVariable var__virtual_1_ = body.getOrCreateVariableByName(".virtual{1}");
      		new TypeConstraint(body, new FlatTuple(var_trace, var__virtual_1_), new EStructuralFeatureInstancesKey(getFeatureLiteral("http://www.eclipse.org/viatra/transformation/views/traceability/1.0", "Trace", "id")));
      		new Equality(body, var__virtual_1_, var_id);
      		bodies.add(body);
      	}
      	{
      		PAnnotation annotation = new PAnnotation("QueryExplorer");
      		annotation.addAttribute("checked", false);
      		addAnnotation(annotation);
      	}
      	// to silence compiler error
      	if (false) throw new ViatraQueryException("Never", "happens");
      } catch (ViatraQueryException ex) {
      	throw processDependencyException(ex);
      }
      return bodies;
    }
  }
}
