/**
 * 
 *   Copyright (c) 2010-2015, Csaba Debreceni, Istvan Rath and Daniel Varro
 *   All rights reserved. This program and the accompanying materials
 *   are made available under the terms of the Eclipse Public License v1.0
 *   which accompanies this distribution, and is available at
 *   http://www.eclipse.org/legal/epl-v10.html
 *  
 *   Contributors:
 *     Csaba Debreceni - initial API and implementation
 *  
 */
package org.eclipse.viatra.transformation.views.traceability.patterns.util;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.viatra.query.runtime.api.IMatchProcessor;
import org.eclipse.viatra.transformation.views.traceability.Trace;
import org.eclipse.viatra.transformation.views.traceability.patterns.Trace2targetMatch;

/**
 * A match processor tailored for the org.eclipse.viatra.transformation.views.traceability.patterns.trace2target pattern.
 * 
 * Clients should derive an (anonymous) class that implements the abstract process().
 * 
 */
@SuppressWarnings("all")
public abstract class Trace2targetProcessor implements IMatchProcessor<Trace2targetMatch> {
  /**
   * Defines the action that is to be executed on each match.
   * @param pTarget the value of pattern parameter target in the currently processed match
   * @param pTrace the value of pattern parameter trace in the currently processed match
   * 
   */
  public abstract void process(final EObject pTarget, final Trace pTrace);
  
  @Override
  public void process(final Trace2targetMatch match) {
    process(match.getTarget(), match.getTrace());
  }
}
