/**
 * 
 *   Copyright (c) 2010-2015, Csaba Debreceni, Istvan Rath and Daniel Varro
 *   All rights reserved. This program and the accompanying materials
 *   are made available under the terms of the Eclipse Public License v1.0
 *   which accompanies this distribution, and is available at
 *   http://www.eclipse.org/legal/epl-v10.html
 *  
 *   Contributors:
 *     Csaba Debreceni - initial API and implementation
 *  
 */
package org.eclipse.viatra.transformation.views.traceability.patterns.util;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.viatra.query.runtime.api.IMatchProcessor;
import org.eclipse.viatra.transformation.views.traceability.Trace;
import org.eclipse.viatra.transformation.views.traceability.patterns.TraceMatch;

/**
 * A match processor tailored for the org.eclipse.viatra.transformation.views.traceability.patterns.trace pattern.
 * 
 * Clients should derive an (anonymous) class that implements the abstract process().
 * 
 */
@SuppressWarnings("all")
public abstract class TraceProcessor implements IMatchProcessor<TraceMatch> {
  /**
   * Defines the action that is to be executed on each match.
   * @param pSource the value of pattern parameter source in the currently processed match
   * @param pId the value of pattern parameter id in the currently processed match
   * @param pTarget the value of pattern parameter target in the currently processed match
   * @param pTrace the value of pattern parameter trace in the currently processed match
   * @param pTraceabilityId the value of pattern parameter traceabilityId in the currently processed match
   * 
   */
  public abstract void process(final EObject pSource, final String pId, final EObject pTarget, final Trace pTrace, final String pTraceabilityId);
  
  @Override
  public void process(final TraceMatch match) {
    process(match.getSource(), match.getId(), match.getTarget(), match.getTrace(), match.getTraceabilityId());
  }
}
